/* Copyright (C) 2005, University of Massachusetts, Multi-Agent Systems Lab
 * See LICENSE for license information
 */

/***************************************************************************************
 *	Reaction.java
 ***************************************************************************************/

package simulator.script;

/* Global Includes */
import java.io.*;
import java.util.*;
import java.awt.*;

/* Local Includes */
import simulator.*;
import utilities.*;

/**
 * Base class for the script reactions.  The Reaction classes are those
 * which actually produce change within the simulator, so that if you want
 * your script to do anything (one would hope you do), you supply one
 * or more of these to indicate what it is to do.
 * <P>
 * The pertinant method in the class is realize, which causes the effects
 * of a reaction.  The Script will call this method when the appropriate
 * Assertions are found to be true. 
 * <P>
 * By convention, we hope that event authors place the supported data
 * descriptions in the header comments for their classes.  Take a look at
 * some of the other source files for examples of how to do this.
 * @see simulator.script.Write
 */
public class Reaction {
  private Hashtable data;

  /**
   * Constructor.
   */
  public Reaction(String d) {

    data = Script.parseDataLine(d);
  }
  
  /**
   * Init, usually you will retrieve input properties here, and setup
   * any state you need to.  Called once by the Script the Reaction
   * belongs to, as it is added to the Script.
   * @see utilities.Converter#reTypeProperty
   */  
  public void init() {
  }

  /**
   * Starts the reaction
   * @return True if it was sucessfull, false otherwise
   */
  public boolean realize() {
    return false;
  }

  /**
   * Returns the input data table
   */
  public Hashtable getData() { return data; }

  /**
   * Returns the name of the object
   */
  public String getName() {
	String name = getClass().getName();
	return name.substring(name.lastIndexOf(".") + 1);
  }

  /**
   * Stringify
   */
  public String toString() {
	StringBuffer sb = new StringBuffer(getName() + " - ");
	Enumeration e = getData().keys();
	while (e.hasMoreElements()) {
		Object key = e.nextElement();
		sb.append(key + ":" + getData().get(key));
		if (e.hasMoreElements())
			sb.append("; ");
	}
	return sb.toString();
  }
}
