/* Copyright (C) 2005, University of Massachusetts, Multi-Agent Systems Lab
 * See LICENSE for license information
 */

/***************************************************************************************
 *	Probability.java
 ***************************************************************************************/

package simulator.script;

import utilities.TaemsRandom;
import java.util.*;

/**
 * Simple assertion which returns a true check value some specified
 * percentage of the time.
 * <P>
 * <B>Data</B><BR>
 * <UL>
 * <LI>Probability:Float - Chance that this assertion is true (range 0.0 - 1.0)
 * </UL>
 */
public class Probability extends Assertion {
  Random random;
  float prob;

  /**
   * Constructor.
   */
  public Probability(String d) {
    super(d);
  }
  
  /**
   * Init.
   */  
  public void init() {
    
    // Make Random
    random = new Random(TaemsRandom.getDefault().getSeed());

    // Get the time
    prob = Float.valueOf((String)getData().get("Probability")).floatValue();

    super.init();
  }

  /**
   * Checks the assertion.
   */
  public boolean check() {

    if (prob <= (float)0)
      return false;
    if (prob >= (float)1)
      return true;

    float value = random.nextFloat();
    return (value < prob);
  }
}
