/* Copyright (C) 2005, University of Massachusetts, Multi-Agent Systems Lab
 * See LICENSE for license information
 */

/***************************************************************************************
 *	Period.java
 ***************************************************************************************/

package simulator.script;

import utilities.Clock;
import java.util.*;

/**
 * This assertion fires periodically, every Period time units
 * starting with time Start.
 * <P>
 * <B>Data</B><BR>
 * <UL>
 * <LI>Period:Int - Length of the period to have
 * <LI>Start:Int - Length of the period to have
 * </UL>
 */
public class Period extends Assertion {
  Random random;
  int period;
  int start;

  /**
   * Constructor.
   */
  public Period(String d) {
    super(d);
  }
  
  /**
   * Init.
   */  
  public void init() {
    
    // Get the start
    start = Integer.parseInt((String)getData().get("Start"));

    // Get the period
    period = Integer.parseInt((String)getData().get("Period"));

    super.init();
  }

  /**
   * Checks the assertion.
   */
  public boolean check() {
    int t = Clock.getTime();

    if ((t >= start) && ((t - start) % period == 0))
      return true;

    return false;
  }
}
