/* Copyright (C) 2005, University of Massachusetts, Multi-Agent Systems Lab
 * See LICENSE for license information
 */

/***************************************************************************************
 *	NumAgentConnected.java
 ***************************************************************************************/

package simulator.script;

import simulator.*;
import java.util.*;

/**
 * Checks the currently connected number of agents
 * <P>
 * <B>Data</B><BR>
 * <UL>
 * <LI>Value:Integer - Number of agents to look for
 * <LI>Op:String - Comparison operator (e.g. "==", ">", "<", ">=", "<=", "!=")
 * (optional, default ==)
 * </UL>
 */
public class NumAgentConnected extends Assertion {
  String op = "==";
  int num;

  /**
   * Constructor.
   */
  public NumAgentConnected(String d) {
    super(d);
  }
  
  /**
   * Init.
   */  
  public void init() {
    
    // Get it
    num = Integer.parseInt((String)getData().get("Value"));

    // Get the operator
    if (getData().containsKey("Op"))
      op = (String)getData().get("Op");

    super.init();
  }

  /**
   * Checks the assertion.
   */
  public boolean check() {
    int cur = Simulator.getAgentTable().size();

    if (op.equals("==")) {
      return (cur == num);

    } if (op.equals(">")) {
      return (cur > num);

    } if (op.equals("<")) {
      return (cur < num);

    } if (op.equals(">=")) {
      return (cur >= num);

    } if (op.equals("<=")) {
      return (cur <= num);

    } if (op.equals("!=")) {
      return (cur != num);
    }

    return false;
  }
}
