/* Copyright (C) 2005, University of Massachusetts, Multi-Agent Systems Lab
 * See LICENSE for license information
 */

/***************************************************************************************
 *	GrammarEvent.java
 ***************************************************************************************/

package simulator.script;

import java.util.*;

/**
 * Sends a grammar reaction event to an agent.  This is essentially
 * a specialization of the SendMessage reaction.
 * <P>
 * <B>Data</B><BR>
 * <UL>
 * <LI>Agent:String - The name of the recipient
 * <LI>Event:String - The event id of the reaction, as specified (hopefully)
 * in the agent's TAEMS grammar.
 * </UL>
 */
public class GrammarEvent extends SendMessage {

  /**
   * Constructor.
   */
  public GrammarEvent(String d) {
    super(d);
  }
  
  /**
   * Init.
   */  
  public void init() {
    super.init();

    // Agent
    agent = (String)getData().get("Agent");

    // Source
    String source = "simulator";

    // Perf
    perf = "tell";

    // Content word
    CW =  new String("GrammarEvent");

    // Content data
    CD = (String)getData().get("Event");

    // Control
    control = true;

    // Other junk
    other = null;
  }
}
