/* Copyright (C) 2005, University of Massachusetts, Multi-Agent Systems Lab
 * See LICENSE for license information
 */

/***************************************************************************************
 *	ExecuteEventStarting.java
 ***************************************************************************************/

package simulator.script;

/**
 * Determines if a certain execute event is starting (time == starttime).
 * <P>
 * <B>Data</B><BR>
 * <UL>
 * <LI>Method:String - The name of the method to look for
 * </UL>
 */
public class ExecuteEventStarting extends ExecuteEventActive {

  /**
   * Constructor.
   */
  public ExecuteEventStarting(String d) {
    super(d);
  }
  
  /**
   * Checks the assertion.
   */
  public boolean check() {

    return eventStarting(findExecuteEvent(name, agent));
  }
}
