/* Copyright (C) 2005, University of Massachusetts, Multi-Agent Systems Lab
 * See LICENSE for license information
 */

/***************************************************************************************
 *	ExecuteEventOutcome.java
 ***************************************************************************************/

package simulator.script;

import utilities.Clock;
import taems.*;
import simulator.*;
import java.util.*;

/**
 * Determines if the supplied outcome is that which was chosen
 * for the event.
 * <P>
 * <B>Data</B><BR>
 * <LI>Method:String - The name of the method to look for
 * <LI>Outcome:String - The outcome to match
 * </UL>
 */
public class ExecuteEventOutcome extends ExecuteEventActive {
  protected String outcome;

  /**
   * Constructor.
   */
  public ExecuteEventOutcome(String d) {
    super(d);
  }
  
  /**
   * Init.
   */  
  public void init() {
    
    // Get the outcome
    outcome = (String)getData().get("Outcome");

    super.init();
  }

  /**
   * Checks the assertion.
   */
  public boolean check() {

    ExecuteEvent e = findExecuteEvent(name, agent);
    if (e.getOutcome().getLabel().equals(outcome))
      return true;

    return false;
  }
}
