/* Copyright (C) 2005, University of Massachusetts, Multi-Agent Systems Lab
 * See LICENSE for license information
 */

/***************************************************************************************
 *	ExecuteEventExtend.java
 ***************************************************************************************/

package simulator.script;

import utilities.Clock;
import taems.*;
import simulator.*;
import java.util.*;

/**
 * Extends a certain execute event.
 * <P>
 * <B>Data</B><BR>
 * <LI>Method:String - The name of the method to look for
 * <LI>Extend:Integer - The amount to extend by
 * </UL>
 */
public class ExecuteEventExtend extends ExecuteEventAbort {
  protected int extend;

  /**
   * Constructor.
   */
  public ExecuteEventExtend(String d) {
    super(d);
  }
   
  /**
   * Init.
   */  
  public void init() {
    
    // Get the extend
    extend = Integer.parseInt((String)getData().get("Extend"));

    super.init();
  }

  /**
   * Starts the reaction
   * @return True if it was sucessfull, false otherwise
   */
  public boolean realize() {

    return extendEvent(findExecuteEvent(name, agent), extend);
  }
}
