/* Copyright (C) 2005, University of Massachusetts, Multi-Agent Systems Lab
 * See LICENSE for license information
 */

/***************************************************************************************
 *	ExecuteEventExists.java
 ***************************************************************************************/

package simulator.script;

/**
 * Determines if a certain execute event exists in the queue.
 * <P>
 * <B>Data</B><BR>
 * <UL>
 * <LI>Method:String - The name of the method to look for
 * </UL>
 */
public class ExecuteEventExists extends ExecuteEventActive {

  /**
   * Constructor.
   */
  public ExecuteEventExists(String d) {
    super(d);
  }
  
  /**
   * Checks the assertion.
   */
  public boolean check() {

    return (findExecuteEvent(name, agent) != null);
  }
}
