/* Copyright (C) 2005, University of Massachusetts, Multi-Agent Systems Lab
 * See LICENSE for license information
 */

/***************************************************************************************
 *	ExecuteEventDelay.java
 ***************************************************************************************/

package simulator.script;

import utilities.Clock;
import taems.*;
import simulator.*;
import java.util.*;

/**
 * Delays a certain execute event.
 * <P>
 * <B>Data</B><BR>
 * <LI>Method:String - The name of the method to look for
 * <LI>Delay:Integer - The amount to delay by
 * </UL>
 */
public class ExecuteEventDelay extends ExecuteEventAbort {
  protected int extend;

  /**
   * Constructor.
   */
  public ExecuteEventDelay(String d) {
    super(d);
  }
   
  /**
   * Init.
   */  
  public void init() {
    
    // Get the extend
    extend = Integer.parseInt((String)getData().get("Delay"));

    super.init();
  }

  /**
   * Starts the reaction
   * @return True if it was sucessfull, false otherwise
   */
  public boolean realize() {

    return delayEvent(findExecuteEvent(name, agent), extend);
  }
}
