/* Copyright (C) 2005, University of Massachusetts, Multi-Agent Systems Lab
 * See LICENSE for license information
 */

/***************************************************************************************
 *	ExecuteEventCompleting.java
 ***************************************************************************************/

package simulator.script;

/**
 * Determines if a certain execute event is completing (time == finishtime).
 * <P>
 * <B>Data</B><BR>
 * <UL>
 * <LI>Method:String - The name of the method to look for
 * </UL>
 */
public class ExecuteEventCompleting extends ExecuteEventActive {

  /**
   * Constructor.
   */
  public ExecuteEventCompleting(String d) {
    super(d);
  }
  
  /**
   * Checks the assertion.
   */
  public boolean check() {

    return eventCompleting(findExecuteEvent(name, agent));
  }
}
