/* Copyright (C) 2005, University of Massachusetts, Multi-Agent Systems Lab
 * See LICENSE for license information
 */

/*****************************************************************
 * $Source: /nfs/shelob/cvs/masl/Mass/modules/simulator/simulator/script/DoPropagateResourceChange.java,v $
 * $Revision: 1.2 $
 ******************************************************************
 *
 *                   DoPropagateResourceChange.java
 *
 *     Author : Peter Amstutz [amstutz@cs.umass.edu]
 *              
 *
 * Creation date: 15 June 99 12:43
 * Last file update: $Date: 2005/01/19 19:00:12 $
 *****************************************************************/

package simulator.script;
import simulator.*;
import simulator.locale.*;

/** 
 * <B>Module</B>: simulator.locale<p>
 * <B>Copyright</B>: UMASS - MASL 1999<P>
 * @version $Revision: 1.2 $
 * @author  Peter Amstutz (amstutz@cs.umass.edu)<P>
 * <B> Description:</B>
 * Forces a propagateResourceChange() for a specific locale.<p>
 * <b>Data</b><br>
 * <ul>
 * <li>Locale:String - The locale to call on</li>
 * </ul>
 */
public class DoPropagateResourceChange extends Reaction {
	Locale l=null;

	public DoPropagateResourceChange(String d) {
		super(d);
	}
	
	/**
	 * Finds the locale object
	 */
	public Locale findLocale() {
		Locale r;
		utilities.Log logger=utilities.Log.getDefault();
		String loc=(String)getData().get("Locale");
		r = Simulator.getSimulator().getLocale(loc);
		if(r==null) {
			logger.log("(SCRIPT) Error in Locale path "+loc, 1);
			return null;
		}
		return r;
	}

	/** Actually calls the propagation code 
	 */
	public boolean realize() {
		if (l == null)
			l=findLocale();
		if (l == null)
			return false;

		l.propagateResourceChange(l, null, null, null);
		l.clearPropMarks();
		return true;
	}
}
