/* Copyright (C) 2005, University of Massachusetts, Multi-Agent Systems Lab
 * See LICENSE for license information
 */

/***************************************************************************************
 *	DisconnectAgent.java
 ***************************************************************************************/

package simulator.script;

import simulator.*;
import java.util.*;

/**
 * Disconnects the agent from the simulator.
 * <P>
 * <B>Data</B><BR>
 * <UL>
 * <LI>Agent:String - Name of the agent to disconnect
 * </UL>
 */
public class DisconnectAgent extends Reaction {
  String agent;

  /**
   * Constructor.
   */
  public DisconnectAgent(String d) {
    super(d);
  }
  
  /**
   * Init.
   */  
  public void init() {
    
    // Get it
    agent = (String)getData().get("Agent");

    super.init();
  }

  /**
   * Finds the script object
   */
  public Script findScript() {

    String s = (String)getData().get("Script");

    Enumeration e = Simulator.getSimulator().getScripter().getScripts();
    while (e.hasMoreElements()) {
      Script scr = (Script)e.nextElement();
      if (scr.getName().equalsIgnoreCase(s))
	return scr;
    }

    return null;
  }

  /**
   * Realize
   */
  public boolean realize() {
    Agent a = null;

    a = findAgent(agent);
    if (a == null)
      return false;

    a.disconnect();

    return true;
  }

  /**
   * Gets a ref to the agent
   * @param n Name of the agent to look for
   * @return The Agent, or null if not found
   */
  public Agent findAgent(String n) {

    synchronized (Simulator.getAgentTable()) {
      return Simulator.getSimulator().findAgent(n);
    }
  }
}
