/* Copyright (C) 2005, University of Massachusetts, Multi-Agent Systems Lab
 * See LICENSE for license information
 */

/***************************************************************************************
 *	Count.java
 ***************************************************************************************/

package simulator.script;

import java.util.*;

/**
 * Will return true the specified number of times.  (each time the
 * assertion is checked the number will decrement)
 * <P>
 * <B>Data</B><BR>
 * <UL>
 * <LI>Value:Integer - The number of times to return true
 * </UL>
 */
public class Count extends Assertion {
  int value;

  /**
   * Constructor.
   */
  public Count(String d) {
    super(d);
  }
  
  /**
   * Init.
   */  
  public void init() {
    
    // Get the value
    value = Integer.parseInt((String)getData().get("Value"));

    super.init();
  }

  /**
   * Checks the assertion.
   */
  public boolean check() {

    if (value <= 0)
      return false;

    value--;

    return true;
  }
}
