/* Copyright (C) 2005, University of Massachusetts, Multi-Agent Systems Lab
 * See LICENSE for license information
 */

/***************************************************************************************
 *	AssignNewGrammar.java
 ***************************************************************************************/

package simulator.script;

import java.util.*;

/**
 * Tells the agent to use a new grammar file.  You can also use this
 * to refresh the existing grammar by sending the same name.
 * <P>
 * <B>Data</B><BR>
 * <UL>
 * <LI>Agent:String - The name of the recipient
 * <LI>Grammar:String - The name of the grammar to use.
 * </UL>
 */
public class AssignNewGrammar extends SendMessage {

  /**
   * Constructor.
   */
  public AssignNewGrammar(String d) {
    super(d);
  }
  
  /**
   * Init.
   */  
  public void init() {
    super.init();

    // Agent
    agent = (String)getData().get("Agent");

    // Source
    String source = "simulator";

    // Perf
    perf = "tell";

    // Content word
    CW =  new String("Grammar");

    // Content data
    CD = (String)getData().get("Grammar");

    // Control
    control = true;

    // Other junk
    other = null;
  }
}
