/* Copyright (C) 2005, University of Massachusetts, Multi-Agent Systems Lab
 * See LICENSE for license information
 */

/***************************************************************************************
 *	AgentConnected.java
 ***************************************************************************************/

package simulator.script;

import simulator.*;
import java.util.*;

/**
 * Determines if the agent is connected or not
 * <P>
 * <B>Data</B><BR>
 * <UL>
 * <LI>Agent:String - Name of the agent to look for
 * </UL>
 */
public class AgentConnected extends Assertion {
  String agent;

  /**
   * Constructor.
   */
  public AgentConnected(String d) {
    super(d);
  }
  
  /**
   * Init.
   */  
  public void init() {
    
    // Get it
    agent = (String)getData().get("Agent");

    super.init();
  }

  /**
   * Checks the assertion.
   */
  public boolean check() {

    if (findAgent(agent) != null)
      return true;

    return false;
  }

  /**
   * Gets a ref to the agent
   * @param n Name of the agent to look for
   * @return The Agent, or null if not found
   */
  public Agent findAgent(String n) {

    synchronized (Simulator.getAgentTable()) {
      return Simulator.getSimulator().findAgent(n);
    }
  }
}
