/* Copyright (C) 2005, University of Massachusetts, Multi-Agent Systems Lab
 * See LICENSE for license information
 */

/***************************************************************************************
 *	AdjustResourceLevel.java
 ***************************************************************************************/

package simulator.script;

import simulator.*;
import java.util.*;

/**
 * Adjusts the current level of a resource by some amount, using a 
 * ResourceEvent.
 * <P>
 * <B>Data</B><BR>
 * <UL>
 * <LI>Resource:String - The name of the resource to check
 * <LI>Dur:Integer - The desired duration of the event adjusting the
 * level by a specific value (optional, default 0)
 * <LI>Level:Float - The target level to adjust the current level by.
 * </UL>
 */
public class AdjustResourceLevel extends SetResourceLevel {

  /**
   * Constructor.
   */
  public AdjustResourceLevel(String d) {
    super(d);
  }

  
  /**
   * Creates the event we'll be using
   */
  public ResourceEvent createEvent() {

    return new ResourceEvent(0, dur, rsrc, level, ResourceEvent.NO_CHANGE, ResourceEvent.NO_CHANGE, false);
  }
}
