/* Copyright (C) 2005, University of Massachusetts, Multi-Agent Systems Lab
 * See LICENSE for license information
 */

/***************************************************************************************
 *	AdjustExecuteEventLevel.java
 ***************************************************************************************/

package simulator.script;

import utilities.Clock;
import taems.*;
import simulator.*;
import java.util.*;

/**
 * Adjusts an execution event's dimension level.
 * <P>
 * <B>Data</B><BR>
 * <LI>Method:String - The name of the method to look for
 * <LI>Dimension:String - The name of the dimension to adjust (e.g.
 * quality, cost)
 * <LI>Level:Float - The target level to adjust the current level by.
 * </UL>
 */
public class AdjustExecuteEventLevel extends ExecuteEventAbort {
  protected float level;
  protected String dim;

  /**
   * Constructor.
   */
  public AdjustExecuteEventLevel(String d) {
    super(d);
  }
   
  /**
   * Init.
   */  
  public void init() {
    
    // Get the method
    dim = (String)getData().get("Dimension");
    
    // Get the level
    level = Float.valueOf((String)getData().get("Level")).floatValue();

    super.init();
  }

  /**
   * Starts the reaction
   * @return True if it was sucessfull, false otherwise
   */
  public boolean realize() {

    ExecuteEvent e = findExecuteEvent(name, agent);
    if (e != null) {
      float cur = e.getDimension(dim);
      if (cur != Float.NaN) {
        e.setDimension(dim, cur + level);
        return true;
      }
    }

    return false;
  }
}
