/* Copyright (C) 2005, University of Massachusetts, Multi-Agent Systems Lab
 * See LICENSE for license information
 */

/*****************************************************************
 * $Source: /nfs/shelob/cvs/masl/Mass/modules/simulator/simulator/locale/SimpleLocationMapping.java,v $
 * $Revision: 1.2 $
 ******************************************************************
 *
 *                   SimpleLocationMapping.java
 *
 *     Author : Peter Amstutz [amstutz@cs.umass.edu]
 *              
 *
 * Creation date: 15 June 99 12:43
 * Last file update: $Date: 2005/01/19 19:00:07 $
 *****************************************************************/

package simulator.locale;

import simulator.Simulator;
import simulator.locale.*;
import java.io.*;

/** 
 * <B>Module</B>: simulator.locale<p>
 * <B>Copyright</B>: UMASS - MASL 1999<P>
 * @version $Revision: 1.2 $
 * @author  Peter Amstutz (amstutz@cs.umass.edu)<P>
 * <B> Description:</B>
 *
 * The subclass SimpleLocationMapping maps locale
 * path strings onto locale nodes.  Pretty simple :)
 */
public class SimpleLocationMapping extends LocationMapping {
    public SimpleLocationMapping() { };
	
	/** 
		(Simple) example of a subclass of LocationMapping, just maps 
		string name to locale structure name...
		@param <b>loc</b> locale path string
		@return The Locale found, or null if unknown.
	*/
    public Locale mapLocationToLocale(String loc) {
		return Simulator.getSimulator().getLocale(loc);
    }
}
