/* Copyright (C) 2005, University of Massachusetts, Multi-Agent Systems Lab
 * See LICENSE for license information
 */

/*****************************************************************
 * $Source: /nfs/shelob/cvs/masl/Mass/modules/simulator/simulator/locale/LocationMapping.java,v $
 * $Revision: 1.2 $
 ******************************************************************
 *
 *                   LocationMapping.java
 *
 *     Author : Peter Amstutz [amstutz@cs.umass.edu]
 *              
 *
 * Creation date: 15 June 99 12:43
 * Last file update: $Date: 2005/01/19 19:00:07 $
 *****************************************************************/

package simulator.locale;

import simulator.Simulator;
import simulator.locale.*;

/** 
 * <B>Module</B>: simulator.locale<p>
 * <B>Copyright</B>: UMASS - MASL 1999<P>
 * @version $Revision: 1.2 $
 * @author  Peter Amstutz (amstutz@cs.umass.edu)<P>
 * <B> Description:</B>
 *
 * This is a fairly simple class whose purpose is to provide an easy
 * way to map some arbitrary location system onto the locale tree.
 * This base class does essentially nothing, throwing everything into
 * the global locale, but can be subclassed for more useful effects.
 * An example might be to map the IHome x,y location coordinates onto
 * the background picture of the house and figure out the proper
 * locale from that.
 */
public class LocationMapping {
    public LocationMapping() { };
	/**
	   Override this with an application-specific coodinate->locale
	   translation function (for example, mapping x,y coordinates to
	   locales)
	   @param <b>loc</b> some location string (ignored)
	   @return the global locale
	*/
    public Locale mapLocationToLocale(String loc) {
		return Simulator.getSimulator().getLocale("Global");
    }
}
