/* Copyright (C) 2005, University of Massachusetts, Multi-Agent Systems Lab
 * See LICENSE for license information
 */

/************************************************************
 * LocaleGraph.java
 ************************************************************/

package simulator.locale;

import javax.swing.*;
import java.beans.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;

import utilities.*;

/**
 * This class extends Graph, oriented towards displaying locale
 *  topologies. 
 */
public class LocaleGraph extends Graph
{
    /**
     * Basic constructors, the string will be used as the name of the graph
     */
    public LocaleGraph(String s)
    {
        super(s);
        addHideMenuOptions();
    }
    
    public LocaleGraph()
    {
        super();
    }
    
    public Enumeration findLocales(Locale m)
    {
        return new LocaleFinderEnumeration(findNodes(new Locale()), m);
    }

    protected void initGraphics()
    {
        super.initGraphics();
    }

    JMenuItem linkagestate = null;
    JMenuItem paredgestate = null;
    boolean showlinkages = true;
    boolean showparentedges = true;

    public void addHideMenuOptions()
    {
        linkagestate = new JMenuItem("Hide linkages");
        linkagestate.addActionListener(new ActionListener()
                {
                public void actionPerformed(ActionEvent e)
                {
                if (showlinkages)
                linkagestate.setText("Show linkages");
                else
                linkagestate.setText("Hide linkages");

                showlinkages = !showlinkages;
                setLinkagesVisState();
                }
                });
        addMenuItem(linkagestate); 
        paredgestate = new JMenuItem("Hide edges to parents");
        paredgestate.addActionListener(new ActionListener()
                {
                public void actionPerformed(ActionEvent e)
                {
                if (showparentedges)
                paredgestate.setText("Show edges to parents");
                else
                paredgestate.setText("Hide edges to parents");

                showparentedges = !showparentedges;
                setParEdgeVisState();
                }
                });
        addMenuItem(paredgestate);
    }

    protected void setLinkagesVisState()
    {
        Enumeration e = findLocales(new Linkage());

        while (e.hasMoreElements())
        {
            Linkage l = (Linkage) e.nextElement();
            JPanel p = getLayers().getTopPanel(l);
            if (p != null)
                p.setVisible(showlinkages);
        }
        repaint();
    }

    protected void setParEdgeVisState()
    {
        Enumeration e = findLocales(new Locale());

        while (e.hasMoreElements())
        {
            GraphEdge edge = ((Locale) e.nextElement()).getEdgeToParent();
            if (edge == null)
                continue;
            JPanel p = getLayers().getTopPanel(edge);
            if (p != null)
                p.setVisible(showparentedges);
        }
        repaint();
    }
}
