/* Copyright (C) 2005, University of Massachusetts, Multi-Agent Systems Lab
 * See LICENSE for license information
 */

/************************************************************
 * LocaleFinderEnumeration.java
 ************************************************************/

package simulator.locale;

/* Global imports */
import java.awt.*;
import java.io.*;
import java.util.*;

/**
 * Node finder
 */
class LocaleFinderEnumeration implements Enumeration {
  Vector matches = new Vector();
  Locale match;
  
  public LocaleFinderEnumeration(Enumeration es, Locale m) {
    match = m;

    while (es.hasMoreElements()) {
      Locale s = (Locale)es.nextElement();
      findMatches(s);
    }
    //System.err.println("LocaleFinderEnumeration: searching on " + m + ", found " + matches + ", rejected " + nonmatches);
  }

  public LocaleFinderEnumeration(Locale s, Locale m) {
    match = m;
    findMatches(s);
  }
  
  public boolean hasMoreElements() {
    return (!matches.isEmpty());
  }
  
  public Object nextElement() {
    Object o = matches.firstElement();
    matches.removeElement(o);
    return o;
  }
  
  Vector nonmatches = new Vector();
  private void findMatches(Locale n) {
    Enumeration e;
   
    if (matches.contains(n)) return;
    if (nonmatches.contains(n)) return;
    if (n.matches(match)) {
      matches.addElement(n);
    } else
        nonmatches.addElement(n);
    
    e = n.getSubLocales();
    while (e.hasMoreElements()) {
      findMatches((Locale)e.nextElement());
    }
    e = n.getLinkages();
    while (e.hasMoreElements())
    {
        findMatches((Locale) e.nextElement());
    }
  }
}
