/* Copyright (C) 2005, University of Massachusetts, Multi-Agent Systems Lab
 * See LICENSE for license information
 */

/*******************************************************
 * SimulatorWindowManager.java
 *******************************************************/
 
 package simulator;
 
/* Global imports */
import javax.swing.*;
import javax.swing.event.*;
import java.beans.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;


public class SimulatorWindowManager extends JFrame implements Serializable, Cloneable
{
    protected Hashtable windows = null;
    JPanel windowlist;
    JPanel controls;
    JPanel info;
    
    private static final int INITIAL_WIDTH = 300;
    private static final int INITIAL_HEIGHT = 400;
    
    public SimulatorWindowManager()
    {
        super("MASS ControlPanel");
        setSize(INITIAL_WIDTH, INITIAL_HEIGHT);
        setLocation(0, 50);
        windows = new Hashtable();
        getContentPane().setLayout(new GridLayout(3, 1));
        getContentPane().add(controls = new JPanel());
        getContentPane().add(windowlist = new JPanel());
        getContentPane().add(info = new JPanel());
        info.setLayout(new GridLayout(0, 1));
        controls.setLayout(new GridLayout(0, 3));
        windowlist.setLayout(new GridLayout(0, 1));
        windowlist.add(new JLabel("Window List"));
        info.add(new JLabel("Information"));
    }
    
    public void addControl(Component c)
    {
        controls.add(c);
    }
    
    public void removeControl(Component c)
    {
        controls.remove(c);
    }
    
    public void addInfo(Component c)
    {
        info.add(c);
    }
    
    public void removeInfo(Component c)
    {
        info.remove(c);
    }
      
    public void addWindow(Window c)
    {
        if (!contains(c))
        {
             JCheckBox check = new JCheckBox(findWindowTitle(c));
             check.addActionListener(new ActionListener()
                 {
                     public void actionPerformed(ActionEvent e)
                     {
                         JCheckBox ch = (JCheckBox) e.getSource();
                         Enumeration en = windows.keys();
                         Window co = null;
                         while (en.hasMoreElements())
                         {
                             co = (Window) en.nextElement();
                             if (windows.get(co) == ch)
                                 break;
                         }
                         if (co != null)
                         {
                             setWindowVisible(co, !(co.isShowing()));
                         }
                     }
                 });
             //System.err.println("size of " + check + " is " + check.getPreferredSize());
             windows.put(c, check);
             windowlist.add(check);
             getContentPane().validate();
             getContentPane().repaint();
        }
    }
    
    public void removeWindow(Window c)
    {
        if (contains(c))
        {
            windows.remove(c);
            windowlist.remove(c);
        }
    }
    
    public boolean contains(Object o)
    {
        return windows.containsKey(o);
    }
    
    public void showWindow(Window c)
    {
        if (contains(c))
            c.setVisible(true);
    }
    
    public void hideWindow(Window c)
    {
        if (contains(c))
            c.setVisible(false);
    }
    
    public void setWindowVisible(Window c, boolean b)
    {
        if (contains(c))
        {
            if (c.getLocation().x < getSize().width)
                c.setLocation(new Point(getSize().width + 10, c.getLocation().y));
            c.setVisible(b);
        }
    }
    
    public boolean isShowing(Window c)
    {
        if (contains(c))
            return c.isShowing();
        return false;
    }
    
    protected String findWindowTitle(Window w)
    {
        if (w instanceof Frame)
            return ((Frame)w).getTitle();
        else if (w instanceof Dialog)
            return ((Dialog)w).getTitle();
        else
            return w.getName();
    }
}