/* Copyright (C) 2005, University of Massachusetts, Multi-Agent Systems Lab
 * See LICENSE for license information
 */

/*****************************************************************
* $Source: /nfs/shelob/cvs/masl/Mass/modules/simulator/simulator/Server.java,v $
* $Revision: 1.2 $
******************************************************************
*
*                 Server.java
*
*     Author : Regis Vincent [vincent@cs.umass.edu]
*              
*
*     Creation date: 22 Aug 97 11:27
*  Last file update: $Date: 2005/01/19 19:00:05 $
*****************************************************************/
package simulator;

/* Global imports */
import java.net.*;
import java.io.*;
import java.util.*;

/* Local Imports */
import simulator.Listener;
import simulator.sensor.Sensor;
import utilities.*;


/**
 * <B>Module</B>: simulator<p>
 * <B>Copyright</B>: UMASS - MASL 1998<P>
 * @version $Revision: 1.2 $
 * @author Regis Vincent (vincent@cs.umass.edu)
 * <B> Description:</B>
 * For each agent which wants to connect to the simulator, we create a new 
 * thread for initializing the connection.
 */
public class Server extends Thread
{
  private Socket socket = null;
  private Log logger;
  
  /**
   * Create the new thread. 
   * @param s is the Socket creates by the accept funtion from the RootServer
   */
  Server(Socket s) {
    logger = Log.getDefault();
    socket = s;
    logger.log("(Server) New server started.", 2);
    start();
  }
  
  /**
   * This function run is used by the start() when the new Thread begins.
   * In this function, we create the Agent structure, the Listener structure.
   * But before add the agent in the hashtable,  we check that the
   * communications works by sending a reset message.
   */
  public void run() {
    Agent agent = null;
    try { 
	String name = "";
	Listener l;

	// set sum to zero
	logger.log("(Server) Reset time to 0 pulse.", 2);

	// Make the streams
	BufferedReader input = new BufferedReader(new InputStreamReader(socket.getInputStream()));
	BufferedWriter output = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream()));
	    
	// Waiting for ACK and name !
	KQMLMessage kqml = new KQMLMessage(KQMLMessage.receive(input));
	String perf = kqml.getPerformative();
	if (perf.equalsIgnoreCase("register")) {
	  name = kqml.getSourceAddr();
	  // Determine the name
	  if (name.lastIndexOf('/') != -1)
	    name = name.substring(1+name.lastIndexOf('/'));
	}
	else 
	  name = null;
	
	// Add it in the all Agent Hashtable and add listener
	synchronized (Simulator.getAgentTable()) {
	  agent = new Agent(socket, name);
	  l = new Listener(agent, input, output);
	  agent.add();
	}
	logger.log("(Server) Adding agent " + agent.getName(), 2);

	KQMLMessage msg = new KQMLMessage("(Name " + agent.getName()+ " )",
					    kqml.getSourceAddr());
	msg.addField("type", "control");
	agent.sendMsg(msg);
	msg = new KQMLMessage("(RandomSeed " + 
			      Simulator.getSimulator().random.getSeed() + " )",
			      kqml.getSourceAddr());
	msg.addField("type", "control");
	agent.sendMsg(msg);
	msg = new KQMLMessage("(Time " + 
			      Clock.getTime() + " )",
			      kqml.getSourceAddr());
	msg.addField("type", "control");
	agent.sendMsg(msg);

	/*	
	Sensing sensing = Simulator.getSimulator().getGlobalSensing();
	Enumeration e = sensing.getSensors();
	while (e.hasMoreElements()) {
	  Sensor s = (Sensor)e.nextElement();
	  msg = new KQMLMessage("(NewSensor " + 
				s.exportSensor() + ")",
				kqml.getSourceAddr());
	  msg.addField("type", "control");
	  agent.sendMsg(msg);
	}
	*/
  } catch (IOException io) {
      logger.log("(Server) Error: Unable to create agent and Listener");
      logger.log("(Server) " + io);
      if (agent != null)
	agent.remove();
      try { socket.close(); } catch (IOException e) { }
    }
	
  }
}

  


