/* Copyright (C) 2005, University of Massachusetts, Multi-Agent Systems Lab
 * See LICENSE for license information
 */

package simulator;
/*****************************************************************
* $Source: /nfs/shelob/cvs/masl/Mass/modules/simulator/simulator/RootServer.java,v $
* $Revision: 1.2 $
******************************************************************
*
*                RootServer.java
*
*     Author : Regis Vincent [vincent@cs.umass.edu]
*              
*
*     Creation date: 22 Aug 97 11:39
*  Last file update: $Date: 2005/01/19 19:00:05 $
*****************************************************************

/* Global Import */
import java.net.*;
import java.io.*;
import java.util.*;

/* Local Import */
import utilities.Log;

/**
 * <B>Module</B>: simulator<p>
 * <B>Copyright</B>: UMASS - MASL 1998<P>
 * @version $Revision: 1.2 $
 * @author Regis Vincent (vincent@cs.umass.edu), Bryan Horling (bhorling@cs.umass.edu)<P>
 * <B> Description:</B>
 * This class contains, the RootServer definition. The RootServer is created 
 * by the simulator to take care about the communications. Each new client 
 * which want to connect to the simulator should send a message to the 
 * RootServer. For accepting the connection, the RootServer delegates the work
 * to a Server which creates the agent structure.  
 * The role of the RootServer is just accepting new clients ans delegates.
 */
public class RootServer extends Thread
{
  protected ServerSocket serverSocket;
  private Log logger;

  /**
   * This function creates a socket for listening new client connections 
   * and creates a new Thread dedicated.
   */
  public RootServer(int port) {
    logger = Log.getDefault();
    try {
      // create socket
      serverSocket = new ServerSocket(port);
      logger.log("(RootServer) Listening at port " + port, 2);
    }
    catch (IOException ie) {
      logger.log("(RootServer) Error: Unable to create socket");
      ie.printStackTrace();
      return;
    }
    start();
  }
  
  /**
   * Infinite loop, just listen the socket.
   */
  public void run() {
    try {
      while (true) {
	// wait for connection then create streams
	logger.log("(RootServer) Waiting for client connection", 2);
	new Server(serverSocket.accept());
	logger.log("(RootServer) Got a connection", 1);
      }
    } catch (IOException e) {
      logger.log("(RootServer) Server broken connection");
      e.printStackTrace();
      Thread.currentThread().stop();
    } catch (ThreadDeath e) {
      logger.log("(RootServer) Thread terminated, server stopping");
      try {
        serverSocket.close();
      } catch (IOException ie) { }
      serverSocket = null;
      throw (e);
    }
  }
}
  


