/* Copyright (C) 2005, University of Massachusetts, Multi-Agent Systems Lab
 * See LICENSE for license information
 */

/**
 * $Source: /nfs/shelob/cvs/masl/Mass/modules/simulator/simulator/Resources.java,v $
 * $Revision: 1.2 $
 *
 *
 *                  Resources classes
 *
 *     Author : Regis Vincent [vincent@cs.umass.edu]
 *              
 *
 *     Creation date: 10 Apr 98 17:23
 *  Last file update: $Date: 2005/01/19 19:00:05 $
 */

package simulator;

/* Global includes */
import java.awt.*;
import java.util.*;

/* Local includes */
import utilities.Log;
import simulator.locale.*;
import utilities.*;
import javax.swing.*;
/**
* <B>Module</B>: simulator<p>
 * <B>Copyright</B>: UMASS - MASL 1998<P>
 * @version $Revision: 1.2 $
 * @author Regis Vincent (vincent@cs.umass.edu)<P>
 * <B> Description:</B>
 * The top level for the Resources. This classes takes care of the resources 
 * display !!! - Not yet finished -
 */
public class Resources extends GraphNode{
  protected String name;
  protected String unit;
  protected float maximum;
  protected float currentValue;
  protected float realValue;
  protected float minimum;
  protected Hashtable inUse;
  protected Log logger;
  protected boolean isOverloaded=false;
  protected Event currentAdd;
  protected simulator.locale.Locale loc;
  protected taems.Resource resource;

  /* Constructor */

  public Resources(String n, float min, float max, float start, String u) {
    super(n);
    name = n;
    maximum = max;
    minimum = min;
    currentValue = start;
    realValue = start;
    unit = u;
    logger = Log.getDefault();
    inUse = new Hashtable();
    loc=Simulator.getSimulator().getLocale("Global");
  }

  public float getRealValue() { return realValue;}
  public float getCurrentValue() { return currentValue;}
  public int getCurrentPourcentage() { 
    int value;
    float diff = (currentValue - minimum)/(maximum - minimum);
    value = (int) Math.round(100 * diff);
    return(value);
  }

  public synchronized void useResources(float inc, Event exe) {
    // Store the method name and the value in use
    // Add the value to the currentValue
    logger.log("(Resource " + name + ") Resources in used : " + inc,2);
    if (inUse.containsKey(exe)) 
      inUse.remove(exe);
    inUse.put(exe,new Float(inc));
    currentAdd = exe;
    setCurrentValue(getRealValue()-inc);
    currentAdd=null;
  }

  public synchronized void updateResources(Event exe) { 
    if (isOverloaded)
      overload(0);
  }

    protected synchronized void depleted(float value) { 
	Enumeration e;
	logger.log("(Resource " + name + ") Depleted " + value, 1);
	isOverloaded=true;
	for (e = inUse.keys(); e.hasMoreElements(); ) { 
	    ExecuteEvent exe = (ExecuteEvent)e.nextElement(); 
	    if ((currentAdd != null) && (currentAdd == exe))
		exe.overloadResources(this.name,maximum - value);
	    else
		exe.overloadResources(this.name, 0);
	} 
    }

  protected synchronized void overload(float value) { 
    Enumeration e;
    logger.log("(Resource " + name + ") Overloaded " + value, 1);
    // get All Method in use and apply the limit NLE's
    isOverloaded=true;
    for (e = inUse.keys(); e.hasMoreElements(); ) { 
      ExecuteEvent exe = (ExecuteEvent)e.nextElement(); 
      if ((currentAdd != null) && (currentAdd == exe))
	exe.overloadResources(this.name,maximum - value);
      else
	exe.overloadResources(this.name, 0);
    } 
  }

  public synchronized void releaseResources(Event exe) { 
    // Remove this method from the hashtable and
    // Decreased the value of the currentValue
    logger.log("(Resource " + name + ") " +
	       " Release resource from " + ((ExecuteEvent)exe).getMethodName(),2);

    if (inUse.get(exe) != null) {
      float value = ((Float)inUse.get(exe)).floatValue();
      setCurrentValue(getRealValue()+value);
      inUse.remove(exe);
	  loc.propagateResourceChange(loc, this, new Float(-value), exe);
	  loc.clearPropMarks();
    }
    else 
      logger.log("(Resource " + name + ") " +
		 " Release resource from " + ((ExecuteEvent)exe).getMethodName() 
		 + " no Entries in the hastable ");
  }

    public simulator.locale.Locale getLocale() {
	return loc;
    }

    public void setLocale(simulator.locale.Locale l) {
		loc=l;
		loc.propagateResourceChange(loc, this, null, null);
		loc.clearPropMarks();	
    }

    public boolean isGlobal() {

        if (loc != null) {
            return loc.getLabel().equalsIgnoreCase("Global");
        }

        return false;
    }

  public synchronized float setCurrentValue(float newValue) {
      Float diff=new Float(newValue - realValue);
    logger.log("(Resource " + name + ") current use = " + newValue,3);
    realValue=newValue;

    if (realValue > maximum) {
      overload(realValue);
      newValue=maximum;

    } else {
      isOverloaded=false;
    }

    if (newValue < minimum) {
	depleted(newValue);
	newValue=minimum;
    }
    currentValue = newValue;

    if (getTaemsResource() != null) {
        logger.log("(Resource " + name + ") Setting taems resource to " + getCurrentValue(), 4);
        getTaemsResource().setState(getCurrentValue());
    } else {
        logger.log("(Resource " + name + ") Couldn't find taems object.", 5);
    }

    return (currentValue);
  }
 
  public float getMaximum() { return maximum;}
  public float getMinimum() { return minimum;}
    public synchronized void setMaximum(float max) { 
        maximum = max; 
  
        if (getTaemsResource() != null) {
            logger.log("(Resource " + name + ") Setting taems resource max to " + getCurrentValue(), 4);
            getTaemsResource().setOverloadedAt(getMaximum());
        }
    }
    public synchronized void setMinimum(float min) {
        minimum = min;

        if (getTaemsResource() != null) {
            logger.log("(Resource " + name + ") Setting taems resource min to " + getCurrentValue(), 4);
            getTaemsResource().setDepletedAt(getMinimum());
        }
    }
  public String getName() { return name; }
  public String getUnit() { return unit; }

  public taems.Resource getTaemsResource() {

    if (isGlobal()) {
        if (resource == null)
            resource = (taems.Resource)Simulator.global_view.findNode(new taems.Resource(getName(), null));
        if (resource == null) {
	    String others = "";
            Enumeration e = Simulator.global_view.findNodes(new taems.Resource(null, null));
	    while (e.hasMoreElements()) {
		taems.Resource r = (taems.Resource)e.nextElement();
		others += " " + r.getLabel();
	    }
            logger.log("(Resource " + name + ") was not found.  These resources _were_ found:" + others, 5);
	}
    } else {
        logger.log("(Resource " + name + ") Resource not global, no taems update.", 5);
    }

    return resource;
  }

  public String toString() {
    return("[Resource] " + name + " " + currentValue + "/" + 
      maximum + "/" + minimum + " " + unit);
  }
  
  /********************************
   *        Drawing stuff         *
   ********************************/
  
  public JPanel getDefaultPanel()
  {
      return new ResourceNodePanel(this);
  }
}
