/* Copyright (C) 2005, University of Massachusetts, Multi-Agent Systems Lab
 * See LICENSE for license information
 */

/**
 * ResouceNodePanel.java
 */

package simulator;

/* Global includes */
import java.awt.*;
import java.util.*;

/* Local includes */
import utilities.Log;
import simulator.locale.*;
import utilities.*;

public class ResourceNodePanel extends NodePanel
{

    protected Resources tied = null;
    
    public ResourceNodePanel(Resources t)
    {
        super();
        tied = t;
    }
    
    public void paint(Graphics g)
    {
        g.setFont(normalFont);
        FontMetrics fm = g.getFontMetrics();
        Rectangle rect = new Rectangle(0, 0, getWidth() - 1, getHeight() - 1);

        // draw rectangle
        g.setColor(getBackground());
        g.fillRect(0, 0, rect.width, rect.height);
        double percent = (tied.getCurrentValue() - tied.getMinimum()) /
            (tied.getMaximum() - tied.getMinimum());
        int barwidth = (int) (((double) rect.width) * percent);
        g.setColor(Color.blue);
        g.fillRect(0, 0, barwidth, rect.height);
        g.setColor(Color.black);
        g.drawRect(0, 0, barwidth, rect.height);
        g.setColor(Color.black);
        g.drawRect(0, 0, rect.width, rect.height);

        // draw label
        try {
            Rectangle clip = g.getClipBounds();
            g.setColor(Color.white);
            g.setClip(0, 0, barwidth + 1, rect.height);
            g.drawString(getLabel(), H_MARGIN, rect.height -
                    (V_MARGIN + fm.getDescent()));
            g.setColor(getForeground());
            g.setClip(barwidth + 1, 0, rect.width - barwidth - 1, rect.height);
            g.drawString(getLabel(), H_MARGIN, rect.height -
                    (V_MARGIN + fm.getDescent()));
            // this is a hack, since older jdks dont seem to handle clipping properly, and the only computer wiht
            //  a version does right now is berkshire
            if (clip == null)
                g.setClip(new Rectangle(0, 0, 100000, 100000));
            else
                g.setClip(clip);
        } catch (java.lang.NullPointerException e) {
            System.err.println("Error drawing label");
            e.printStackTrace();
        }
    }
}

