/* Copyright (C) 2005, University of Massachusetts, Multi-Agent Systems Lab
 * See LICENSE for license information
 */

/***************************************************************************************
 *	RealExecuteEvent.java
 ***************************************************************************************/
package simulator;

/* Global Includes */
import java.io.*;
import java.util.*;

/* Local Inclues */
import simulator.Agent;
import simulator.Event;
import simulator.ExecuteEvent;
import taems.*;
import utilities.*;


/**
 * <B>Module</B>: simulator<p>
 * <B>Copyright</B>: UMASS - MASL 1998<P>
 * @version $Revision: 1.2 $
 * @author Regis Vincent (vincent@cs.umass.edu)<P>
 * <B> Description:</B>
 * An Real Execution event object
 */
public class RealExecuteEvent extends ExecuteEvent implements Serializable {
  protected       boolean done;
  
  /**
   * Constructor
   * @param src The event's source agent
   * @param method The method's name to execute
   * @param ID uniq's ID for this execution
   * @param dD the duration Distribution (float [])
   * @param qD the quality distribution (float [])
   * @param cD the cost Duration (float [])
   * @see ExecuteEvent#ExecuteEvent(int, int, Agent, String, String, float[], float[], float[])
   */
  public RealExecuteEvent(int s, int e, Agent src, Method method, String ID) {
    super(s,  e, src,  method, ID);
    done = false;
  }
  
  /**
   * EndExecution
   * This function is called when I receive
   */

  public void EndExecution(float quality, float cost) {
    Resource Re = (Resource)perTimeClickDimension.get("cost");
    Re.total = cost;
    Re = (Resource)perTimeClickDimension.get("quality");
    Re.total = quality;
    this.done = true;
  }

  /**
   * Realizes the particular event
   * @return True if the realization was successfull
   */
  public boolean realize() {
    if (done == true) {
      super.realize();
    }
    else {
      EventQueue q = EventQueue.getQueue();
      q.extendEvent(this,1);
    }
      
    return true;
  }  
}





