/* Copyright (C) 2005, University of Massachusetts, Multi-Agent Systems Lab
 * See LICENSE for license information
 */

/***************************************************************************************
 *	ReactionEvent.java
 ***************************************************************************************/
package simulator;

/* Global Includes */
import java.io.*;
import java.util.*;
import java.lang.*;
import java.awt.*;
import java.security.*;

/* Local Inclues */
import simulator.Agent;
import simulator.Event;
import taems.Taems;
import utilities.Log;
import utilities.Clock;

/** 
 * <B>Module</B>: simulator<p>
 * <B>Copyright</B>: UMASS - MASL 1998<P>
 * @version $Revision: 1.2 $
 * @author  Brett Benyo (bbenyo@cs.umass.edu)<P>
 * <B> Description:</B>
 * A Reaction event is fired when a special pattern is matched.
 */
public class ReactionEvent extends Event implements Serializable {
  String event_label;
  String agent;
  private static Log logger;

  /**
   * Constructor
   */
  public ReactionEvent(String label, String a, int activation) {
    super(activation, 0);
    logger = Log.getDefault();
    if (logger == null)
      System.err.println("Error in ReactionEvent: Log undefined");
    else
      logger.log("(ReactionEvent) Activation = "+activation);
    event_label = label;
    agent = a;
    display = new Label("ReactionEvent (" + event_label + ") T=0");

  }
 
  /**
   * Returns a string of the event's status, as determined
   * by the simulation clock.  This assumes the event queue
   * is functioning correctly, it does not actually check
   * how the event is being executed, so it should only be
   * called on events returned from a queue slot.
   * @return A String representing the event status
   */
  public String getStatus() {
    int time = Clock.getTime();
    String status = "";
    
    if (time == startTime)
      status = "Executing reaction.";
    else if (time < startTime)
      status = "Reaction delayed";
    else if (time > (startTime + execTime))
      status = "Reaction completed";
    return (status);
  }
  
  /**
   * Realizes the particular event
   * @return True if the realization was successfull
   */
  public boolean realize() {
    int time = Clock.getTime();
    // Change the body function for reaction
    // Revision: 1.7
    return true;
  }

  /**
   * Returns the state code, which should hopefully be relatively
   * unique (based on the event's contents) and deterministic
   * @return the state code
   */
  public long stateCode() {
    long code = super.stateCode();

    try {
      ByteArrayOutputStream devnull = new ByteArrayOutputStream(512);
      MessageDigest md = MessageDigest.getInstance("SHA");
      DigestOutputStream mdo = new DigestOutputStream(devnull, md);
      DataOutputStream data = new DataOutputStream(mdo);

      // Enter the data
      data.writeLong(code);
      data.writeUTF(event_label);
      data.writeUTF(agent);

      // Compute the hash value
      byte hasharray[] = md.digest();
      for (int i = 0; i < Math.min(8, hasharray.length); i++)
	code += (long)(hasharray[i] & 255) << (i * 8);
    } catch (IOException ignore) {
      System.err.println("Error: " + ignore);
    } catch (NoSuchAlgorithmException complain) {
      throw new SecurityException(complain.getMessage());
    }

    return code;
  }
}



