/* Copyright (C) 2005, University of Massachusetts, Multi-Agent Systems Lab
 * See LICENSE for license information
 */

package simulator;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.net.*;


/**
 * <B>Module</B>: simulator<p>
 * <B>Copyright</B>: UMASS - MASL 1998<P>
 * @version $Revision: 1.2 $
 * @author Regis Vincent (vincent@cs.umass.edu))<P>
 * <B> Description:</B>
 * The loading progress bar.
 */

public class ProgressBarPanel extends JPanel {
  private final	static Dimension DIMENSION = new Dimension(500, 282);
  private final static int XPOSITION = 350 ;
  private final static int YPOSITION = 300 ;
  Object lock = new Object();
  boolean shouldStop=false;
  JProgressBar progressBar;
  JLabel currentLabel;
  private int currentValue;
  private Frame currentFrame;


  /**
   * Constructor that creates the nice progress bar at the loading.
   * This code uses the Swing component.
   */
  public ProgressBarPanel() {

    JLabel MASLLabel,TitleLabel;

    setLayout(new BorderLayout());
    try {
      String http="http://mas.cs.umass.edu/images/masl.gif";
      if (System.getProperty("MASL") != null) 
	http=System.getProperty("MASL");

      MASLLabel = new JLabel(new ImageIcon(new URL(http)));
      MASLLabel.setVerticalTextPosition(MASLLabel.BOTTOM);
      MASLLabel.setHorizontalAlignment(MASLLabel.CENTER);
      MASLLabel.setVerticalTextPosition(MASLLabel.BOTTOM);
      MASLLabel.setHorizontalTextPosition(MASLLabel.CENTER);
      MASLLabel.setBackground(Color.white);
      MASLLabel.setOpaque(true);
      
      add(MASLLabel, BorderLayout.NORTH);
      
      http="http://mas.cs.umass.edu/research/mass/graphics/simulate/simulator.GIF";
      if (System.getProperty("MASS") != null) 
	http=System.getProperty("MASS");
      TitleLabel = new JLabel(new ImageIcon(new URL(http)));
      TitleLabel.setBackground(Color.white);
      TitleLabel.setOpaque(true);
      add(TitleLabel);

    } catch (MalformedURLException e) {}

    JPanel bottomPanel = new JPanel();

    progressBar = new JProgressBar();
    progressBar.setBackground(Color.white);
    progressBar.setOpaque(true);

    JPanel labelPanel = new JPanel();
    labelPanel.setLayout(new GridLayout(1,0));
    labelPanel.add(new JLabel("     Loading: "));
    currentLabel = new JLabel();
    labelPanel.add(currentLabel);
    labelPanel.setBackground(Color.white);
    labelPanel.setOpaque(true);

    bottomPanel.setLayout(new GridLayout(0,1));
    bottomPanel.add(progressBar);
    bottomPanel.add(labelPanel);

    JPanel buttonPanel = new JPanel();
    
    JButton stopButton = new JButton("Cancel");
    
    stopButton.setBackground (SystemColor.control);
    
    buttonPanel.add(stopButton);

    stopButton.addActionListener(new ActionListener() {

      public void actionPerformed(ActionEvent e) {
	
	stopLoading();
	
      }

    });
    bottomPanel.add(buttonPanel);
    bottomPanel.setBackground(Color.white);
    bottomPanel.setOpaque(true);
    add(bottomPanel, BorderLayout.SOUTH);
  } 

  /**
   * Set the current value of the progress bar
   * @param int value
   */
  public void setValue(int value) {
    progressBar.setValue(value);
    this.currentValue=value;
  }


  /**
   * showProgess increment the progress of 1. This function just shows
   * a progress on the same work.
   */
  public void showProgress() {
    this.setValue(this.currentValue + 1);
    this.currentLabel.setText("                                           ");
  }

  /**
   * showProgress increment the progress of 1, but this time it also displays
   * message about the current work.
   * @param String msg.
   */
  public void showProgress(String msg) {
    this.setValue(this.currentValue + 1);
    this.currentLabel.setText(msg);
  }

  /**
   * You define the minimum and the maximum of the progresBar. using this 
   * value the ProgressBarPanel will compute the step between each progress.
   * @param min<I>imum</I>
   * @param max<I>imum</I>
   */
  public void startLoading(int min, int max) {
    
    shouldStop = false;
    this.progressBar.setValue(min);
    this.currentValue=min;
    this.progressBar.setMinimum(min);
    this.progressBar.setMaximum(max);
    

  }

  /**
   * If the user click on stop loading, this will cancel the load and exit 
   * from the program.
   */
  public void stopLoading() {
    
    System.out.println("Load Cancelled");
	Runtime.getRuntime().exit(0);	
	
    synchronized(lock) {
      shouldStop = true;
      lock.notify();
    }

  }

  /**
   * Complex function that displays the ProgressBar and the different text and
   * button around.
   */
  public Frame display() {  
    this.currentFrame = new Frame ("Loading in Progress...");
    this.currentFrame.addWindowListener(new WindowAdapter() {
      
      public void windowClosing(WindowEvent e) {System.exit(0);}
      
    });
    
    this.currentFrame.add(this);
    this.currentFrame.setBackground(Color.white);
    this.currentFrame.setSize(ProgressBarPanel.DIMENSION);
    this.currentFrame.setLocation(ProgressBarPanel.XPOSITION,
				  ProgressBarPanel.YPOSITION);
    this.currentFrame.setVisible(true);
    this.currentFrame.pack();
    return(this.currentFrame);
  }


  /**
   * Close this window when the load is finished.
   */
  public void dispose() {
    this.currentFrame.dispose();
  }
    
}



