/* Copyright (C) 2005, University of Massachusetts, Multi-Agent Systems Lab
 * See LICENSE for license information
 */

/**
 * $Source: /nfs/shelob/cvs/masl/Mass/modules/simulator/simulator/ConsumableResources.java,v $
 * $Revision: 1.2 $
 *
 *
 *                  Resources classes
 *
 *     Author : Regis Vincent [vincent@cs.umass.edu]
 *              
 *
 *     Creation date: 6 May 98 12:23
 *  Last file update: $Date: 2005/01/19 19:00:05 $
 */
package simulator;

/* Global includes */
import java.awt.*;
import java.util.*;

/* Local includes */
import utilities.Log;


/**
* <B>Module</B>: simulator<p>
 * <B>Copyright</B>: UMASS - MASL 1998<P>
 * @version $Revision: 1.2 $
 * @author Regis Vincent (vincent@cs.umass.edu)<P>
 * <B> Description:</B>
 * Consumable Resources. This classes takes care of the resources 
 * display !!! - Not yet finished -
 */
public class ConsumableResources extends Resources {

  /* Constructor */

  public ConsumableResources(String n, float min, float max, float start, 
			     String u) {
    super(n,min,max,start,u);
  }

  public float getCurrentValue() { return currentValue;}
  public int getCurrentPourcentage() { 
    int value;
    float diff = (currentValue - minimum)/(maximum - minimum);
     value = (int) Math.round(100 * diff);
    return(value);
  }

  //public Panel getDisplay() { return display; }
  
  public synchronized void useResources(float inc, Event exe) {
    // Store the method name and the value in use
    // Add the value to the currentValue
    
    inUse.put(exe,new Float(inc));
    //setCurrentValue(getCurrentValue() - inc);
    
  }


  public synchronized void updateResources(Event exe) {
    if (inUse.get(exe) != null) {
      float value = ((Float)inUse.get(exe)).floatValue();
      setCurrentValue(getCurrentValue()-value);
	  loc.propagateResourceChange(loc, this, new Float(value), null);
	  loc.clearPropMarks();
    }
  }



  public synchronized void releaseResources(Event exe) { 
    // Remove this method from the hashtable and
    // Decreased the value of the currentValue
    logger.log("(Resource " + name + ") " +
	       " Release resource from " + exe.getDisplay().getText(),2);
    if (inUse.get(exe) != null) {
      inUse.remove(exe);
    }
    else 
      logger.log("(Resource " + name + ") " +
		 " Release resource from " + exe.getDisplay().getText() + 
		 " no Entries in the hastable ");
  }
  

  public synchronized float setCurrentValue(float newValue) {
    realValue=newValue;

    if (realValue < minimum) {
      depleted(realValue);
      newValue=minimum;
    }
    else if (newValue > maximum) {
      overload(newValue);
      newValue=maximum;
    }
    else;
      //label.setForeground(Color.black);
    
    logger.log("(Resource " + name + ") current use = " + newValue,3);
    currentValue = newValue;

    //label.setText(""+newValue);
    //pourcent.setText("(" + getCurrentPourcentage() + "%)");

    if (getTaemsResource() != null) {
        logger.log("(Resource " + name + ") Setting taems resource to " + getCurrentValue(), 4);
        getTaemsResource().setState(getCurrentValue());
    } else {
        logger.log("(Resource " + name + ") Couldn't find taems object.", 5);
    }

    return (currentValue);
  }
 
}
