/**************************************************************************
 * ExampleEventListener.java
 **************************************************************************/

package agent.example;

import agent.base.AgentListener;

/**
 * Interface for listening to example events.  All
 * components that wish to received ExampleEvents 
 * must implement this interface.  As you can see below,
 * there is an abstract method for each event id specified
 * by ExampleEvent.  At runtime, when an event producer
 * fires an event, the corresponding listener method will
 * be invoked with the ExampleEvent.
 */
public interface ExampleEventListener extends AgentListener {

  /**
   * Called when an event in STATE1 is fired.
   */
  public void exampleState1(ExampleEvent e);
 
  /**
   * Called when an event in STATE2 is fired.
   */
  public void exampleState2(ExampleEvent e);
}
