/**************************************************************************
 * ExampleEvent.java
 **************************************************************************/

package agent.example;

import agent.base.AgentEvent;

/**
 * Example event structure.  The constants at the top specify
 * the various states the event can be in - this is a sort of
 * sub-category which indicates to the event receiver what kind
 * of "ExampleEvent" the event it receives actually is.
 * <p>
 * Aside from the event's id, an event will usually contain some
 * sort of data in it.  In this ExampleEvent it just stores
 * an arbitrary Object, but in a real event it would likely
 * contain something more specific (e.g. MessageEvents contain
 * references to their respective Message objects).
 */
public class ExampleEvent extends AgentEvent {
  public static final int STATE1 = 0;
  public static final int STATE2 = 1;
  private Object data;

  /** 
   * Constructor
   * @param source The source of the event
   * @param d The data in question
   * @param id The id of the event
   */
  public ExampleEvent(Object source, Object d, int id) {
    super(source, id);
    setData(d);
  }

  /**
   * Get/set accessors.
   */
  public Object getData() { return data; }
  public void setData(Object d) { data = d; }

  /**
   * Stringifys the event
   */
  public String toString() {
    return "ExampleEvent: " + getData().toString();
  }
}
