/*
 * Decompiled with CFR 0.152.
 */
package agent.supplychain;

import agent.base.AgentEvent;
import agent.base.AgentListener;
import agent.base.ListenerVector;
import agent.coordinate.CoordinateEvent;
import agent.coordinate.CoordinateEventListener;
import agent.coordinate.CoordinateEventProducer;
import agent.coordinate.FSMCoordination;
import agent.simplest.Log;
import agent.simplest.State;
import java.util.Enumeration;
import java.util.Vector;
import taems.Agent;
import taems.Commitment;
import taems.ConsumesInterrelationship;
import taems.Method;
import taems.Node;
import taems.Resource;
import taems.Taems;
import taems.TaskBase;
import utilities.TaemsRandom;

class ProductionContractor
implements CoordinateEventListener,
CoordinateEventProducer {
    FSMCoordination fsmCoordinate;
    State state;
    Log log;
    int FAC_PC;
    Taems productiontask;
    CoordinateEventProducer bossP;
    CoordinateEventListener bossL;
    Agent me;
    Vector resource = new Vector();
    Vector quantity = new Vector();
    ListenerVector listeners = new ListenerVector();

    ProductionContractor(Taems t, CoordinateEventListener cel, CoordinateEventProducer cep) {
        this.productiontask = t;
        this.bossL = cel;
        this.bossP = cep;
        this.log = (Log)State.findComponent((String)"Log");
        this.fsmCoordinate = (FSMCoordination)State.findComponent((String)"FSMCoordination");
        this.state = (State)State.findComponent((String)"State");
        this.FAC_PC = this.log.getFacilityID("ProductionContractor");
        this.me = new Agent((String)this.state.getProperty((Object)"Name"));
        this.fsmCoordinate.addCoordinateEventListener(this);
        this.addCoordinateEventListener(this.bossL);
        this.bossP.addCoordinateEventListener(this);
        TaemsRandom.setDefault((TaemsRandom)new TaemsRandom());
        this.log.log("Production Contractor initialized", 1, this.FAC_PC);
    }

    Vector startNegotiation() {
        int ll = this.log.getLogLength();
        this.log.setLogLength(0);
        this.log.log("Starting negotiation", 1, this.FAC_PC);
        this.log.log("on TAEMS structure " + this.productiontask.toString(), 3, this.FAC_PC);
        this.log.setLogLength(ll);
        Enumeration e = this.productiontask.getAllNodes();
        Vector<Long> waitfor = new Vector<Long>();
        while (e.hasMoreElements()) {
            ConsumesInterrelationship ci;
            Node to;
            Node n = (Node)e.nextElement();
            if (!(n instanceof ConsumesInterrelationship) || !((to = (ci = (ConsumesInterrelationship)n).getTo()) instanceof Resource)) continue;
            this.log.log("Found an interrelationship for resource " + to.getLabel(), 2, this.FAC_PC);
            Resource rsc = (Resource)to;
            Taems taskrequest = new Taems();
            Commitment com = new Commitment();
            double quant = (double)ci.getConsumes().calculateAvg() - rsc.getState();
            long cid = TaemsRandom.getDefault().getUniqID();
            waitfor.addElement(new Long(cid));
            com.setType("TaskAssignRequest");
            com.setFromAgent(this.me);
            com.setToAgent(new Agent("*"));
            com.setImportance(0);
            com.setMinimumQuality(10.0f);
            com.setEarliestStartTime(0);
            com.setDeadline(0);
            com.setTimeSatisfied(5);
            this.resource.addElement(rsc.getLabel());
            this.quantity.addElement(new Float(ci.getConsumes().calculateAvg()));
            com.setAttribute((Object)"resource", (Object)rsc.getLabel());
            com.setAttribute((Object)"quantity", (Object)new Float(quant));
            com.setTask((TaskBase)new Method("Produce-" + quant + "-" + rsc.getLabel(), this.me));
            com.setID(cid);
            taskrequest.addCommitment(com);
            this.log.log("Created TAEMS commitment: " + taskrequest, 4, this.FAC_PC);
            CoordinateEvent ce = new CoordinateEvent(this, "TaskAssignRequest", 16, taskrequest);
            ce.setCoordinateID(cid);
            this.log.log("Created commitment " + (Object)((Object)ce), 2, this.FAC_PC);
            this.fireEvent(ce);
        }
        this.log.log("Howdy ho", 1, this.FAC_PC);
        return waitfor;
    }

    public void addCoordinateEventListener(CoordinateEventListener l) {
        this.listeners.add((AgentListener)l);
    }

    public void removeCoordinateEventListener(CoordinateEventListener l) {
        this.listeners.remove((AgentListener)l);
    }

    protected void fireEvent(AgentEvent event) {
        CoordinateEvent e = (CoordinateEvent)event;
        Enumeration enumeration = this.listeners.elements();
        int ll = this.log.getLogLength();
        this.log.setLogLength(0);
        this.log.log("Firing a coordinate event", 2, this.FAC_PC);
        this.log.setLogLength(ll);
        while (enumeration.hasMoreElements()) {
            CoordinateEventListener l = (CoordinateEventListener)enumeration.nextElement();
            if (e.wasReceived()) {
                l.coordinateEventReceived(e);
            }
            if (!e.wasSent()) continue;
            l.coordinateEventSent(e);
        }
        if (this.log != null) {
            this.log.log((AgentEvent)e, 2, this.FAC_PC);
        }
        this.log.log("Fired a coordinate event", 5, this.FAC_PC);
    }

    public void coordinateEventSent(CoordinateEvent e) {
    }

    public void coordinateEventReceived(CoordinateEvent ce) {
        this.log.log("Entering coordinateEventReceived", 2, this.FAC_PC);
        this.log.log("got type " + ce.getType(), 3, this.FAC_PC);
        if (ce.getType().equals("SelectBid")) {
            Commitment selectcommitment = null;
            Enumeration e = ce.getTaems().getCommitments();
            while (e.hasMoreElements()) {
                Commitment c = (Commitment)e.nextElement();
                int ll = this.log.getLogLength();
                this.log.setLogLength(0);
                this.log.log("looking at ce: " + (Object)((Object)ce), 2, this.FAC_PC);
                this.log.setLogLength(ll);
                this.log.log("Looking at bid from " + c.getFromAgent().getLabel(), 3, this.FAC_PC);
                this.log.log("cost " + c.getCostDistribution(), 3, this.FAC_PC);
                this.log.log("avg cost " + c.getCostDistribution().calculateAvg(), 3, this.FAC_PC);
                if (selectcommitment != null && c.getEarliestStartTime() >= selectcommitment.getEarliestStartTime()) continue;
                selectcommitment = c;
            }
            if (selectcommitment != null) {
                Taems t = new Taems();
                t.addCommitment(selectcommitment);
                CoordinateEvent evt = new CoordinateEvent(this, 1, t);
                evt.setType("SelectBid");
                evt.setCoordinateID(ce.getCoordinateID());
                this.fireEvent(evt);
            }
        }
        if (ce.getType().equals("BidConfirmed")) {
            // empty if block
        }
        if (ce.getType().equals("TaskCompleted")) {
            this.log.log("Remote agent reports task " + ce.getTaems().getCommitment().getTask() + "completed", 1, this.FAC_PC);
            ce.setType("ProductionCompleted");
            this.fireEvent(ce);
        }
    }
}

