/*
 * Decompiled with CFR 0.152.
 */
package agent.supplychain;

import agent.coordinate.CoordinateEvent;
import agent.coordinate.FSMCoordination;
import agent.home.BasicProblemSolver;
import agent.mass.Communicate;
import agent.mass.Execute;
import agent.mass.Sensor;
import agent.mass.SimpleTaemsReader;
import agent.simplest.Action;
import agent.simplest.ActionEvent;
import agent.simplest.ActionEventListener;
import agent.simplest.Log;
import agent.simplest.MessageEvent;
import agent.simplest.MessageEventListener;
import agent.simplest.State;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import taems.Agent;
import taems.Commitment;
import taems.ConsumesInterrelationship;
import taems.Interrelationship;
import taems.Method;
import taems.Node;
import taems.Outcome;
import taems.ProducesInterrelationship;
import taems.QAF;
import taems.Resource;
import taems.SeqSumQAF;
import taems.Taems;
import taems.Task;
import taems.TaskBase;
import utilities.Distribution;
import utilities.KQMLMessage;
import utilities.Message;
import utilities.ReverseEnumeration;

public class DeliveryProblemSolver
extends BasicProblemSolver {
    static final long serialVersionUID = 1234567890L;
    protected int FAC_PS;
    FSMCoordination fsmCoordination;
    SimpleTaemsReader str;
    Sensor sensor;
    FSMCoordination fsmCoordinate;
    Agent me;
    LocaleMap currentlocation = null;
    Stack wanderstack = new Stack();
    Taems substruct;
    Taems condstruct;
    Taems objstruct;
    String shortdest;
    String longdest;
    Enumeration r2d2tasklist = new Vector().elements();
    TaskBase current_task = null;
    Task condbase = null;
    boolean wandering = true;
    boolean waiting_for_map = false;
    boolean dothisfirst = true;
    CoordinateEvent coordev = null;
    Hashtable commitmenttable = new Hashtable();

    public DeliveryProblemSolver() {
        this.addDependency("Log");
        this.addDependency("State");
        this.addDependency("Communicate");
        this.addDependency("Execute");
        this.addDependency("Control");
        this.addDependency("Sensor");
        this.addDependency("SimpleTaemsReader");
        this.addDependency("FSMCoordination");
    }

    public void init() {
        this.log = (Log)State.findComponent((String)"Log");
        this.state = (agent.mass.State)State.findComponent((String)"State");
        this.communicate = (Communicate)State.findComponent((String)"Communicate");
        this.execute = (Execute)State.findComponent((String)"Execute");
        this.sensor = (Sensor)State.findComponent((String)"Sensor");
        this.fsmCoordinate = (FSMCoordination)State.findComponent((String)"FSMCoordination");
        this.str = (SimpleTaemsReader)State.findComponent((String)"SimpleTaemsReader");
        this.FAC_PS = this.log.getFacilityID("DeliveryProblemSolver");
        this.communicate.addMessageEventListener((MessageEventListener)this);
        this.execute.addActionEventListener((ActionEventListener)this);
        this.fsmCoordinate.addCoordinateEventListener(this);
        this.log.log("Problem solver initialized", 3, this.FAC_PS);
    }

    public void begin() {
        this.log.log("Problem solver beginning", 3, this.FAC_PS);
    }

    Vector lookforPath(LocaleMap curloc, String s) {
        Vector c = new Vector();
        Stack p = new Stack();
        curloc.findPath(s, p, c);
        if (c.size() == 0) {
            return null;
        }
        Enumeration e = c.elements();
        Vector min = null;
        while (e.hasMoreElements()) {
            Vector l = (Vector)e.nextElement();
            if (min != null && l.size() >= min.size()) continue;
            min = l;
        }
        curloc.addRoute(s, min);
        return min;
    }

    Task moveTo(LocaleMap curloc, String m) {
        this.log.log("Trying to move to " + m, 3, this.FAC_PS);
        Vector path = this.lookforPath(curloc, m);
        if (path != null) {
            Task down = null;
            if (path.size() == 1) {
                return new Task("Already-There", this.me, null);
            }
            Enumeration curpath = path.elements();
            curpath.nextElement();
            while (curpath.hasMoreElements()) {
                LocaleMap l = (LocaleMap)curpath.nextElement();
                this.log.log("Added path to " + l.getName(), 3, this.FAC_PS);
                Task t = new Task("move-to-" + l.getName(), null, (QAF)new SeqSumQAF(), 0, 0, 0);
                Method e = new Method("really-move-to-" + l.getName(), null);
                e.addOutcome(new Outcome("o1", new Distribution(10.0, 1.0), new Distribution(3.0, 1.0), new Distribution(0.0, 1.0), 1.0f));
                if (down == null) {
                    t.setAttribute((Object)"location", (Object)curloc.getName());
                    e.setAttribute((Object)"location", (Object)curloc.getName());
                } else {
                    t.setAttribute((Object)"location", (Object)down.getLabel().substring(8));
                    e.setAttribute((Object)"location", (Object)down.getLabel().substring(8));
                }
                e.setAgent(this.me);
                t.addSubtask((TaskBase)e);
                if (down != null) {
                    t.insertSubtask((TaskBase)down, 0);
                }
                down = t;
            }
            this.shortdest = m;
            return down;
        }
        this.log.log("Don't have destination on map, wandering...", 3, this.FAC_PS);
        this.wandering = true;
        Enumeration e = curloc.getLinks();
        LocaleMap l = null;
        while (e.hasMoreElements()) {
            l = (LocaleMap)e.nextElement();
            if (!l.hasBeenVisited()) break;
        }
        if (l.hasBeenVisited()) {
            LocaleMap p = (LocaleMap)this.wanderstack.pop();
            return this.moveTo(curloc, p.getName());
        }
        this.wanderstack.push(curloc);
        return this.moveTo(curloc, l.getName());
    }

    int sumDuration(TaskBase n) {
        int r = 0;
        if (n instanceof Task) {
            Enumeration e = ((Task)n).getSubtasks();
            while (e.hasMoreElements()) {
                r += this.sumDuration((TaskBase)e.nextElement());
            }
        } else {
            return (int)n.getCurrentDuration();
        }
        return r;
    }

    Method findNextMethod(TaskBase supertask) {
        if (supertask instanceof Method) {
            return (Method)supertask;
        }
        Enumeration e = ((Task)supertask).getSubtasks();
        while (e.hasMoreElements()) {
            TaskBase t = (TaskBase)e.nextElement();
            Method m = this.findNextMethod(t);
            if (m == null) continue;
            return m;
        }
        return null;
    }

    Method findLastMethod(TaskBase supertask) {
        if (supertask instanceof Method) {
            return (Method)supertask;
        }
        ReverseEnumeration e = new ReverseEnumeration(((Task)supertask).getSubtasks());
        while (e.hasMoreElements()) {
            TaskBase t = (TaskBase)e.nextElement();
            Method m = this.findLastMethod(t);
            if (m == null) continue;
            return m;
        }
        return null;
    }

    TaskBase expandStructure(LocaleMap curloc, Method n) {
        Task nt;
        if (curloc.getName().equals((String)n.getAttribute((Object)"location"))) {
            return n;
        }
        Task st = n.firstSupertask();
        int p = st.getSubtaskPosition((Node)n);
        n.excise();
        if (this.condstruct.findNode((Node)new Task("task-" + n.getLabel(), null, null)) != null) {
            int i = 1;
            while (this.condstruct.findNode((Node)new Task("task-" + n.getLabel() + "-" + i, null, null)) != null) {
                ++i;
            }
            nt = new Task("task-" + n.getLabel() + "-" + i, null, (QAF)new SeqSumQAF(), 0, 0, 0);
        } else {
            nt = new Task("task-" + n.getLabel(), null, (QAF)new SeqSumQAF(), 0, 0, 0);
        }
        nt.addSubtask((TaskBase)this.moveTo(curloc, (String)n.getAttribute((Object)"location")));
        nt.addSubtask((TaskBase)n);
        st.insertSubtask((TaskBase)nt, p);
        return nt;
    }

    void doNextTask() {
        Method n = null;
        if (this.current_task != null) {
            n = this.findNextMethod(this.current_task);
        }
        if (n != null) {
            this.log.log("findNextMethod returned " + n.getLabel(), 3, this.FAC_PS);
        } else {
            this.log.log("findNextMethod returned null", 3, this.FAC_PS);
        }
        if (n == null) {
            return;
        }
        if (!this.currentlocation.getName().equals((String)n.getAttribute((Object)"location"))) {
            TaskBase nt = this.expandStructure(this.currentlocation, n);
            if (n == this.current_task) {
                this.current_task = nt;
            }
            n = this.findNextMethod(this.current_task);
        }
        Method b = n;
        while (!b.firstSupertask().getLabel().equals("cond-base") && b.firstSupertask() != null) {
            b = b.firstSupertask();
        }
        this.objstruct = new Taems("Objective-Taems-Structure", this.me);
        this.objstruct.addNode((Node)((TaskBase)b.clone()));
        Enumeration rscs = this.condstruct.findNodes((Node)new Resource());
        while (rscs.hasMoreElements()) {
            this.objstruct.addNode((Node)((Resource)rscs.nextElement()));
        }
        this.log.log("handling new objective structure " + this.objstruct, 1, this.FAC_PS);
        this.str.handleNewObjectiveStructure(this.objstruct, true);
        this.state.setProperty((Object)"CondTaemsTask", (Object)this.condstruct);
        Enumeration ea = this.execute.actions();
        while (ea.hasMoreElements()) {
            Action a = (Action)ea.nextElement();
            if (!a.getName().equals(n.getLabel())) continue;
            return;
        }
        this.execute.executeAction(new Action(n.getLabel()));
    }

    void fullStop() {
        Enumeration e = this.execute.actions();
        while (e.hasMoreElements()) {
            Action a = (Action)e.nextElement();
            if (!a.getName().startsWith("move-to-")) continue;
            this.execute.cancelAction(a, "fullstop");
        }
    }

    public void pulse() {
        this.log.log("Problem solver got pulse", 4, this.FAC_PS);
        if (this.dothisfirst) {
            this.me = new Agent((String)this.state.getProperty((Object)"Name"));
            this.substruct = this.str.makeSubjectiveStructure(true);
            this.condstruct = this.str.makeConditionalStructure(true);
            this.objstruct = new Taems("Objective Taems Structure", this.me);
            this.objstruct.addNode(this.condstruct.findNode((Node)new Task("cond-base", null, null)));
            Enumeration e = this.substruct.findNodes(new Node());
            while (e.hasMoreElements()) {
                Node n = (Node)e.nextElement();
                n.setAgent(this.me);
            }
            this.log.log(this.substruct.toString(), 4, this.FAC_PS);
            this.currentlocation = new LocaleMap((String)this.sensor.readSensorData("Location", "String"));
            this.condbase = (Task)this.condstruct.findNode((Node)new Task("cond-base", null, null));
            this.currentlocation.orientPosition();
            this.current_task = (Task)this.condstruct.findNode((Node)new Task("cond-base", null, null));
            this.doNextTask();
            this.dothisfirst = false;
        }
        if (this.coordev != null) {
            this.coordev = null;
        }
        if (this.wandering && !this.waiting_for_map) {
            String s = (String)this.sensor.readSensorData("LocalAgents", "String");
            StringTokenizer st = new StringTokenizer(s);
            while (st.hasMoreElements()) {
                String a = (String)st.nextElement();
                if (!a.startsWith("Delivery") || a.equals((String)this.state.getProperty((Object)"Name"))) continue;
                KQMLMessage k = new KQMLMessage("ask", (Object)"(for_map)", a);
                this.communicate.sendMessage((Message)k);
                this.waiting_for_map = true;
            }
            if (this.waiting_for_map) {
                this.fullStop();
            }
        }
    }

    public void end() {
        this.log.log("Problem solver ending", 3, this.FAC_PS);
    }

    public void reset() {
        this.log.log("Problem solver reset", 3, this.FAC_PS);
    }

    public void messageSent(MessageEvent e) {
    }

    public void messageReceived(MessageEvent e) {
        if (e.getConnection().getType() != 1) {
            return;
        }
        KQMLMessage m = (KQMLMessage)e.getMessage();
        String perf = m.getPerformative();
        if (perf.equalsIgnoreCase("ask") && m.contentWord().equalsIgnoreCase("for_map")) {
            KQMLMessage map = new KQMLMessage("tell", (Object)("(map " + this.currentlocation.toString() + ")"), m.getSourceAddr());
            this.communicate.sendMessage((Message)map);
        }
        if (perf.equalsIgnoreCase("tell") && m.contentWord().equalsIgnoreCase("map")) {
            LocaleMap lm = this.currentlocation;
            LocaleMap ll = this.currentlocation;
            StringTokenizer st = new StringTokenizer(m.contentData());
            while (st.hasMoreElements()) {
                String el = (String)st.nextElement();
                if (el.startsWith("(")) {
                    if ((lm = lm.lookup(el = el.substring(1))) != null) continue;
                    lm = new LocaleMap(el);
                    continue;
                }
                if (el.endsWith(")")) {
                    el = el.substring(0, el.length() - 1);
                }
                if ((ll = lm.lookup(el)) == null) {
                    ll = new LocaleMap(el);
                }
                lm.addLink(ll);
            }
            if (this.waiting_for_map) {
                this.doNextTask();
                this.wandering = false;
                this.waiting_for_map = false;
            }
        }
    }

    public void actionStarted(ActionEvent e) {
    }

    public void actionAborted(ActionEvent e) {
    }

    public void actionCompleted(ActionEvent e) {
        Method m;
        Action a = e.getAction();
        if (a.getName().equals(this.me.getLabel() + "-Unload")) {
            m = (Method)this.condstruct.findNode((Node)new Method(a.getName(), null));
            CoordinateEvent ce = new CoordinateEvent(this, "ContractCompleted", 16, new Taems());
            ce.setCoordinateID((Long)m.getAttribute((Object)"coordinateID"));
            this.log.log("Sending out " + (Object)((Object)ce), 2, this.FAC_PS);
            this.startFireEvent(ce);
        }
        if (a.getName().startsWith("really-move-to-")) {
            String mt = a.getName().substring(15);
            this.state.setProperty((Object)"Location", (Object)mt);
            this.currentlocation = this.currentlocation.lookup(mt);
            this.currentlocation.orientPosition();
        }
        m = this.findNextMethod(this.current_task);
        if (a.getName().equals(m.getLabel())) {
            Task n = m.firstSupertask();
            m.excise();
            while (n.numSubtasks() == 0 && !n.getLabel().equals("cond-base")) {
                m = n.firstSupertask();
                n.excise();
                n = (Task)m;
            }
        }
        this.doNextTask();
        this.state.setProperty((Object)"CondTaemsTask", (Object)this.condstruct);
    }

    public void coordinateEventReceived(CoordinateEvent ce) {
        this.log.log("Okay, ce type is " + ce.getType(), 0, this.FAC_PS);
        if (ce.getType().equals("GetContract")) {
            this.commitmentReceived(ce);
        }
        if (ce.getType().equals("ConfirmBid")) {
            this.commitmentAccepted(ce);
        }
        if (ce.getType().equals("CancelBid")) {
            this.commitmentRejected(ce);
        }
    }

    public void coordinateEventSent(CoordinateEvent x) {
    }

    public void commitmentPosed(CoordinateEvent e) {
    }

    public void commitmentAccepted(CoordinateEvent e) {
        Commitment com = (Commitment)this.commitmenttable.get(new Long(e.getTaems().getCommitment().getID()));
        if (com != null) {
            this.log.log(this.condstruct.toString(), 2, this.FAC_PS);
            this.condbase = (Task)this.condstruct.findNode((Node)new Task("cond-base", null, null));
            String rsc = (String)com.getAttribute((Object)"resource");
            Task ta = new Task(this.me.getLabel() + "-Ship-" + rsc + "-from-" + com.getAttribute((Object)"from_locale") + "-to-" + com.getAttribute((Object)"to_locale"), this.me, (QAF)new SeqSumQAF());
            Method load = new Method(this.me.getLabel() + "-Load-" + rsc, this.me);
            Method ship = new Method(this.me.getLabel() + "-Ship-" + rsc, this.me);
            Method unload = new Method(this.me.getLabel() + "-Unload-" + rsc, this.me);
            load.addOutcome(new Outcome("o1", new Distribution(10.0, 1.0), new Distribution(5.0, 1.0), new Distribution(10.0, 1.0), 1.0f));
            ship.addOutcome(new Outcome("o1", new Distribution(10.0, 1.0), new Distribution(1.0, 1.0), new Distribution(10.0, 1.0), 1.0f));
            unload.addOutcome(new Outcome("o1", new Distribution(10.0, 1.0), new Distribution(5.0, 1.0), new Distribution(10.0, 1.0), 1.0f));
            float quant = ((Float)com.getAttribute((Object)"quantity")).intValue();
            load.addInterrelationship((Interrelationship)new ConsumesInterrelationship(this.me.getLabel() + "-load-" + rsc, this.me, new Distribution((double)quant, 1.0), "duration_independent"), null, this.condstruct.findNode((Node)new Resource(rsc, null)));
            unload.addInterrelationship((Interrelationship)new ProducesInterrelationship(this.me.getLabel() + "-unload-" + rsc, this.me, new Distribution((double)quant, 1.0), "duration_independent"), null, this.condstruct.findNode((Node)new Resource(rsc, null)));
            load.setAttribute((Object)"location", com.getAttribute((Object)"from_locale"));
            ship.setAttribute((Object)"location", com.getAttribute((Object)"to_locale"));
            unload.setAttribute((Object)"location", com.getAttribute((Object)"to_locale"));
            unload.setAttribute((Object)"coordinateID", (Object)new Long(com.getID()));
            ta.addSubtask((TaskBase)load);
            ta.addSubtask((TaskBase)ship);
            ta.addSubtask((TaskBase)unload);
            this.condbase.addSubtask((TaskBase)ta);
            if (!this.execute.isExecuting()) {
                this.doNextTask();
            }
            this.state.setProperty((Object)"CondTaemsTask", (Object)this.condstruct);
        }
    }

    public void commitmentRejected(CoordinateEvent e) {
    }

    public void commitmentCanceled(CoordinateEvent e) {
    }

    public void commitmentReceived(CoordinateEvent e) {
        this.log.log("looking for " + new TaskBase(e.getTaems().getCommitment().getTask().getLabel(), null).toString(), 1, this.FAC_PS);
        TaskBase ct = (TaskBase)this.substruct.findNode((Node)new TaskBase(e.getTaems().getCommitment().getTask().getLabel(), null));
        if (ct != null) {
            int dur = 0;
            if (this.current_task != null) {
                Enumeration en = this.condbase.getSubtasks();
                LocaleMap curloc = this.currentlocation;
                while (en.hasMoreElements()) {
                    TaskBase tb = (TaskBase)en.nextElement();
                    if (tb instanceof Method) {
                        this.expandStructure(curloc, (Method)tb);
                        curloc = curloc.lookup((String)tb.getAttribute((Object)"location"));
                        continue;
                    }
                    curloc = curloc.lookup((String)this.findLastMethod(tb).getAttribute((Object)"location"));
                }
                dur = this.sumDuration((TaskBase)this.condbase);
            }
            Commitment c = (Commitment)e.getTaems().getCommitment().clone();
            Enumeration ea = this.execute.actions();
            c.setEarliestStartTime((Integer)this.state.getProperty((Object)"Time") + dur);
            c.setDeadline((Integer)this.state.getProperty((Object)"Time") + dur + (int)ct.getCurrentDuration());
            c.setType("Accept");
            c.setToAgent(c.getFromAgent());
            c.setFromAgent(this.me);
            Taems t = new Taems();
            t.addCommitment(c);
            this.coordev = new CoordinateEvent(this, "AcceptContract", 16, t);
            this.coordev.setCoordinateID(e.getCoordinateID());
            this.log.log("we come in peace:" + e.getCoordinateID(), 1, this.FAC_PS);
            this.log.log("Firing a CoordinateEvent, " + this.coordev.toString(), 1, this.FAC_PS);
            this.startFireEvent(this.coordev);
            this.commitmenttable.put(new Long(c.getID()), c);
        }
    }

    class LocaleMap {
        String name;
        Vector links_to = new Vector();
        Hashtable routes = new Hashtable();
        boolean visited = false;
        boolean touched = false;
        Sensor sensor = (Sensor)State.findComponent((String)"Sensor");
        Log log = (Log)State.findComponent((String)"Log");

        LocaleMap(String n) {
            this.name = n;
        }

        public String getName() {
            return this.name;
        }

        public void orientPosition() {
            if (this.visited) {
                return;
            }
            this.visited = true;
            String links = (String)this.sensor.readSensorData("Links", "String");
            StringTokenizer e = new StringTokenizer(links, " ");
            while (e.hasMoreElements()) {
                String link = e.nextToken();
                link = link.substring(1, link.length() - 1);
                StringTokenizer t = new StringTokenizer(link, ",");
                String ln = (String)t.nextElement();
                String rm = (String)t.nextElement();
                LocaleMap nlm = this.lookup(rm);
                if (nlm != null) continue;
                nlm = new LocaleMap(rm);
                this.addLink(nlm);
                nlm.addLink(this);
            }
        }

        public void addRoute(String n, Vector r) {
            if (!this.routes.containsKey(n)) {
                this.routes.put(n, r);
            }
        }

        public void addLink(LocaleMap l) {
            if (!this.links_to.contains(l)) {
                Enumeration n = this.getLinks();
                while (n.hasMoreElements()) {
                    if (!((LocaleMap)n.nextElement()).getName().equals(l.getName())) continue;
                    return;
                }
                this.links_to.addElement(l);
            }
        }

        public boolean isTouched() {
            return this.touched;
        }

        public boolean hasBeenVisited() {
            return this.visited;
        }

        public Enumeration getLinks() {
            return this.links_to.elements();
        }

        public LocaleMap lookup(String s) {
            if (this.name.equals(s)) {
                return this;
            }
            this.touched = true;
            Enumeration e = this.getLinks();
            while (e.hasMoreElements()) {
                LocaleMap r;
                LocaleMap l = (LocaleMap)e.nextElement();
                if (l.isTouched() || (r = l.lookup(s)) == null) continue;
                this.touched = false;
                return r;
            }
            this.touched = false;
            return null;
        }

        public void findPath(String dst, Stack pathstack, Vector pathes) {
            if (this.routes.containsKey(dst)) {
                Enumeration e = ((Vector)this.routes.get(dst)).elements();
                Stack s = (Stack)pathstack.clone();
                while (e.hasMoreElements()) {
                    s.push(e.nextElement());
                }
                pathes.addElement(s);
                return;
            }
            this.touched = true;
            pathstack.push(this);
            if (this.name.equals(dst)) {
                pathes.addElement(pathstack.clone());
                pathstack.pop();
                this.touched = false;
                return;
            }
            Enumeration e = this.getLinks();
            while (e.hasMoreElements()) {
                LocaleMap l = (LocaleMap)e.nextElement();
                if (l.isTouched()) continue;
                l.findPath(dst, pathstack, pathes);
            }
            pathstack.pop();
            this.touched = false;
        }

        public String toString() {
            LocaleMap lm;
            this.touched = true;
            Enumeration e = this.getLinks();
            String ret = "(" + this.name + " ";
            while (e.hasMoreElements()) {
                lm = (LocaleMap)e.nextElement();
                ret = ret + lm.getName();
                if (!e.hasMoreElements()) continue;
                ret = ret + " ";
            }
            ret = ret + ") ";
            e = this.getLinks();
            while (e.hasMoreElements()) {
                lm = (LocaleMap)e.nextElement();
                if (lm.isTouched()) continue;
                ret = ret + lm.toString();
            }
            this.touched = false;
            return ret;
        }
    }
}

