/*
 * Decompiled with CFR 0.152.
 */
package agent.supplychain;

import agent.coordinate.CoordinateEvent;
import agent.coordinate.FSMCoordination;
import agent.home.BasicProblemSolver;
import agent.mass.Communicate;
import agent.mass.Execute;
import agent.mass.PreprocessTaemsReader;
import agent.simplest.Action;
import agent.simplest.ActionEvent;
import agent.simplest.ActionEventListener;
import agent.simplest.Log;
import agent.simplest.MessageEvent;
import agent.simplest.MessageEventListener;
import agent.simplest.PropertyEvent;
import agent.simplest.State;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Vector;
import taems.Agent;
import taems.Commitment;
import taems.Taems;
import utilities.KQMLMessage;

public class DeliveryDispatcherProblemSolver
extends BasicProblemSolver {
    static final long serialVersionUID = 1234567890L;
    protected int FAC_PS;
    FSMCoordination fsmCoordinate;
    PreprocessTaemsReader taemsreader;
    Vector delivery_tasks;
    int count = 0;
    Commitment selectcommitment;

    public DeliveryDispatcherProblemSolver() {
        this.addDependency("Log");
        this.addDependency("State");
        this.addDependency("Communicate");
        this.addDependency("Execute");
        this.addDependency("FSMCoordination");
    }

    public void init() {
        this.log = (Log)State.findComponent((String)"Log");
        this.state = (agent.mass.State)State.findComponent((String)"State");
        this.communicate = (Communicate)State.findComponent((String)"Communicate");
        this.execute = (Execute)State.findComponent((String)"Execute");
        this.fsmCoordinate = (FSMCoordination)State.findComponent((String)"FSMCoordination");
        this.taemsreader = (PreprocessTaemsReader)State.findComponent((String)"PreprocessTaemsReader");
        this.FAC_PS = this.log.getFacilityID("ProblemSolver");
        this.communicate.addMessageEventListener((MessageEventListener)this);
        this.execute.addActionEventListener((ActionEventListener)this);
        this.fsmCoordinate.addCoordinateEventListener(this);
        this.log.log("Problem solver initialized", 3, this.FAC_PS);
    }

    public void begin() {
        this.log.log("Problem solver beginning", 3, this.FAC_PS);
        this.delivery_tasks = new Vector();
    }

    public void pulse() {
        this.log.log("Problem solver got pulse", 4, this.FAC_PS);
        Enumeration e = this.delivery_tasks.elements();
        while (e.hasMoreElements()) {
            TaskToDo ttd = (TaskToDo)e.nextElement();
            if (ttd.getTimeout() == -1) {
                this.log.log("Sending out contract: " + (Object)((Object)ttd.poseContract((String)this.state.getProperty((Object)"Name"))), 2, this.FAC_PS);
                continue;
            }
            ttd.setTimeout(ttd.getTimeout() - 1);
        }
    }

    public void end() {
        this.log.log("Problem solver ending", 3, this.FAC_PS);
    }

    public void reset() {
        this.log.log("Problem solver reset", 3, this.FAC_PS);
    }

    public void messageSent(MessageEvent e) {
    }

    public void messageReceived(MessageEvent e) {
        if (e.getConnection().getType() != 1) {
            return;
        }
        KQMLMessage m = (KQMLMessage)e.getMessage();
        String perf = m.getPerformative();
        if (perf.equalsIgnoreCase("tell")) {
            String cw = m.contentWord();
            String cd = m.contentData();
            if (cw.equals("Commitment")) {
                this.log.log("got a commitment from simulator " + cd, 4, this.FAC_PS);
                Taems tm = this.taemsreader.readTTaems(new StringReader(cd));
                this.delivery_tasks.addElement(new TaskToDo(tm.getCommitment()));
            }
        }
    }

    public void propertyAdded(PropertyEvent e) {
        this.propertyChanged(e);
    }

    public void propertyRemoved(PropertyEvent e) {
    }

    public void propertyChanged(PropertyEvent e) {
        String key = e.getKey().toString();
        if (key.equals("ExampleProperty")) {
            Object object = e.getProperty();
        }
    }

    public void actionStarted(ActionEvent e) {
    }

    public void actionAborted(ActionEvent e) {
    }

    public void actionCompleted(ActionEvent e) {
        Action action = e.getAction();
    }

    public void coordinateEventReceived(CoordinateEvent ce) {
        Enumeration e;
        this.log.log("booga !*!*!*!*!*!*!*!*!*!* booga", 0, this.FAC_PS);
        this.log.log("got type " + ce.getType(), 0, this.FAC_PS);
        if (ce.getType().equals("SelectBid")) {
            e = ce.getTaems().getCommitments();
            while (e.hasMoreElements()) {
                Commitment c = (Commitment)e.nextElement();
                this.selectcommitment = null;
                this.log.log("Looking at bid from " + c.getFromAgent().getLabel() + " of finish time " + c.getDeadline(), 3, this.FAC_PS);
                if (this.selectcommitment != null && c.getDeadline() >= this.selectcommitment.getDeadline()) continue;
                this.selectcommitment = c;
            }
            if (this.selectcommitment != null) {
                Taems t = new Taems();
                t.addCommitment(this.selectcommitment);
                CoordinateEvent evt = new CoordinateEvent(this, 1, t);
                evt.setType("SelectBid");
                evt.setCoordinateID(ce.getCoordinateID());
                this.startFireEvent(evt);
            }
        }
        if (ce.getType().equals("BidConfirmed")) {
            e = this.delivery_tasks.elements();
            while (e.hasMoreElements()) {
                TaskToDo ttd = (TaskToDo)e.nextElement();
                if (ttd.getCommitment() != null || !ttd.getTask().getTask().equals(this.selectcommitment.getTask())) continue;
                ttd.setCommitment(this.selectcommitment);
                ttd.setTimeout(this.selectcommitment.getDeadline());
                break;
            }
        }
        if (ce.getType().equals("TaskCompleted")) {
            this.log.log("Remote agent reports task " + ce.getTaems().getCommitment().getTask() + "completed", 1, this.FAC_PS);
        }
    }

    public void coordinateEventSent(CoordinateEvent x) {
    }

    public void commitmentPosed(CoordinateEvent e) {
    }

    public void commitmentAccepted(CoordinateEvent e) {
    }

    public void commitmentRejected(CoordinateEvent e) {
    }

    public void commitmentCanceled(CoordinateEvent e) {
    }

    public void commitmentReceived(CoordinateEvent e) {
    }

    class TaskToDo {
        Commitment taskrequested;
        Commitment commitmentreceived = null;
        int contract_timeout;
        boolean completed = false;

        public TaskToDo(Commitment n) {
            this.taskrequested = n;
            this.contract_timeout = -1;
        }

        public Commitment getTask() {
            return this.taskrequested;
        }

        public void setCommitment(Commitment c) {
            this.commitmentreceived = c;
        }

        public boolean hasCommitment() {
            return this.commitmentreceived != null;
        }

        public Commitment getCommitment() {
            return this.commitmentreceived;
        }

        public void setTaskCompleted(boolean b) {
            this.completed = b;
        }

        public boolean isCompleted() {
            return this.completed;
        }

        public int getTimeout() {
            return this.contract_timeout;
        }

        public void setTimeout(int c) {
            this.contract_timeout = c;
        }

        public CoordinateEvent poseContract(String name) {
            Commitment com = (Commitment)this.taskrequested.clone();
            com.setType("TaskAssignRequest");
            com.setFromAgent(new Agent(name));
            com.setToAgent(new Agent("*"));
            com.setImportance(0);
            com.setMinimumQuality(10.0f);
            com.setEarliestStartTime(0);
            com.setDeadline(0);
            com.setTimeSatisfied(5);
            Taems t = new Taems();
            t.addCommitment(com);
            CoordinateEvent ce = new CoordinateEvent(this, "TaskAssignRequest", 16, t);
            ce.setCoordinateID(com.getID());
            DeliveryDispatcherProblemSolver.this.startFireEvent(ce);
            this.contract_timeout = 12;
            return ce;
        }
    }
}

