/*
 * Decompiled with CFR 0.152.
 */
package agent.supplychain;

import agent.base.AgentEvent;
import agent.base.AgentListener;
import agent.base.ListenerVector;
import agent.coordinate.CoordinateEvent;
import agent.coordinate.CoordinateEventListener;
import agent.coordinate.CoordinateEventProducer;
import agent.coordinate.FSMCoordination;
import agent.simplest.Log;
import agent.simplest.State;
import java.util.Enumeration;
import taems.Agent;
import taems.Commitment;
import taems.Node;
import taems.ProducesInterrelationship;
import taems.Resource;
import taems.Taems;
import taems.TaskBase;
import utilities.Distribution;

class ContractSupplier
implements CoordinateEventListener,
CoordinateEventProducer {
    FSMCoordination fsmCoordinate;
    State state;
    Log log;
    int FAC_CS;
    CoordinateEventListener bossL;
    CoordinateEventProducer bossP;
    Agent me;
    ListenerVector listeners = new ListenerVector();

    ContractSupplier(CoordinateEventListener cel, CoordinateEventProducer cep) {
        this.fsmCoordinate = (FSMCoordination)State.findComponent((String)"FSMCoordination");
        this.log = (Log)State.findComponent((String)"Log");
        this.state = (State)State.findComponent((String)"State");
        this.FAC_CS = this.log.getFacilityID("ContractSupplier");
        this.me = new Agent((String)this.state.getProperty((Object)"Name"));
        this.bossL = cel;
        this.bossP = cep;
        this.fsmCoordinate.addCoordinateEventListener(this);
        this.addCoordinateEventListener(this.bossL);
        this.bossP.addCoordinateEventListener(this);
        this.log.log("ContractSupplier initialized for " + this.me.getLabel(), 2, this.FAC_CS);
    }

    void placeBid(long coordinateid, Agent toagent, Taems productiontask, int earliestStartTime) {
        if (productiontask == null) {
            return;
        }
        Taems taskrequest = new Taems();
        Enumeration e = productiontask.getAllNodes();
        while (e.hasMoreElements()) {
            Node n = (Node)e.nextElement();
            if (!(n instanceof ProducesInterrelationship)) continue;
            ProducesInterrelationship pi = (ProducesInterrelationship)n;
            Node to = pi.getTo();
            Node from = pi.getFrom();
            if (!(to instanceof Resource)) continue;
            Resource rsc = (Resource)to;
            TaskBase meth = (TaskBase)from;
            Commitment com = new Commitment();
            com.setType("Accept");
            com.setFromAgent(this.me);
            com.setToAgent(toagent);
            com.setImportance(0);
            com.setMinimumQuality(10.0f);
            com.setEarliestStartTime(earliestStartTime);
            com.setDeadline(0);
            com.setTimeSatisfied(5);
            com.setCostDistribution(new Distribution((double)meth.getCurrentCost(), 1.0));
            com.setAttribute((Object)"resource", (Object)rsc.getLabel());
            com.setAttribute((Object)"quantity", (Object)new Float(pi.getProduces().calculateAvg()));
            com.setTask((TaskBase)from);
            com.setID(coordinateid);
            taskrequest.addCommitment(com);
        }
        CoordinateEvent coordev = new CoordinateEvent(this, "AcceptContract", 16, taskrequest);
        coordev.setCoordinateID(coordinateid);
        int ll = this.log.getLogLength();
        this.log.setLogLength(0);
        this.log.log("Sending out bid!!!! " + (Object)((Object)coordev), 3, this.FAC_CS);
        this.log.setLogLength(ll);
        this.fireEvent(coordev);
    }

    void taskCompleted(long coordinateid) {
        CoordinateEvent ce = new CoordinateEvent(this, "ContractCompleted", 16, new Taems());
        ce.setCoordinateID(coordinateid);
        this.log.log("Sending out " + (Object)((Object)ce), 2, this.FAC_CS);
        this.fireEvent(ce);
    }

    public void addCoordinateEventListener(CoordinateEventListener l) {
        this.listeners.add((AgentListener)l);
    }

    public void removeCoordinateEventListener(CoordinateEventListener l) {
        this.listeners.remove((AgentListener)l);
    }

    protected void fireEvent(AgentEvent event) {
        CoordinateEvent e = (CoordinateEvent)event;
        Enumeration enumeration = this.listeners.elements();
        int ll = this.log.getLogLength();
        this.log.setLogLength(0);
        this.log.log("Firing a coordinate event", 4, this.FAC_CS);
        this.log.setLogLength(ll);
        while (enumeration.hasMoreElements()) {
            CoordinateEventListener l = (CoordinateEventListener)enumeration.nextElement();
            if (e.wasReceived()) {
                l.coordinateEventReceived(e);
            }
            if (!e.wasSent()) continue;
            l.coordinateEventSent(e);
        }
        if (this.log != null) {
            this.log.log((AgentEvent)e, 2, this.FAC_CS);
        }
        this.log.log("Fired a coordinate event", 5, this.FAC_CS);
    }

    public void coordinateEventSent(CoordinateEvent e) {
    }

    public void coordinateEventReceived(CoordinateEvent ce) {
        this.log.log("coordinateEventReceived: " + (Object)((Object)ce), 3, this.FAC_CS);
        Enumeration e = this.listeners.elements();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            this.log.log("will send messages to a " + o.getClass().getName(), 3, this.FAC_CS);
        }
        this.log.log("Okay, ce type is " + ce.getType(), 1, this.FAC_CS);
        if (ce.getType().equals("GetContract")) {
            this.log.log("Reconignized a GetContract, should send out a ProductionRequested event", 2, this.FAC_CS);
            ce.setType("ProductionRequested");
            this.fireEvent(ce);
            this.log.log("did send out ProductionRequested event", 2, this.FAC_CS);
        }
        if (ce.getType().equals("ConfirmBid")) {
            ce.setType("ProductionRequestConfirmed");
            this.fireEvent(ce);
        }
        if (ce.getType().equals("CancelBid")) {
            ce.setType("ProductionRequestCanceled");
            this.fireEvent(ce);
        }
        switch (ce.getID()) {
            case 4096: {
                this.log.log("commitmentEventReceived REJECTED", 2, this.FAC_CS);
                break;
            }
            case 65536: {
                this.log.log("commitmentEventReceived TIMED OUT", 2, this.FAC_CS);
                break;
            }
            case 1: {
                this.log.log("commitmentEventReceived ACCEPTED", 2, this.FAC_CS);
                break;
            }
            case 16: {
                this.log.log("commitmentEventReceived POSED", 2, this.FAC_CS);
                break;
            }
            case 256: {
                this.log.log("commitmentEventReceived CANCELED", 2, this.FAC_CS);
                break;
            }
            default: {
                this.log.log("commitmentEventReceived Unknown: " + ce.getID(), 2, this.FAC_CS);
            }
        }
    }
}

