/*
 * Decompiled with CFR 0.152.
 */
package agent.supplychain;

import agent.base.AgentEvent;
import agent.base.AgentListener;
import agent.base.ListenerVector;
import agent.coordinate.CoordinateEvent;
import agent.coordinate.CoordinateEventListener;
import agent.coordinate.CoordinateEventProducer;
import agent.mass.PreprocessTaemsReader;
import agent.mass.ProblemSolver;
import agent.mass.ScheduleErrorException;
import agent.mass.SimpleTaemsReader;
import agent.mass.TaemsAction;
import agent.partialorder.PartialOrderScheduler;
import agent.partialorder.ResourceBindingsException;
import agent.simplest.ActionEvent;
import agent.simplest.MessageEvent;
import agent.simplest.PropertyEvent;
import agent.simplest.PropertyEventListener;
import agent.simplest.Sensor;
import agent.simplest.State;
import agent.supplychain.ContractSupplier;
import agent.supplychain.ProductionContractor;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JOptionPane;
import taems.Agent;
import taems.Commitment;
import taems.MLCSchedule;
import taems.Method;
import taems.Node;
import taems.Resource;
import taems.Schedule;
import taems.Taems;

public class BasicAgentController
extends ProblemSolver
implements PropertyEventListener,
CoordinateEventListener,
CoordinateEventProducer,
MouseListener {
    protected MLCSchedule mlcs;
    protected int TIMEOUT = 5;
    protected PartialOrderScheduler scheduler;
    protected PreprocessTaemsReader ppTaemsReader;
    protected Vector waitingCommitments = new Vector();
    protected ContractSupplier contractSupplier;
    protected Agent me;
    ListenerVector listeners = new ListenerVector();
    Vector currenttasks = new Vector();
    Vector prereqs;
    int time;
    String resource;
    Float quantity;

    public BasicAgentController() {
        this.addDependency("Scheduler");
        this.addDependency("PreprocessTaemsReader");
        this.addDependency("Log");
        this.addDependency("FSMCoordination");
        ((Component)((Object)this)).addMouseListener(this);
    }

    public void init() {
        super.init();
        this.scheduler = (PartialOrderScheduler)State.findComponent((String)"Scheduler");
        this.ppTaemsReader = (PreprocessTaemsReader)State.findComponent((String)"PreprocessTaemsReader");
        this.log.log("Basic agent Controller Version 1.0", 2, this.FAC_PS);
        if (this.state != null) {
            this.state.setProperty((Object)"SetTaemsName", (Object)new Boolean(true));
            this.state.setProperty((Object)"UpdateDist", (Object)new Boolean(true));
            this.state.setProperty((Object)"AutoExecute", (Object)new Boolean(true));
            this.state.setProperty((Object)"MultiTaems", (Object)new Boolean(true));
        }
        this.me = new Agent((String)this.state.getProperty((Object)"Name"));
    }

    public void reset() {
    }

    public void begin() {
        this.mlcs = new MLCSchedule();
    }

    public void addTaems(Hashtable ht) {
        try {
            this.scheduler.scheduleTaems(ht, this.mlcs, true);
            this.state.setProperty((Object)"Schedule", (Object)this.mlcs);
        }
        catch (ResourceBindingsException rex) {
            this.log.log("Sorry, resource problem allocation ", 0, this.FAC_PS);
        }
        catch (ScheduleErrorException sex) {
            this.log.log("Sorry, no schedule found ", 0, this.FAC_PS);
        }
    }

    protected Hashtable getResources(Taems t, Hashtable ht) {
        Enumeration en = t.getNodes();
        while (en.hasMoreElements()) {
            Node n = (Node)en.nextElement();
            if (!(n instanceof Resource)) continue;
            Vector v = new Vector();
            if (ht.containsKey(n.getLabel())) {
                v = (Vector)ht.get(n.getLabel());
            }
            v.addElement(n);
            ht.put(n.getLabel(), v);
        }
        return ht;
    }

    public float getCurrentLevels() {
        Taems taems;
        Enumeration<Object> e;
        Sensor sensor = (Sensor)State.findComponent((String)"Sensor");
        Hashtable resources = new Hashtable();
        Object t = this.state.getProperty((Object)SimpleTaemsReader.SUBTAEMS);
        if (t == null) {
            this.log.log("Sorry, no subjective view found for resource detection", 0, this.FAC_PS);
        }
        if (t instanceof Hashtable) {
            e = ((Hashtable)t).elements();
            while (e.hasMoreElements()) {
                taems = (Taems)e.nextElement();
                resources = this.getResources(taems, resources);
            }
        } else {
            taems = (Taems)t;
            resources = this.getResources(taems, resources);
        }
        t = this.state.getProperty((Object)SimpleTaemsReader.CONTAEMS);
        if (t == null) {
            this.log.log("Sorry, no conditional view found for resource detection", 0, this.FAC_PS);
        }
        if (t instanceof Hashtable) {
            e = ((Hashtable)t).elements();
            while (e.hasMoreElements()) {
                taems = (Taems)e.nextElement();
                resources = this.getResources(taems, resources);
            }
        } else {
            taems = (Taems)t;
            resources = this.getResources(taems, resources);
        }
        if (sensor != null) {
            e = resources.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                Vector v = (Vector)resources.get(key);
                Float result = (Float)sensor.readSensorData(key, "Float");
                if (result != null) {
                    Enumeration e1 = v.elements();
                    while (e1.hasMoreElements()) {
                        Resource r = (Resource)e1.nextElement();
                        this.log.log("Updating resource " + key + " = " + result, 2, this.FAC_PS);
                        r.setState(result.doubleValue());
                    }
                    continue;
                }
                this.log.log("Error reading " + key + " sensor data", 0, this.FAC_PS);
            }
        } else {
            this.log.log("Error: Cannot read resource level sensor; Sensor component not available", 0, this.FAC_PS);
        }
        return -1.0f;
    }

    public void pulse() {
        String temp = new String();
        if (this.contractSupplier == null) {
            this.contractSupplier = new ContractSupplier(this, this);
        }
        this.log.log("state.getProperty(\"MakeContracts\") is " + this.state.getProperty((Object)"MakeContracts"), this.FAC_PS, 2);
    }

    public void messageSent(MessageEvent e) {
    }

    public void messageReceived(MessageEvent e) {
    }

    public void propertyChanged(PropertyEvent e) {
    }

    public void propertyRemoved(PropertyEvent e) {
        this.propertyChanged(e);
    }

    public void propertyAdded(PropertyEvent e) {
        this.propertyChanged(e);
    }

    public void actionStarted(ActionEvent e) {
    }

    public void actionAborted(ActionEvent e) {
        this.actionCompleted(e);
    }

    public void actionCompleted(ActionEvent e) {
        TaemsAction a = (TaemsAction)e.getAction();
        Method m = a.getMethod();
        Hashtable ht = (Hashtable)this.state.getProperty((Object)SimpleTaemsReader.CONTAEMS);
        if (ht != null) {
            Enumeration enumeration = ht.keys();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                Taems t = (Taems)ht.get(key);
                Schedule s = t.getFirstSchedule();
                if (s == null || !s.isCompleted()) continue;
                ht.remove(key);
                this.state.setProperty((Object)SimpleTaemsReader.CONTAEMS, (Object)ht);
                ht = (Hashtable)this.state.getProperty((Object)SimpleTaemsReader.SUBTAEMS);
                if (ht == null) continue;
                ht.remove(key);
                this.state.setProperty((Object)SimpleTaemsReader.SUBTAEMS, (Object)ht);
            }
        }
        if (m.getCurrentQuality() != 0.0f) {
            this.log.log("The method " + m.getLabel() + " suceeded.", 2, this.FAC_PS);
            int i = 0;
            while (i < this.currenttasks.size()) {
                Object[] tuple = (Object[])this.currenttasks.elementAt(i);
                this.log.log("Testing if task completed is " + (String)tuple[1] + " with CID " + (Long)tuple[0], 2, this.FAC_PS);
                if (((String)tuple[1]).equals(e.getAction().getName())) {
                    this.contractSupplier.taskCompleted((Long)tuple[0]);
                    this.currenttasks.removeElementAt(i);
                    --i;
                }
                ++i;
            }
        }
        if (m.getCurrentQuality() == 0.0f) {
            this.log.log("The method " + m.getLabel() + " failed (quality 0).", 2, this.FAC_PS);
        }
    }

    public void addCoordinateEventListener(CoordinateEventListener l) {
        this.listeners.add((AgentListener)l);
    }

    public void removeCoordinateEventListener(CoordinateEventListener l) {
        this.listeners.remove((AgentListener)l);
    }

    protected void fireEvent(AgentEvent event) {
        CoordinateEvent e = (CoordinateEvent)event;
        Enumeration enumeration = this.listeners.elements();
        this.log.log("Firing a coordinate event", 4, this.FAC_PS);
        while (enumeration.hasMoreElements()) {
            CoordinateEventListener l = (CoordinateEventListener)enumeration.nextElement();
            if (e.wasReceived()) {
                l.coordinateEventReceived(e);
            }
            if (!e.wasSent()) continue;
            l.coordinateEventSent(e);
        }
        if (this.log != null) {
            this.log.log((AgentEvent)e, 2, this.FAC_PS);
        }
        this.log.log("Fired a coordinate event", 5, this.FAC_PS);
    }

    public void coordinateEventSent(CoordinateEvent e) {
    }

    public void coordinateEventReceived(CoordinateEvent ce) {
        this.log.log("coordinateEventReceived: " + (Object)((Object)ce), 3, this.FAC_PS);
        if (ce.getType().equals("ProductionRequested")) {
            this.productionRequestDecision(ce.getCoordinateID(), ce.getTaems());
        }
        if (ce.getType().equals("ProductionRequestConfirmed")) {
            Object[] tuple = new Object[]{ce.getCoordinateID(), ce.getTaems().getCommitment().getTask().getLabel()};
            this.currenttasks.addElement(tuple);
            this.regenerateTaems(ce.getTaems());
        }
        if (ce.getType().equals("ProductionRequestCanceled")) {
            // empty if block
        }
        if (ce.getType().equals("ProductionCompleted")) {
            this.log.log("PRODUCTIONCOMPLETED!!!!!", 0, this.FAC_PS);
            int i = 0;
            while (i < this.prereqs.size()) {
                this.log.log("does " + (Long)this.prereqs.elementAt(i) + " == " + ce.getCoordinateID() + "? " + ((Long)this.prereqs.elementAt(i)).equals(ce.getCoordinateID()), 3, this.FAC_PS);
                if (((Long)this.prereqs.elementAt(i)).equals(ce.getCoordinateID())) {
                    this.prereqs.removeElementAt(i);
                    --i;
                }
                ++i;
            }
            this.log.log("prereqs.isEmpty() " + this.prereqs.isEmpty(), 3, this.FAC_PS);
            if (this.prereqs.isEmpty()) {
                Hashtable<String, Object> ht = new Hashtable<String, Object>();
                System.err.println("Helll !!!");
                this.time = (Integer)this.state.getProperty((Object)"Time");
                ht.put("ORDER", new Integer(this.time));
                ht.put("PRODUCE_" + this.resource, "yes");
                ht.put(this.resource + "_QUANTITY", this.quantity);
                this.ppTaemsReader.makeAllStructures(ht);
            }
        }
    }

    void productionRequestDecision(Long coordinateID, Taems contract) {
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        Enumeration e = contract.getCommitments();
        while (e.hasMoreElements()) {
            Commitment c = (Commitment)e.nextElement();
            String rsc = (String)c.getAttribute((Object)"resource");
            Float quant = (Float)c.getAttribute((Object)"quantity");
            ht.put("ORDER", new Long(c.getID()));
            ht.put("AGENT", this.me.getLabel());
            ht.put("PRODUCE_" + rsc.toUpperCase(), "yes");
            ht.put(rsc.toUpperCase() + "_QUANTITY", (Float)c.getAttribute((Object)"quantity"));
        }
        e = ht.keys();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            this.log.log("have " + s + " which is " + ht.get(s), 2, this.FAC_PS);
        }
        Taems bid = this.ppTaemsReader.makeTaemsStructure(ht);
        this.contractSupplier.placeBid(coordinateID, contract.getCommitment().getFromAgent(), bid, this.mlcs.getFinishTime());
    }

    void regenerateTaems(Taems contract) {
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        Enumeration e = contract.getCommitments();
        while (e.hasMoreElements()) {
            Commitment c = (Commitment)e.nextElement();
            String rsc = (String)c.getAttribute((Object)"resource");
            Float quant = (Float)c.getAttribute((Object)"quantity");
            ht.put("ORDER", new Long(c.getID()));
            ht.put("AGENT", this.me.getLabel());
            ht.put("PRODUCE_" + rsc.toUpperCase(), "yes");
            ht.put(rsc.toUpperCase() + "_QUANTITY", (Float)c.getAttribute((Object)"quantity"));
        }
        this.ppTaemsReader.makeAllStructures(ht);
    }

    void generateProductionCommitment(String rsrc, float quant) {
        this.log.log("Going to do some contracting for " + rsrc, 0, this.FAC_PS);
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        this.resource = rsrc.toUpperCase();
        this.quantity = new Float(quant);
        ht.put("PRODUCE_" + this.resource, "yes");
        ht.put(this.resource + "_QUANTITY", this.quantity);
        this.log.log("gonna produce " + ht.get(rsrc.toUpperCase() + "_QUANTITY"), 2, this.FAC_PS);
        Taems buildstuff = this.ppTaemsReader.makeTaemsStructure(ht);
        ProductionContractor pc = new ProductionContractor(buildstuff, this, this);
        this.prereqs = pc.startNegotiation();
    }

    public boolean hasClickAction() {
        return true;
    }

    public void processMouseEvent(MouseEvent e) {
        if (e.getID() == 501) {
            Enumeration<Object> structs = null;
            Object t = this.state.getProperty((Object)SimpleTaemsReader.SUBTAEMS);
            if (t == null) {
                this.log.log("Sorry, no subjective view found for resource detection", 1, this.FAC_PS);
                return;
            }
            if (t instanceof Hashtable) {
                structs = ((Hashtable)t).elements();
            } else if (t instanceof Taems) {
                Vector<Object> v = new Vector<Object>(1);
                v.addElement(t);
                structs = v.elements();
            } else {
                this.log.log("Whoops, some wierd thing is where the subjective view should be in state", 0, this.FAC_PS);
                return;
            }
            Vector<String> options = new Vector<String>();
            while (structs.hasMoreElements()) {
                Taems taems = (Taems)structs.nextElement();
                Enumeration en = taems.getNodes();
                while (en.hasMoreElements()) {
                    Node n = (Node)en.nextElement();
                    if (!(n instanceof Resource)) continue;
                    Enumeration oe = options.elements();
                    while (oe.hasMoreElements()) {
                        if (!((String)oe.nextElement()).equals(n.getLabel())) continue;
                        n = null;
                        break;
                    }
                    if (n == null) continue;
                    options.addElement(n.getLabel());
                }
            }
            if (options.size() <= 0) {
                this.log.log("Sorry, I didn't find any resources in your subjective view, so I can't make a production commitment", 1, this.FAC_PS);
                return;
            }
            Object[] aoptions = new Object[options.size()];
            options.copyInto(aoptions);
            String rsrc = (String)JOptionPane.showInputDialog(null, "Choose a resource to produce:", "Pick a resource", 3, null, aoptions, aoptions[0]);
            if (rsrc == null) {
                return;
            }
            String quantity = JOptionPane.showInputDialog(null, "How much " + rsrc.toString() + " should it produce?", "What quantity?", 3);
            if (quantity == null) {
                return;
            }
            this.log.log("Attempting to add commitment for " + quantity + " units of " + rsrc, 2, this.FAC_PS);
            try {
                this.generateProductionCommitment(rsrc, Float.valueOf(quantity).floatValue());
            }
            catch (Exception ex) {
                this.log.log("adding commitment: " + ex, 0, this.FAC_PS);
            }
        }
    }

    public void mouseClicked(MouseEvent e) {
        this.processMouseEvent(e);
    }

    public void mousePressed(MouseEvent e) {
        this.processMouseEvent(e);
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }
}

