/*
 * Decompiled with CFR 0.152.
 */
package agent.partialorder;

import agent.diagnose.model.ResourceModel;
import agent.diagnose.model.ResourceModeler;
import agent.diagnose.model.ResourceUsage;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import taems.MLCSchedule;
import taems.Precondition;
import taems.ScheduleElement;
import taems.VirtualScheduleElement;

public class ResourcePrecondition
extends Precondition
implements Serializable,
Cloneable {
    protected Vector usages;
    protected ResourceModeler modeler;
    protected static final float THRESHOLD = 0.75f;
    protected ScheduleElement origine;

    public ResourcePrecondition(MLCSchedule p, Vector v, ResourceModeler r, ScheduleElement orig) {
        this.setParentMLC(p);
        this.modeler = r;
        this.usages = v;
        this.origine = orig;
    }

    public boolean check(int time) {
        boolean answer = true;
        if (this.origine.isResourceBind()) {
            Enumeration e = this.usages.elements();
            while (e.hasMoreElements() && answer) {
                ResourceUsage usage = (ResourceUsage)e.nextElement();
                if (usage.getStart().calculateMax() + usage.getDuration().calculateMax() < (float)time) {
                    return true;
                }
                ResourceModel m = this.modeler.getModel(usage.getResource());
                if (m.checkUsage(usage) > 0.75f) {
                    answer &= true;
                    continue;
                }
                answer &= false;
            }
        }
        return answer;
    }

    public void completed(int time) {
        Enumeration e = this.usages.elements();
        while (e.hasMoreElements()) {
            this.modeler.removeUsage((ResourceUsage)e.nextElement());
        }
        this.usages = new Vector();
    }

    public void attach() {
        Enumeration e = this.usages.elements();
        while (e.hasMoreElements()) {
            this.modeler.addUsage((ResourceUsage)e.nextElement());
        }
        System.err.println(this.origine);
        this.origine.setResourceBind(true);
    }

    public void clear() {
        Enumeration e = this.usages.elements();
        while (e.hasMoreElements()) {
            this.modeler.removeUsage((ResourceUsage)e.nextElement());
        }
        this.origine.setResourceBind(false);
    }

    public boolean dependentOf(ScheduleElement s) {
        return false;
    }

    public Vector getUsages() {
        return this.usages;
    }

    public void setUsages(Vector v) {
        this.usages = v;
    }

    public String output() {
        StringBuffer sb = new StringBuffer();
        sb.append("Check : ResourceUsages \n");
        Enumeration e = this.usages.elements();
        while (e.hasMoreElements()) {
            sb.append("\t[" + ((ResourceUsage)e.nextElement()).toString() + "]\n");
        }
        return sb.toString();
    }

    public Object clone() {
        Vector<Object> v = new Vector<Object>();
        Enumeration e = this.usages.elements();
        while (e.hasMoreElements()) {
            v.addElement(((ResourceUsage)e.nextElement()).clone());
        }
        ResourcePrecondition cloned = new ResourcePrecondition(null, v, this.modeler, (ScheduleElement)new VirtualScheduleElement(this.origine.getID()));
        cloned.setOptional(this.isOptional());
        return cloned;
    }

    public void retargetVirtual(MLCSchedule s, Vector clonedSE) {
        super.retargetVirtual(s, clonedSE);
        if (this.origine != null && this.origine instanceof VirtualScheduleElement) {
            Enumeration e = clonedSE.elements();
            while (e.hasMoreElements()) {
                ScheduleElement se = (ScheduleElement)e.nextElement();
                if (!this.origine.matches(se)) continue;
                this.origine = se;
            }
        }
    }

    public String toTTaems(float v) {
        StringBuffer sb = new StringBuffer(";          (spec_resource_precondition\n");
        Enumeration e = this.getUsages().elements();
        while (e.hasMoreElements()) {
            ResourceUsage usage = (ResourceUsage)e.nextElement();
            sb.append(";              (usage " + usage + ")\n");
        }
        sb.append(";           )\n");
        return sb.toString();
    }
}

