/*
 * Decompiled with CFR 0.152.
 */
package agent.partialorder;

import agent.base.AgentComponent;
import agent.base.AgentEvent;
import agent.diagnose.model.ResourceContext;
import agent.diagnose.model.ResourceModel;
import agent.diagnose.model.ResourceModeler;
import agent.diagnose.model.ResourceUsage;
import agent.mass.ScheduleErrorException;
import agent.mass.ScheduleEvent;
import agent.mass.Scheduler;
import agent.mass.SimpleTaemsReader;
import agent.partialorder.ResourceBindingsException;
import agent.partialorder.ResourcePrecondition;
import agent.simplest.Communicate;
import agent.simplest.Control;
import agent.simplest.DependencyFailedException;
import agent.simplest.Observe;
import agent.simplest.Observer;
import agent.simplest.PropertyEvent;
import agent.simplest.Sensor;
import agent.simplest.State;
import agent.simplest.WindowManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JFrame;
import taems.ConsumesInterrelationship;
import taems.Criteria;
import taems.FacilitatesInterrelationship;
import taems.Interrelationship;
import taems.MLCSchedule;
import taems.Method;
import taems.Node;
import taems.PrecedencePrecondition;
import taems.Precondition;
import taems.ProducesInterrelationship;
import taems.Resource;
import taems.Schedule;
import taems.ScheduleElement;
import taems.Taems;
import taems.Task;
import taems.VirtualMethod;
import taems.parser.ReadTTaems;
import taems.preprocessor.ParseException;
import taems.preprocessor.PreProcessor;
import taems.preprocessor.PreProcessorParser;
import utilities.Distribution;
import utilities.Log;

public class PartialOrderScheduler
extends Scheduler {
    protected ResourceModeler modeler;
    protected agent.simplest.Log log;
    protected static int FAC_POS;
    private Hashtable recursion = new Hashtable();
    private final int MAXRECURSION = 30;
    protected boolean autobinding;
    protected float compact = 0.5f;
    protected Observer POSrescheduling;
    protected Hashtable parallelhints = new Hashtable();
    protected boolean usehints;
    private static final int INITIAL_WIDTH = 500;
    private static final int INITIAL_HEIGHT = 400;

    public PartialOrderScheduler() {
        this.addDependency("ResourceModeler");
        State.addParameterInfo((String)"AutoBindingResources", (String)"Boolean", (String)"If true, automaticaly bind the resource with the schedule", (Object)Boolean.TRUE);
        State.addParameterInfo((String)"CompactingRate", (String)"Float", (String)"Set the compacting arate for the scheduler", (Object)new Float(0.5));
        State.addParameterInfo((String)"UseParallelHints", (String)"Boolean", (String)"If true, adds structural hints describing potential parallellism before scheduling Taems structures", (Object)Boolean.FALSE);
        State.addParameterInfo((String)"ParallelHintCache", (String)"String", (String)"Pathname of the file containing learned paralallel hints");
    }

    public void init() {
        super.init();
        this.log = (agent.simplest.Log)State.findComponent((String)"Log");
        FAC_POS = this.log.getFacilityID((AgentComponent)this);
        this.modeler = (ResourceModeler)State.findComponent((String)"ResourceModeler");
        this.state.setProperty((Object)"AutoModel", (Object)new Boolean(false));
        if (State.hasComponent((String)"Observe")) {
            Observe observe = (Observe)State.findComponent((String)"Observe");
            this.POSrescheduling = new Observer("POS Reschedule"){

                public boolean checkEvent(AgentEvent e) {
                    return false;
                }
            };
            observe.addObserver(this.POSrescheduling);
        }
        if (this.usehints) {
            this.readParallelHints();
        }
    }

    public void reset() {
        super.init();
    }

    public void end() {
        if (this.usehints) {
            this.writeParallelHints();
        }
        super.end();
    }

    public Vector addPrecondition(ScheduleElement se, Precondition p) {
        this.log.log("Warning addPrecondition is not implemented!", 0, FAC_POS);
        return new Vector();
    }

    public synchronized Vector evaluateTaems(Hashtable taems, MLCSchedule mlcs) throws ScheduleErrorException, ResourceBindingsException {
        return this.scheduleTaems(taems, mlcs, false, true, false);
    }

    public synchronized Vector scheduleTaems(Hashtable taems, MLCSchedule mlcs, boolean set) throws ScheduleErrorException, ResourceBindingsException {
        return this.scheduleTaems(taems, mlcs, set, false, false);
    }

    public synchronized Vector scheduleTaems(Hashtable taems, MLCSchedule mlcs, boolean set, boolean evaluation, boolean rescheduling) throws ScheduleErrorException, ResourceBindingsException {
        this.log.log("POS Schedule taems start", 5, FAC_POS);
        Vector schedules = new Vector();
        if (mlcs == null) {
            mlcs = new MLCSchedule();
        }
        this.log.log("MLCS = " + mlcs, 5, FAC_POS);
        Enumeration e = taems.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            Taems t = (Taems)taems.get(key);
            if (t.numSchedules() == 0) {
                Vector v;
                if (evaluation) {
                    if (this.usehints) {
                        Vector h = this.addParallelHints(t);
                        v = super.evaluateTaems(t, rescheduling);
                        this.removeParallelHints(t, h);
                    } else {
                        v = super.evaluateTaems(t, rescheduling);
                    }
                } else {
                    v = super.scheduleTaems(t, rescheduling, set);
                }
                if (v == null || v.size() == 0) {
                    this.log.log("Error: No schedules returned for task structure " + t.getLabel() + " (evaluate is " + evaluation + ")", 0, FAC_POS);
                    continue;
                }
                t.setScheduleVector(v);
                schedules.addElement(v.firstElement());
                continue;
            }
            schedules.addElement(t.getScheduleVector().firstElement());
        }
        TreeSet contexts = this.extractCurrentContext(null);
        Enumeration e2 = mlcs.getSchedules();
        while (e2.hasMoreElements()) {
            Schedule s1 = (Schedule)e2.nextElement();
            if (schedules.contains(s1)) continue;
            this.log.log("Removing this schedule : " + s1.stringify(), 3, FAC_POS);
            if (s1.isStarted() && !s1.isCompleted()) {
                this.log.log("Removing schedule that has not completed: started = " + s1.isStarted() + " Completed= " + s1.isCompleted(), 1, FAC_POS);
                new Exception().printStackTrace();
                continue;
            }
            this.deleteResourceUsages(s1.getScheduleElements(), false);
            mlcs.removeSchedule(s1);
            if (this.POSrescheduling == null) continue;
            this.POSrescheduling.updateCount(1.0);
        }
        Enumeration e3 = schedules.elements();
        while (e3.hasMoreElements()) {
            Schedule s1 = (Schedule)e3.nextElement();
            if (mlcs.contains(s1)) continue;
            mlcs.addSchedule(s1, (Integer)this.state.getProperty((Object)"Time") + 1, this.compact);
        }
        if (this.autobinding) {
            mlcs = this.bindResources(mlcs, set);
            mlcs.deleteHistory();
            Vector v = this.verifyResourcesUsages(mlcs);
            if (v != null) {
                this.log.log("----> Error in verifyResourcesUsages\nMLCS = " + mlcs, 3, FAC_POS);
                this.deleteResourceUsages(v, true);
                boolean sliding = false;
                Enumeration e4 = v.elements();
                while (e4.hasMoreElements()) {
                    ScheduleElement se1 = (ScheduleElement)e4.nextElement();
                    this.log.log("\tError with " + se1.stringify(), 3, FAC_POS);
                    sliding = this.rebindResources(mlcs, se1, true, sliding);
                }
                this.log.log("MLCS = " + mlcs, 3, FAC_POS);
            }
            if ((v = this.checkConflicts(mlcs)) != null) {
                this.log.log("We are going to be late (MAYBE you should check it)", 1, FAC_POS);
                ScheduleErrorException except = new ScheduleErrorException("Constraints Unsatisfied", v);
                this.startFireEvent((AgentEvent)new ScheduleEvent((Object)this, (Schedule)mlcs, null, (Exception)except, 1));
            }
        }
        if (this.usehints) {
            Enumeration te = taems.elements();
            while (te.hasMoreElements()) {
                Taems t = (Taems)te.nextElement();
                if (t.getAttribute((Object)"ParallelsExtracted") != null) continue;
                t.setAttribute((Object)"ParallelsExtracted", (Object)Boolean.TRUE);
                Vector v = this.extractParallelHints(t);
                TreeSet<ResourceContext> c = new TreeSet<ResourceContext>();
                Enumeration re = t.findNodes((Node)new Resource());
                block5: while (re.hasMoreElements()) {
                    Resource r = (Resource)re.nextElement();
                    Iterator ci = contexts.iterator();
                    while (ci.hasNext()) {
                        ResourceContext con = (ResourceContext)ci.next();
                        if (!con.getResource().equals(r.getLabel())) continue;
                        if (c.contains(con)) continue block5;
                        c.add(con);
                        continue block5;
                    }
                }
                this.log.log("Adding " + v.size() + " hints for context of size " + c.size() + " for task structure " + t.getLabel(), 3, FAC_POS);
                this.setParallelHints(this.generateCacheKey(t), c, v);
            }
        }
        this.log.log("MLCS = " + mlcs.toString(), 5, FAC_POS);
        this.log.log("POS Schedule taems end", 5, FAC_POS);
        Vector<MLCSchedule> v1 = new Vector<MLCSchedule>();
        v1.addElement(mlcs);
        if (set) {
            this.state.setProperty((Object)"Schedule", (Object)mlcs, (Object)"new one");
        }
        return v1;
    }

    public synchronized Vector scheduleTaems(Taems t, boolean rescheduling, boolean set) {
        Vector v = null;
        if (this.usehints) {
            Vector h = this.addParallelHints(t);
            v = super.scheduleTaems(t, rescheduling, set);
            this.removeParallelHints(t, h);
        } else {
            v = super.scheduleTaems(t, rescheduling, set);
        }
        return v;
    }

    protected synchronized MLCSchedule bindResources(MLCSchedule mlcs, boolean set) throws ResourceBindingsException {
        Vector<ResourceUsage> totalusages = new Vector<ResourceUsage>();
        Enumeration eschedule = mlcs.getSchedules();
        while (eschedule.hasMoreElements()) {
            Schedule partial = (Schedule)eschedule.nextElement();
            Enumeration e = partial.getElements();
            while (e.hasMoreElements()) {
                ScheduleElement se = (ScheduleElement)e.nextElement();
                if (se.hasStarted() || se.isResourceBind()) continue;
                Vector<ResourceUsage> usages = new Vector<ResourceUsage>();
                Method m = se.getMethod();
                Enumeration e2 = m.getAffectedInterrelationships();
                while (e2.hasMoreElements()) {
                    Interrelationship ir = (Interrelationship)e2.nextElement();
                    if (ir instanceof ConsumesInterrelationship) {
                        ConsumesInterrelationship cir = (ConsumesInterrelationship)ir;
                        usages.insertElementAt(new ResourceUsage(cir.getLabel(), cir.getTo().getLabel(), true, cir.getModel(), se.getStartTime(), se.getDurationDistribution(), cir.getConsumes()), 0);
                    }
                    if (!(ir instanceof ProducesInterrelationship)) continue;
                    ProducesInterrelationship pir = (ProducesInterrelationship)ir;
                    usages.addElement(new ResourceUsage(pir.getLabel(), pir.getTo().getLabel(), false, pir.getModel(), se.getStartTime(), se.getDurationDistribution(), pir.getProduces()));
                }
                if (usages.size() != 0) {
                    Enumeration e3;
                    int maxtime;
                    int time = se.getStart();
                    int est = this.modeler.findAvailability(time, maxtime = time + mlcs.getMaxFinishTime() + 10000, usages, 0.9f);
                    if (est == -1) {
                        this.log.log("Can't find space for " + se.getLabel() + " (max finish time = " + maxtime + ")", 1, FAC_POS);
                        se.setResourceBind(false);
                        se.addPrecondition((Precondition)new ResourcePrecondition(mlcs, new Vector(), this.modeler, se));
                        ResourceBindingsException except = new ResourceBindingsException("Can't find space for " + se.getLabel(), usages);
                        this.startFireEvent((AgentEvent)new ScheduleEvent((Object)this, (Schedule)mlcs, null, (Exception)except, 1));
                        throw except;
                    }
                    this.log.log("It's possible to " + se.getLabel() + " at time " + est, 3, FAC_POS);
                    Vector<ResourceUsage> newusages = new Vector<ResourceUsage>();
                    if (!se.getStartTime().equals(new Distribution((float)est, 1.0f))) {
                        e3 = usages.elements();
                        while (e3.hasMoreElements()) {
                            ResourceUsage ru;
                            ResourceUsage ru1 = ru = (ResourceUsage)e3.nextElement();
                            ru1 = new ResourceUsage(ru.getLabel(), ru.getResource(), ru.isConsume(), ru.getType(), new Distribution((float)est, 1.0f), ru.getDuration(), ru.getUsage());
                            this.modeler.addUsage(ru1);
                            newusages.addElement(ru1);
                            totalusages.addElement(ru1);
                        }
                        if (set) {
                            int offset = est - se.getStart();
                            mlcs.delayStartTime(se, offset);
                        }
                    } else {
                        e3 = usages.elements();
                        while (e3.hasMoreElements()) {
                            ResourceUsage ru1 = (ResourceUsage)e3.nextElement();
                            this.modeler.addUsage(ru1);
                            newusages.addElement(ru1);
                            totalusages.addElement(ru1);
                        }
                    }
                    usages = newusages;
                    if (set) {
                        se.setResourceBind(true);
                        se.addPrecondition((Precondition)new ResourcePrecondition(mlcs, usages, this.modeler, se));
                        continue;
                    }
                    se.setResourceBind(false);
                    se.addPrecondition((Precondition)new ResourcePrecondition(mlcs, new Vector(), this.modeler, se));
                    continue;
                }
                se.setResourceBind(true);
            }
        }
        if (!set) {
            Enumeration e = totalusages.elements();
            while (e.hasMoreElements()) {
                ResourceUsage ru = (ResourceUsage)e.nextElement();
                this.modeler.removeUsage(ru);
            }
        }
        return mlcs;
    }

    public void propertyChanged(PropertyEvent e) {
        String key = e.getKey().toString();
        if (key.equals("SchedulerCriteria")) {
            Vector v = (Vector)this.state.getProperty((Object)"SchedulerCriteria");
            this.setCriteria((Criteria)v);
        } else if (key.equals("Schedule")) {
            Schedule s = (Schedule)e.getProperty();
            Object t = this.state.getProperty((Object)SimpleTaemsReader.CONTAEMS);
            if (t instanceof Hashtable) {
                Enumeration en = ((Hashtable)t).elements();
                while (en.hasMoreElements()) {
                    t = en.nextElement();
                    ((Taems)t).setDisplayedSchedule(s);
                }
            } else if (t instanceof Taems) {
                ((Taems)t).setDisplayedSchedule(s);
            }
        } else if (key.equals(SimpleTaemsReader.CONTAEMS)) {
            if (this.autoschedule) {
                Hashtable<String, Taems> h;
                if (e.getProperty() instanceof Taems) {
                    Taems t = (Taems)e.getProperty();
                    h = new Hashtable<String, Taems>();
                    h.put(t.getLabel(), t);
                } else {
                    h = (Hashtable<String, Taems>)e.getProperty();
                }
                boolean reschedule = false;
                if (e.getHint() != null && ((String)e.getHint()).equalsIgnoreCase("Rescheduling")) {
                    reschedule = true;
                }
                MLCSchedule mlcs = this.state.hasProperty((Object)"Schedule") && this.state.getProperty((Object)"Schedule") instanceof MLCSchedule ? (MLCSchedule)this.state.getProperty((Object)"Schedule") : null;
                try {
                    mlcs = (MLCSchedule)this.scheduleTaems(h, mlcs, true, true, reschedule).firstElement();
                }
                catch (ScheduleErrorException ex) {
                    this.log.log("Error " + (Object)((Object)ex), 0, FAC_POS);
                    ex.printStackTrace();
                }
                catch (ResourceBindingsException ex) {
                    this.log.log("Error " + ex, 0, FAC_POS);
                    ex.printStackTrace();
                }
            }
        } else if (key.equals("AutoBindingResources")) {
            this.autobinding = (Boolean)e.getProperty();
        } else if (key.equals("CompactingRate")) {
            this.compact = ((Float)e.getProperty()).floatValue();
        } else if (key.equals("UseParallelHints")) {
            this.usehints = (Boolean)e.getProperty();
        } else {
            super.propertyChanged(e);
        }
    }

    public synchronized Vector checkConflicts(MLCSchedule mlcs) {
        this.log.log("checkConflicts !! ", 3, FAC_POS);
        Vector<ScheduleElement> v = new Vector<ScheduleElement>();
        Enumeration e = mlcs.getElements();
        while (e.hasMoreElements()) {
            ScheduleElement se = (ScheduleElement)e.nextElement();
            if (se.hasFinished()) continue;
            Method me = se.getMethod();
            if (se.getFinish() <= me.getActualLatestFinishTime()) continue;
            this.log.log("This method will be late : " + me.getLabel() + " DEADLINE = " + me.getActualLatestFinishTime() + " Expected finish time = " + se.getFinish(), 2, FAC_POS);
            v.addElement(se);
        }
        if (v.size() != 0) {
            return v;
        }
        return null;
    }

    protected synchronized void deleteResourceUsages(Vector v, boolean backup) {
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            ScheduleElement se = (ScheduleElement)e.nextElement();
            Enumeration enumeration = se.getPreconditions().elements();
            while (enumeration.hasMoreElements()) {
                Precondition pre = (Precondition)enumeration.nextElement();
                if (!(pre instanceof ResourcePrecondition)) continue;
                Vector vru = ((ResourcePrecondition)pre).getUsages();
                if (backup) {
                    se.setAttribute((Object)"Usages", (Object)vru);
                }
                if (!se.isResourceBind()) continue;
                Enumeration e2 = vru.elements();
                while (e2.hasMoreElements()) {
                    this.modeler.removeUsage((ResourceUsage)e2.nextElement());
                }
                ((ResourcePrecondition)pre).setUsages(new Vector());
            }
        }
    }

    protected synchronized void undeleteResourceUsages(Vector v) {
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            ScheduleElement se = (ScheduleElement)e.nextElement();
            Enumeration enumeration = se.getPreconditions().elements();
            while (enumeration.hasMoreElements()) {
                Precondition pre = (Precondition)enumeration.nextElement();
                if (!(pre instanceof ResourcePrecondition) || !se.hasAttribute((Object)"Usages")) continue;
                Vector vru = (Vector)se.getAttribute((Object)"Usages");
                if (se.isResourceBind()) {
                    Enumeration e2 = vru.elements();
                    while (e2.hasMoreElements()) {
                        this.modeler.addUsage((ResourceUsage)e2.nextElement());
                    }
                }
                ((ResourcePrecondition)pre).setUsages(vru);
                se.removeAttribute((Object)"Usages");
            }
        }
    }

    protected synchronized void cleanResourceUsages(Vector v) {
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            ScheduleElement se = (ScheduleElement)e.nextElement();
            Enumeration enumeration = se.getPreconditions().elements();
            while (enumeration.hasMoreElements()) {
                Precondition pre = (Precondition)enumeration.nextElement();
                if (!(pre instanceof ResourcePrecondition) || !se.hasAttribute((Object)"Usages")) continue;
                se.removeAttribute((Object)"Usages");
            }
        }
    }

    protected synchronized void delayResourceFinishTime(ScheduleElement se) {
        Enumeration enumeration = se.getPreconditions().elements();
        while (enumeration.hasMoreElements()) {
            Precondition pre = (Precondition)enumeration.nextElement();
            if (!(pre instanceof ResourcePrecondition)) continue;
            Vector vru = ((ResourcePrecondition)pre).getUsages();
            Vector<ResourceUsage> newvru = new Vector<ResourceUsage>();
            Vector newusages = vru;
            if (vru.size() == 0 || !se.isResourceBind()) continue;
            Enumeration e = vru.elements();
            while (e.hasMoreElements()) {
                ResourceUsage ru = (ResourceUsage)e.nextElement();
                ResourceUsage ru1 = new ResourceUsage(ru.getLabel(), ru.getResource(), ru.isConsume(), ru.getType(), ru.getStart(), se.getDurationDistribution(), ru.getUsage());
                this.modeler.removeUsage(ru);
                this.modeler.addUsage(ru1);
                newvru.addElement(ru1);
            }
            ((ResourcePrecondition)pre).setUsages(newvru);
        }
    }

    protected synchronized boolean rebindResources(MLCSchedule mlcs, ScheduleElement se, boolean set, boolean slidingTechnic) throws ResourceBindingsException {
        Vector<ResourceUsage> totalusages = new Vector<ResourceUsage>();
        Enumeration enumeration = se.getPreconditions().elements();
        while (enumeration.hasMoreElements()) {
            Enumeration e3;
            Precondition pre = (Precondition)enumeration.nextElement();
            if (!(pre instanceof ResourcePrecondition)) continue;
            Vector<ResourceUsage> vru = ((ResourcePrecondition)pre).getUsages();
            Vector<ResourceUsage> newvru = new Vector<ResourceUsage>();
            Vector<ResourceUsage> newusages = vru;
            if (vru.size() != 0 && se.isResourceBind()) {
                Enumeration e = vru.elements();
                while (e.hasMoreElements()) {
                    ResourceUsage ru = (ResourceUsage)e.nextElement();
                    ResourceUsage ru1 = new ResourceUsage(ru.getLabel(), ru.getResource(), ru.isConsume(), ru.getType(), se.getStartTime(), ru.getDuration(), ru.getUsage());
                    newvru.addElement(ru1);
                }
            } else {
                Method m = se.getMethod();
                Enumeration e2 = m.getAffectedInterrelationships();
                while (e2.hasMoreElements()) {
                    Interrelationship ir = (Interrelationship)e2.nextElement();
                    if (ir instanceof ConsumesInterrelationship) {
                        ConsumesInterrelationship cir = (ConsumesInterrelationship)ir;
                        newvru.insertElementAt(new ResourceUsage(cir.getLabel(), cir.getTo().getLabel(), true, cir.getModel(), se.getStartTime(), se.getDurationDistribution(), cir.getConsumes()), 0);
                    }
                    if (!(ir instanceof ProducesInterrelationship)) continue;
                    ProducesInterrelationship pir = (ProducesInterrelationship)ir;
                    newvru.addElement(new ResourceUsage(pir.getLabel(), pir.getTo().getLabel(), false, pir.getModel(), se.getStartTime(), se.getDurationDistribution(), pir.getProduces()));
                }
            }
            int maxtime = (Integer)this.state.getProperty((Object)"Time") + mlcs.getMaxFinishTime() + 10000;
            if (slidingTechnic) {
                newusages = new Vector<ResourceUsage>();
                Enumeration e32 = newvru.elements();
                while (e32.hasMoreElements()) {
                    ResourceUsage ru = (ResourceUsage)e32.nextElement();
                    this.modeler.addUsage(ru);
                    if (this.modeler.checkUsage(ru) >= 0.9f) {
                        newusages.addElement(ru);
                        totalusages.addElement(ru);
                        continue;
                    }
                    slidingTechnic = false;
                    this.modeler.removeUsage(ru);
                    break;
                }
                if (!slidingTechnic) {
                    Enumeration e33 = newusages.elements();
                    while (e33.hasMoreElements()) {
                        ResourceUsage ru = (ResourceUsage)e33.nextElement();
                        this.modeler.removeUsage(ru);
                        totalusages.removeElement(ru);
                    }
                } else {
                    ((ResourcePrecondition)pre).setUsages(newusages);
                }
            }
            if (slidingTechnic || newvru.size() == 0) continue;
            int est = this.modeler.findAvailability(se.getStart(), se.getStart() + maxtime, newvru, 0.9f);
            if (est == -1) {
                this.log.log("Can't find space for " + se.getLabel() + " (max finish time = " + maxtime + ")", 1, FAC_POS);
                ResourceBindingsException except = new ResourceBindingsException("Can't find space for " + se.getLabel(), newvru);
                this.startFireEvent((AgentEvent)new ScheduleEvent((Object)this, (Schedule)mlcs, null, (Exception)except, 1));
                throw except;
            }
            this.log.log("It's possible to " + se.getLabel() + " at time " + est, 3, FAC_POS);
            Vector<ResourceUsage> usages = newvru;
            newusages = new Vector();
            if (!se.getStartTime().equals(new Distribution((float)est, 1.0f))) {
                e3 = newvru.elements();
                while (e3.hasMoreElements()) {
                    ResourceUsage ru;
                    ResourceUsage ru1 = ru = (ResourceUsage)e3.nextElement();
                    ru1 = new ResourceUsage(ru.getLabel(), ru.getResource(), ru.isConsume(), ru.getType(), new Distribution((float)est, 1.0f), ru.getDuration(), ru.getUsage());
                    this.modeler.addUsage(ru1);
                    newusages.addElement(ru1);
                    totalusages.addElement(ru1);
                }
                if (set) {
                    int offset = est - se.getStart();
                    mlcs.delayStartTime(se, offset);
                }
            } else {
                e3 = newvru.elements();
                while (e3.hasMoreElements()) {
                    ResourceUsage ru1 = (ResourceUsage)e3.nextElement();
                    this.modeler.addUsage(ru1);
                    newusages.addElement(ru1);
                    totalusages.addElement(ru1);
                }
            }
            slidingTechnic = true;
            ((ResourcePrecondition)pre).setUsages(newusages);
        }
        if (!set) {
            Enumeration e = totalusages.elements();
            while (e.hasMoreElements()) {
                ResourceUsage ru = (ResourceUsage)e.nextElement();
                this.modeler.removeUsage(ru);
            }
        }
        return slidingTechnic;
    }

    public void doAllPrinting(String ressource) {
        ResourceModel model = this.modeler.getModel(ressource);
        TreeSet sorted = new TreeSet();
        Iterator i = model.getExpectationTimes();
        while (i.hasNext()) {
            sorted.add(i.next());
        }
        i = sorted.iterator();
        while (i.hasNext()) {
            Integer slot = (Integer)i.next();
            System.err.println("Time " + slot + ": " + model.getExpectations(slot) + " (consumes " + model.getConsumesExpectations(slot) + ")");
        }
    }

    protected synchronized Vector verifyResourcesUsages(MLCSchedule mlcs) {
        Enumeration e = mlcs.getElements();
        Vector<ScheduleElement> v = new Vector<ScheduleElement>();
        block0: while (e.hasMoreElements()) {
            ScheduleElement se = (ScheduleElement)e.nextElement();
            if (se.hasStarted()) continue;
            Enumeration enumeration = se.getPreconditions().elements();
            while (enumeration.hasMoreElements()) {
                Precondition pre = (Precondition)enumeration.nextElement();
                if (!(pre instanceof ResourcePrecondition) || pre.check(se.getStart())) continue;
                v.addElement(se);
                continue block0;
            }
        }
        if (v.size() != 0) {
            return v;
        }
        return null;
    }

    public synchronized Schedule delayFinishTime(Schedule s, ScheduleElement se, int offset) throws ScheduleErrorException {
        Schedule r = null;
        if (s instanceof MLCSchedule) {
            try {
                r = this.delayFinishTime((MLCSchedule)s, se, offset);
            }
            catch (ResourceBindingsException rex) {
                this.log.log("Sorry, resource problem allocation ", 0, FAC_POS);
                this.log.log("ERROR OLD schedule :\n " + ((MLCSchedule)s).stringifyMLC(), 0, FAC_POS);
                throw new ScheduleErrorException("Resource Bindings", rex.getUsages());
            }
        } else {
            r = super.delayFinishTime(s, se, offset);
        }
        return r;
    }

    protected String generateKey(Vector v) {
        Vector<String> strV = new Vector<String>();
        String key = "";
        if (v.size() > 0) {
            key = ((ScheduleElement)v.elementAt(0)).getLabel();
        }
        int i = 1;
        while (i < v.size()) {
            ScheduleElement se = (ScheduleElement)v.elementAt(i);
            strV.addElement(se.getLabel());
            ++i;
        }
        Collections.sort(strV);
        Enumeration e = strV.elements();
        while (e.hasMoreElements()) {
            String k = (String)e.nextElement();
            key = key + k;
        }
        return key;
    }

    public synchronized void updateResourceModeler(ScheduleElement se, int offset) {
        if (this.autobinding) {
            Enumeration enumeration = se.getPreconditions().elements();
            while (enumeration.hasMoreElements()) {
                Precondition pre = (Precondition)enumeration.nextElement();
                if (!(pre instanceof ResourcePrecondition)) continue;
                Vector vru = ((ResourcePrecondition)pre).getUsages();
                Vector<ResourceUsage> newvru = new Vector<ResourceUsage>();
                Vector newusages = vru;
                if (vru.size() == 0 || !se.isResourceBind()) continue;
                Enumeration e = vru.elements();
                while (e.hasMoreElements()) {
                    ResourceUsage ru = (ResourceUsage)e.nextElement();
                    ResourceUsage ru1 = new ResourceUsage(ru.getLabel(), ru.getResource(), ru.isConsume(), ru.getType(), ru.getStart(), ru.getDuration().applyOffset((float)offset), ru.getUsage());
                    this.modeler.removeUsage(ru);
                    this.modeler.addUsage(ru1);
                    newvru.addElement(ru1);
                }
                ((ResourcePrecondition)pre).setUsages(newvru);
            }
        }
    }

    public synchronized MLCSchedule delayFinishTime(MLCSchedule mlcs, ScheduleElement se, int offset) throws ResourceBindingsException {
        Vector v;
        String key;
        this.log.log("POS delayFinishTime start\n" + mlcs, 5, FAC_POS);
        if (this.POSrescheduling != null) {
            this.POSrescheduling.updateCount(1.0);
        }
        int recursionDepth = this.recursion.containsKey(key = this.generateKey(v = mlcs.delayFinishTime(se, offset))) ? (Integer)this.recursion.get(key) + 1 : 1;
        this.recursion.put(key, new Integer(recursionDepth));
        if (this.autobinding) {
            this.delayResourceFinishTime(se);
            v.removeElement(se);
            this.deleteResourceUsages(v, true);
            try {
                boolean sliding = false;
                Enumeration e = v.elements();
                while (e.hasMoreElements()) {
                    ScheduleElement s = (ScheduleElement)e.nextElement();
                    sliding = this.rebindResources(mlcs, s, true, sliding);
                    if ((Integer)this.recursion.get(key) <= 30) continue;
                    this.log.log("Recursive loop is to deep, I'm stoppping the sliding mechanism", 2, FAC_POS);
                    sliding = false;
                }
                if ((Integer)this.recursion.get(key) < 30) {
                    Vector problems = this.verifyResourcesUsages(mlcs);
                    if (problems != null) {
                        this.deleteResourceUsages(v, false);
                        this.undeleteResourceUsages(v);
                        mlcs.undeleteTiming(v);
                        e = problems.elements();
                        while (e.hasMoreElements()) {
                            ScheduleElement se1 = (ScheduleElement)e.nextElement();
                            PrecedencePrecondition precedence = new PrecedencePrecondition(mlcs, se, null);
                            precedence.setOptional(true);
                            se1.addPrecondition((Precondition)precedence);
                        }
                        this.delayFinishTime(mlcs, se, offset);
                    }
                } else {
                    this.log.log("Recursion is too deep, stopping here (" + recursionDepth + ")", 1, FAC_POS);
                }
                this.cleanResourceUsages(v);
                mlcs.deleteHistory(v);
            }
            catch (ResourceBindingsException res) {
                this.deleteResourceUsages(v, false);
                this.undeleteResourceUsages(v);
                mlcs.undeleteTiming(v);
                recursionDepth = (Integer)this.recursion.get(key);
                if (recursionDepth < 1) {
                    this.log.log("Error in  the recursion count (" + (recursionDepth - 1) + ")", 0, FAC_POS);
                    recursionDepth = 1;
                }
                if (--recursionDepth <= 0) {
                    this.recursion.remove(key);
                } else {
                    this.recursion.put(key, new Integer(recursionDepth));
                }
                throw res;
            }
        }
        if ((recursionDepth = ((Integer)this.recursion.get(key)).intValue()) < 1) {
            this.log.log("Error in  the recursion count (" + (recursionDepth - 1) + ")", 0, FAC_POS);
            recursionDepth = 1;
        }
        if (--recursionDepth <= 0) {
            this.recursion.remove(key);
        } else {
            this.recursion.put(key, new Integer(recursionDepth));
        }
        this.log.log("POS delayFinishTime end", 5, FAC_POS);
        return mlcs;
    }

    public synchronized Schedule delayStartTime(Schedule s, ScheduleElement se, int offset) throws ScheduleErrorException {
        Schedule r = null;
        if (s instanceof MLCSchedule) {
            try {
                r = this.delayStartTime((MLCSchedule)s, se, offset);
            }
            catch (ResourceBindingsException rex) {
                this.log.log("Sorry, resource problem allocation ", 0, FAC_POS);
                this.log.log("ERROR OLD schedule :\n " + ((MLCSchedule)s).stringifyMLC(), 0, FAC_POS);
                throw new ScheduleErrorException("Resource Bindings", rex.getUsages());
            }
        } else {
            r = super.delayStartTime(s, se, offset);
        }
        return r;
    }

    public synchronized MLCSchedule delayStartTime(MLCSchedule mlcs, ScheduleElement se, int offset) throws ResourceBindingsException {
        if (this.POSrescheduling != null) {
            this.POSrescheduling.updateCount(1.0);
        }
        this.log.log("POS delayStartTime start \n" + mlcs, 5, FAC_POS);
        Vector v = mlcs.delayStartTime(se, offset);
        String key = this.generateKey(v);
        int recursionDepth = this.recursion.containsKey(key) ? (Integer)this.recursion.get(key) + 1 : 1;
        this.recursion.put(key, new Integer(recursionDepth));
        if (this.autobinding) {
            this.deleteResourceUsages(v, true);
            try {
                boolean sliding = false;
                Enumeration e = v.elements();
                while (e.hasMoreElements()) {
                    ScheduleElement s = (ScheduleElement)e.nextElement();
                    sliding = this.rebindResources(mlcs, s, true, sliding);
                    if ((Integer)this.recursion.get(key) <= 30) continue;
                    this.log.log("Recursive loop is to deep, I'm stoppping the sliding mechanism", 2, FAC_POS);
                    sliding = false;
                }
                if ((Integer)this.recursion.get(key) < 30) {
                    Vector problems = this.verifyResourcesUsages(mlcs);
                    if (problems != null) {
                        this.deleteResourceUsages(v, false);
                        this.undeleteResourceUsages(v);
                        mlcs.undeleteTiming(v);
                        e = problems.elements();
                        while (e.hasMoreElements()) {
                            ScheduleElement se1 = (ScheduleElement)e.nextElement();
                            PrecedencePrecondition precedence = new PrecedencePrecondition(mlcs, se, null);
                            precedence.setOptional(true);
                            se1.addPrecondition((Precondition)precedence);
                        }
                        this.delayStartTime(mlcs, se, offset);
                    }
                } else {
                    this.log.log("Recursion is too deep, stopping here (" + recursionDepth + ")", 1, FAC_POS);
                }
                this.cleanResourceUsages(v);
                mlcs.deleteHistory(v);
            }
            catch (ResourceBindingsException res) {
                this.deleteResourceUsages(v, false);
                this.undeleteResourceUsages(v);
                mlcs.undeleteTiming(v);
                recursionDepth = (Integer)this.recursion.get(key);
                if (recursionDepth < 1) {
                    this.log.log("Error in  the recursion count (" + (recursionDepth - 1) + ")", 0, FAC_POS);
                    recursionDepth = 1;
                }
                if (--recursionDepth <= 0) {
                    this.recursion.remove(key);
                } else {
                    this.recursion.put(key, new Integer(recursionDepth));
                }
                throw res;
            }
        }
        if ((recursionDepth = ((Integer)this.recursion.get(key)).intValue()) < 1) {
            this.log.log("Error in  the recursion count (" + (recursionDepth - 1) + ")", 0, FAC_POS);
            recursionDepth = 1;
        }
        if (--recursionDepth <= 0) {
            this.recursion.remove(key);
        } else {
            this.recursion.put(key, new Integer(recursionDepth));
        }
        this.log.log("POS delayStartTime end", 5, FAC_POS);
        return mlcs;
    }

    public synchronized Schedule setStartTime(Schedule s, int time) throws ScheduleErrorException {
        Schedule r = null;
        if (s instanceof MLCSchedule) {
            try {
                r = this.setStartTime((MLCSchedule)s, time);
            }
            catch (ResourceBindingsException rex) {
                this.log.log("Sorry, resource problem allocation ", 0, FAC_POS);
                throw new ScheduleErrorException("Resource Bindings", rex.getUsages());
            }
        } else {
            r = super.setStartTime(s, time);
        }
        return r;
    }

    public synchronized MLCSchedule setStartTime(MLCSchedule mlcs, int time) throws ResourceBindingsException {
        if (this.POSrescheduling != null) {
            this.POSrescheduling.updateCount(1.0);
        }
        this.log.log("POS setStartTime start", 5, FAC_POS);
        mlcs.setStartTime(time);
        if (this.autobinding) {
            this.deleteResourceUsages(mlcs.getScheduleElements(), true);
            try {
                Enumeration e = mlcs.getElements();
                boolean sliding = false;
                while (e.hasMoreElements()) {
                    ScheduleElement s = (ScheduleElement)e.nextElement();
                    sliding = this.rebindResources(mlcs, s, true, sliding);
                }
            }
            catch (ResourceBindingsException res) {
                this.deleteResourceUsages(mlcs.getScheduleElements(), false);
                this.undeleteResourceUsages(mlcs.getScheduleElements());
                mlcs.undeleteTiming(mlcs.getScheduleElements());
                throw res;
            }
            this.cleanResourceUsages(mlcs.getScheduleElements());
        }
        mlcs.deleteHistory(mlcs.getScheduleElements());
        this.log.log("POS setStartTime end", 5, FAC_POS);
        return mlcs;
    }

    public Vector addParallelHints(Taems t) {
        TreeSet contexts;
        Object key = this.generateCacheKey(t);
        Vector hints = this.getParallelHints(key, contexts = this.extractCurrentContext(t));
        if (hints != null && !hints.isEmpty()) {
            this.log.log("Adding " + hints.size() + " hints to task structure " + t.getLabel(), 3, FAC_POS);
            Enumeration he = hints.elements();
            Vector<Node> v = new Vector<Node>();
            while (he.hasMoreElements()) {
                Interrelationship hi = (Interrelationship)he.nextElement();
                if (!v.contains(hi.getFrom())) {
                    t.addNode(hi.getFrom());
                    v.addElement(hi.getFrom());
                }
                if (v.contains(hi.getTo())) continue;
                t.addNode(hi.getTo());
                v.addElement(hi.getTo());
            }
            t.retargetVirtuals();
        } else {
            this.log.log("No hints found for task structure " + t.getLabel() + " with key " + key, 3, FAC_POS);
        }
        return hints;
    }

    public void removeParallelHints(Taems t, Vector hints) {
        if (hints != null && !hints.isEmpty()) {
            this.log.log("Removing " + hints.size() + " hints from task structure " + t.getLabel(), 4, FAC_POS);
            Enumeration he = hints.elements();
            while (he.hasMoreElements()) {
                Interrelationship hi = (Interrelationship)he.nextElement();
                hi.excise();
            }
            t.retargetVirtuals();
        }
    }

    public Vector extractParallelHints(Taems t) {
        Vector<FacilitatesInterrelationship> v = new Vector<FacilitatesInterrelationship>();
        if (this.usehints) {
            this.log.log("Extracting parallel hints for structure " + t.getLabel(), 3, FAC_POS);
            Schedule s = t.getFirstSchedule();
            if (s == null) {
                this.log.log("Cannot extract parallel hints, " + t.getLabel() + " has no schedule", 1, FAC_POS);
                return v;
            }
            Enumeration se = s.getScheduleElements().elements();
            block0: while (se.hasMoreElements()) {
                ScheduleElement cse = (ScheduleElement)se.nextElement();
                int cses = (int)cse.getStartTime().calculateMax();
                int csef = (int)cse.getFinishTime().calculateMin();
                Enumeration sse = s.getScheduleElements().elements();
                while (sse.hasMoreElements()) {
                    ScheduleElement tse = (ScheduleElement)sse.nextElement();
                    int tses = (int)tse.getStartTime().calculateMax();
                    int tsef = (int)tse.getFinishTime().calculateMin();
                    if (cse == tse || tsef <= cses) continue;
                    if (tses >= csef) continue block0;
                    if (tsef - tses <= 0) continue;
                    int overlap = (csef < tsef ? csef : tsef) - (cses > tses ? cses : tses);
                    float power = (float)overlap / (float)(tsef - tses);
                    FacilitatesInterrelationship fi = new FacilitatesInterrelationship("F-" + cse.getLabel() + "_" + tse.getLabel(), cse.getMethod().getAgent(), new Distribution(0.0f, 1.0f), new Distribution(power, 1.0f), new Distribution(0.0f, 1.0f), new Distribution(0.0f, 1.0f));
                    new VirtualMethod(cse.getMethod().getLabel(), cse.getMethod().getAgent()).addInterrelationship((Interrelationship)fi, (Node)new VirtualMethod(tse.getMethod().getLabel(), tse.getMethod().getAgent()));
                    v.addElement(fi);
                }
            }
        }
        return v;
    }

    public TreeSet extractCurrentContext(Taems t) {
        TreeSet<ResourceContext> v = new TreeSet<ResourceContext>(new ContextCompare());
        int start = (Integer)this.state.getProperty((Object)"Time") + 1;
        int finish = start + 1;
        if (t != null) {
            this.log.log("Extracting context from " + t.getLabel(), 4, FAC_POS);
            Enumeration e = t.findNodes((Node)new Resource());
            while (e.hasMoreElements()) {
                Resource r = (Resource)e.nextElement();
                ResourceModel m = this.modeler.getModel(r.getLabel());
                ResourceContext c = m.generateContext(start, finish);
                v.add(c);
                this.log.log("Got context: " + c, 5, FAC_POS);
            }
        } else {
            this.log.log("Extracting overall context", 4, FAC_POS);
            Enumeration e = this.modeler.getModels();
            while (e.hasMoreElements()) {
                ResourceModel m = (ResourceModel)e.nextElement();
                ResourceContext c = m.generateContext(start, finish);
                v.add(c);
                this.log.log("Got context: " + c, 5, FAC_POS);
            }
        }
        return v;
    }

    protected Vector getParallelHints(Object key, TreeSet contexts) {
        Vector v = (Vector)this.parallelhints.get(key);
        if (v == null) {
            v = new Vector();
            this.parallelhints.put(key, v);
        }
        this.log.log("Hints vector is size " + v.size(), 4, FAC_POS);
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            TreeSet c = (TreeSet)e.nextElement();
            Vector h = (Vector)e.nextElement();
            boolean same = true;
            Iterator ci = c.iterator();
            while (ci.hasNext()) {
                ResourceContext cic = (ResourceContext)ci.next();
                Iterator coni = contexts.iterator();
                same = false;
                while (coni.hasNext()) {
                    ResourceContext conic = (ResourceContext)coni.next();
                    this.log.log("Looking at " + conic + " (compare " + cic.compareTo(conic) + ")", 5, FAC_POS);
                    if (Math.abs(cic.compareTo(conic)) >= 100) continue;
                    same = true;
                    break;
                }
                if (!same) {
                    this.log.log("Couldn't find match for " + cic, 4, FAC_POS);
                    break;
                }
                this.log.log("Found match for " + cic, 4, FAC_POS);
            }
            if (same) {
                this.log.log("Found match for key/context pair of size " + h.size(), 4, FAC_POS);
                return h;
            }
            this.log.log("Couldn't find match for key/context pair", 4, FAC_POS);
        }
        return new Vector();
    }

    protected void setParallelHints(Object key, TreeSet contexts, Vector hints) {
        Vector<AbstractCollection> v = (Vector<AbstractCollection>)this.parallelhints.get(key);
        if (v == null) {
            if (this.parallelhints.size() > this.cachelimit) {
                Object k = this.parallelhints.keys().nextElement();
                this.log.log("Parallel hint cache size exceeded, removing " + k, 3, FAC_POS);
                this.parallelhints.remove(k);
            }
            v = new Vector<AbstractCollection>();
            this.parallelhints.put(key, v);
        }
        if (v.size() > this.cachelimit) {
            this.log.log("Hint list size exceeded, removing first hint from " + key, 3, FAC_POS);
            v.removeElement(v.firstElement());
            v.removeElement(v.firstElement());
        }
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            TreeSet c = (TreeSet)e.nextElement();
            if (c.size() == contexts.size()) {
                boolean same = true;
                Iterator ci = c.iterator();
                Iterator coni = contexts.iterator();
                while (coni.hasNext()) {
                    ResourceContext conic;
                    ResourceContext cic = (ResourceContext)ci.next();
                    if (Math.abs(cic.compareTo(conic = (ResourceContext)coni.next())) <= 100) continue;
                    same = false;
                    break;
                }
                if (same) {
                    Vector h = (Vector)e.nextElement();
                    h.removeAllElements();
                    h.addAll(hints);
                    return;
                }
            }
            e.nextElement();
        }
        v.addElement(contexts);
        v.addElement(hints);
    }

    public void writeParallelHints() {
        StringBuffer buf = new StringBuffer("");
        Enumeration e = this.parallelhints.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            Vector v = (Vector)this.parallelhints.get(key);
            Enumeration ve = v.elements();
            while (ve.hasMoreElements()) {
                TreeSet c = (TreeSet)ve.nextElement();
                Vector h = (Vector)ve.nextElement();
                if (h.isEmpty()) continue;
                buf.append("_START\n" + key + "\n");
                Iterator i = c.iterator();
                while (i.hasNext()) {
                    buf.append(((ResourceContext)i.next()).output() + "\n");
                }
                buf.append("\n");
                i = ((AbstractList)h).iterator();
                while (i.hasNext()) {
                    buf.append(((Interrelationship)i.next()).toString() + "\n");
                }
                buf.append("_END\n");
            }
        }
        System.err.println(buf.toString());
    }

    public void readParallelHints() {
        String file = (String)this.state.getProperty((Object)"ParallelHintCache");
        if (file == null) {
            this.log.log("No parallel hint cache file found", 3, FAC_POS);
            return;
        }
        BufferedReader r = this.state.getExtendedEntryReader(file);
        if (r == null) {
            this.log.log("Parallel hint cache " + file + " not found", 3, FAC_POS);
            return;
        }
        SimpleTaemsReader reader = (SimpleTaemsReader)State.findComponent((String)"TaemsReader");
        if (reader == null) {
            this.log.log("No taems reader found, cannot read parallel hints", 3, FAC_POS);
            return;
        }
        try {
            String line;
            while ((line = r.readLine()) != null) {
                if (!line.startsWith("_START")) continue;
                TreeSet<ResourceContext> c = new TreeSet<ResourceContext>();
                Vector<Interrelationship> h = new Vector<Interrelationship>();
                String key = r.readLine().trim();
                while (!(line = r.readLine().trim()).equals("")) {
                    ResourceContext con = new ResourceContext(line);
                    c.add(con);
                }
                StringBuffer buf = new StringBuffer();
                while (!(line = r.readLine() + "\n").startsWith("_END")) {
                    buf.append(line);
                }
                StringReader s = new StringReader(buf.toString());
                Taems t = reader.readTTaems(s);
                Enumeration e = t.findNodes((Node)new Interrelationship());
                while (e.hasMoreElements()) {
                    Interrelationship ir = (Interrelationship)e.nextElement();
                    h.addElement(ir);
                }
                this.log.log("Read in parallel cache for key " + key + ", with " + c.size() + " resource contexts and " + h.size() + " hints", 2, FAC_POS);
                this.setParallelHints(key, c, h);
            }
        }
        catch (EOFException e) {
        }
        catch (IOException e) {
            this.log.log("Error: " + e, 0, FAC_POS);
        }
    }

    protected Object generateCacheKey(Taems taems) {
        String l;
        StringBuffer buf = new StringBuffer();
        Enumeration e = taems.getNodes();
        while (e.hasMoreElements()) {
            Node n = (Node)e.nextElement();
            if (!(n instanceof Task)) continue;
            Task t = (Task)n;
            buf.append(t.getLabel());
            buf.append(String.valueOf(t.getEarliestStartTime()));
            buf.append(String.valueOf(t.getDeadline()));
        }
        e = taems.findNodes((Node)new Method());
        while (e.hasMoreElements()) {
            Method m = (Method)e.nextElement();
            l = m.getLabel();
            buf.append(l);
            buf.append(String.valueOf(m.getEarliestStartTime()));
            buf.append(String.valueOf(m.getDeadline()));
            buf.append(m.getGlobalOutcome().getDuration().calculateMax());
            buf.append(m.getCurrentQuality());
        }
        e = taems.findNodes((Node)new Interrelationship());
        while (e.hasMoreElements()) {
            Interrelationship i = (Interrelationship)e.nextElement();
            l = i.getLabel();
            if (l.indexOf("_") > 0) {
                l = l.substring(0, l.indexOf("_"));
            }
            buf.append(l);
            if (i.getQuality() != null) {
                buf.append(i.getQuality().calculateMax());
            }
            if (i.getCost() != null) {
                buf.append(i.getCost().calculateMax());
            }
            if (i.getDuration() == null) continue;
            buf.append(i.getDuration().calculateMax());
        }
        return buf.toString();
    }

    public synchronized void detachUsages(MLCSchedule mlcs) {
        Enumeration e = mlcs.getElements();
        while (e.hasMoreElements()) {
            ScheduleElement se = (ScheduleElement)e.nextElement();
            if (se.hasFinished()) continue;
            Enumeration e1 = se.getPreconditionsElement();
            while (e1.hasMoreElements()) {
                Precondition p = (Precondition)e1.nextElement();
                if (!(p instanceof ResourcePrecondition)) continue;
                ((ResourcePrecondition)p).clear();
            }
        }
    }

    public synchronized void attachUsages(MLCSchedule mlcs) {
        Enumeration e = mlcs.getElements();
        while (e.hasMoreElements()) {
            ScheduleElement se = (ScheduleElement)e.nextElement();
            if (se.hasFinished()) continue;
            Enumeration e1 = se.getPreconditionsElement();
            while (e1.hasMoreElements()) {
                Precondition p = (Precondition)e1.nextElement();
                if (!(p instanceof ResourcePrecondition)) continue;
                ((ResourcePrecondition)p).attach();
            }
        }
    }

    public synchronized boolean updateSchedule(MLCSchedule newmlcs, Hashtable ht) {
        Enumeration enumeration = ht.keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            Taems t = (Taems)ht.get(key);
            Schedule s = t.getFirstSchedule();
            int oldID = ((ScheduleElement)s.getElements().nextElement()).getID();
            boolean foundit = false;
            Enumeration e1 = newmlcs.getSchedules();
            while (e1.hasMoreElements()) {
                int newID;
                Schedule s1 = (Schedule)e1.nextElement();
                ScheduleElement se1 = (ScheduleElement)s1.getElements().nextElement();
                if (!se1.hasAttribute((Object)"Cloned") || (newID = ((Integer)se1.getAttribute((Object)"Cloned")).intValue()) != oldID) continue;
                System.err.println("We got one: " + oldID + " -> " + se1.getID());
                foundit = true;
                t.setSchedule(s1);
                break;
            }
            if (foundit) continue;
            this.log.log("Houston we have a problem, I coudn't find a match for this:\n" + s.stringify(), 1, FAC_POS);
        }
        this.state.setProperty((Object)"Schedule", (Object)newmlcs);
        return true;
    }

    public synchronized Vector whatIf(Hashtable taems, MLCSchedule mlcs) throws ScheduleErrorException, ResourceBindingsException {
        Enumeration enumeration = taems.keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            Taems t = (Taems)taems.get(key);
            this.modeler.scanTaemsStructure(t);
        }
        return this.scheduleTaems(taems, mlcs, false, true, false);
    }

    public static void main(String[] argv) {
        Control control = new Control(false);
        agent.simplest.Log log = new agent.simplest.Log();
        State state = new State();
        state.setProperty((Object)"DTC", (Object)"scheduler/dtc");
        state.setProperty((Object)"MassHome", (Object)"..");
        state.setProperty((Object)"Name", (Object)"POScheduler");
        Communicate communicate = new Communicate();
        WindowManager win = new WindowManager();
        Observe observe = new Observe();
        PartialOrderScheduler sched = new PartialOrderScheduler();
        ResourceModeler modeler = new ResourceModeler();
        Sensor sensor = new Sensor();
        try {
            control.setupComponents();
        }
        catch (DependencyFailedException ex) {
            log.log((Object)ex, 0, FAC_POS);
        }
        log.setLogLevel(FAC_POS, 3);
        log.setLogLevel(2);
        state.setProperty((Object)"CompactingRate", (Object)new Float(-1.0f));
        try {
            Taems task;
            PreProcessor pre;
            PreProcessorParser parser;
            ReadTTaems reader = new ReadTTaems(new Log("/dev/null"));
            if (!argv[argv.length - 1].startsWith("-")) {
                System.err.println("Using as an input file : " + argv[argv.length - 1]);
                if (argv[argv.length - 1].endsWith(".ptaems")) {
                    parser = new PreProcessorParser((Reader)new FileReader(argv[argv.length - 1]));
                    pre = parser.Input();
                    task = reader.readTTaems((Reader)new StringReader(pre.toTTaems(new Hashtable())));
                } else {
                    task = reader.readTTaems((Reader)new FileReader(argv[argv.length - 1]));
                }
            } else {
                System.err.println("Using the standard input <");
                parser = new PreProcessorParser(System.in);
                pre = parser.Input();
                task = reader.readTTaems((Reader)new StringReader(pre.toTTaems(new Hashtable())));
            }
            int i = 0;
            while (i < argv.length) {
                if (argv[i].equals("-ttaems")) {
                    System.out.println(task.toTTaems(1.1f));
                }
                if (argv[i].equals("-schedule")) {
                    Hashtable<String, Taems> h = new Hashtable<String, Taems>();
                    if (task.getLabel() == null) {
                        task.setLabel("test");
                    }
                    h.put(task.getLabel(), task);
                    state.setProperty((Object)SimpleTaemsReader.SUBTAEMS, h, (Object)"new");
                    state.setProperty((Object)SimpleTaemsReader.CONTAEMS, h, (Object)"new");
                    MLCSchedule mlcs = (MLCSchedule)state.getProperty((Object)"Schedule");
                    if (mlcs != null) {
                        System.out.println("Schedule:\n" + mlcs.stringifyMLC());
                        Vector<MLCSchedule> clones = new Vector<MLCSchedule>();
                        int k = 0;
                        while (k < 500) {
                            MLCSchedule mlcs1 = (MLCSchedule)mlcs.clone();
                            System.out.println("Schedule cloned: " + k + "\n" + mlcs1.stringifyMLC());
                            sched.detachUsages(mlcs);
                            sched.attachUsages(mlcs1);
                            Vector v = sched.checkConflicts(mlcs1);
                            if (v != null) {
                                System.err.println("We are going to be late (MAYBE you should check it)");
                            } else {
                                System.err.println("Deadline are fine !!");
                            }
                            System.out.println("Resources conflict check:");
                            v = sched.verifyResourcesUsages(mlcs1);
                            if (v != null) {
                                System.err.println("Resources conflicts !!!");
                            } else {
                                System.err.println("Resources are fine !!");
                            }
                            sched.updateSchedule(mlcs1, h);
                            clones.addElement(mlcs);
                            mlcs = mlcs1;
                            ++k;
                        }
                    }
                }
                ++i;
            }
        }
        catch (IOException ioe) {
            log.log("Problem with /dev/null that's strange ?", 0, FAC_POS);
        }
        catch (ParseException pe) {
            System.err.println("Error in parsing PTAEMS: " + pe.getMessage());
        }
        control.quit();
    }

    public static void showTaems(Taems t) {
        JFrame frame = new JFrame("Taems");
        ((Component)frame).setSize(500, 400);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)frame).setLocation(screenSize.width / 2 - 250, screenSize.height / 2 - 200);
        frame.getContentPane().add((Component)t, "Center");
        frame.show();
    }

    class ContextCompare
    implements Comparator {
        public int compare(Object o1, Object o2) {
            return 1;
        }

        public boolean equals(Object o1) {
            return true;
        }
    }
}

