/*
 * Decompiled with CFR 0.152.
 */
package agent.negotiation;

import agent.base.AgentEvent;
import agent.base.AgentListener;
import agent.base.ListenerVector;
import agent.coordinate.CSharpInitiator;
import agent.coordinate.CSharpResponder;
import agent.coordinate.CoordinateEvent;
import agent.coordinate.CoordinateEventListener;
import agent.coordinate.CoordinateEventProducer;
import agent.coordinate.DSharpInitiator;
import agent.coordinate.DSharpResponder;
import agent.coordinate.FSMCoordination;
import agent.diagnose.symptom.CommitmentSent;
import agent.mass.PreprocessTaemsReader;
import agent.mass.ProblemSolver;
import agent.mass.Scheduler;
import agent.mass.SimpleTaemsReader;
import agent.mass.TaemsAction;
import agent.simplest.Action;
import agent.simplest.ActionEvent;
import agent.simplest.PropertyEvent;
import agent.simplest.PropertyEventListener;
import agent.simplest.State;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import taems.Agent;
import taems.Commitment;
import taems.ConsumesInterrelationship;
import taems.Criteria;
import taems.EnablesInterrelationship;
import taems.Method;
import taems.Node;
import taems.Outcome;
import taems.ProducesInterrelationship;
import taems.Resource;
import taems.Schedule;
import taems.ScheduleElement;
import taems.Taems;
import taems.TaskBase;

public class MyBasicProblemSolver
extends ProblemSolver
implements PropertyEventListener,
CoordinateEventListener,
CoordinateEventProducer {
    protected Taems conditioned;
    protected Scheduler scheduler;
    protected Vector schedule;
    protected Hashtable coordinationOverSchedule;
    protected int scheduleNumber = 0;
    protected Vector scheduleList;
    protected boolean reset = false;
    protected int TIMEOUT = 5;
    protected int DEFAULT_WINDOW = 15;
    protected FSMCoordination fsmCoordinate;
    protected ListenerVector listeners = new ListenerVector();
    protected Vector coordinateQueue = new Vector();
    protected SimpleTaemsReader taemsreader;
    protected PreprocessTaemsReader ptaemsreader;
    public int EventNumber = 0;
    public int NStime = 0;
    public int NEtime = 0;
    public boolean isNegotiating = false;
    public int round;
    public int WORKLOAD = 144;
    public int tanum = 24;
    public float MQ1 = 0.0f;
    public int tss = 0;
    public int ws = 0;
    public float slacktime = 0.0f;
    public int deadlineCST = 0;
    public int estCST = 0;
    public int enablesCST = 0;
    public String name1;
    public String name2;
    public Taems openM4 = null;
    public boolean hasRead = false;

    public MyBasicProblemSolver() {
        State.addParameterInfo((String)"TIMEOUT", (String)"Integer", (String)"Delay before considering any request timed out", (Object)new Integer(5));
        this.addDependency("Scheduler");
    }

    public void init() {
        super.init();
        this.scheduler = (Scheduler)State.findComponent((String)"Scheduler");
        this.ptaemsreader = (PreprocessTaemsReader)State.findComponent((String)"PreprocessTaemsReader");
        this.conditioned = null;
        this.schedule = null;
        this.scheduleList = null;
        this.log.log("MyBasic agent Version 1.3", 2, this.FAC_PS);
        if (this.state != null) {
            this.state.setProperty((Object)"SetTaemsName", (Object)new Boolean(true));
            this.state.setProperty((Object)"UpdateDist", (Object)new Boolean(true));
            this.state.setProperty((Object)"AutoExecute", (Object)new Boolean(false));
            this.TIMEOUT = (Integer)this.state.getProperty((Object)"TIMEOUT");
        }
        this.fsmCoordinate = (FSMCoordination)State.findComponent((String)"FSMCoordination");
        if (this.fsmCoordinate != null) {
            this.fsmCoordinate.addCoordinateEventListener(this);
            this.log.log("Using FSMCoordination bean", 2, this.FAC_PS);
        } else {
            this.log.log("Not using the default FSMCoordination bean.", 2, this.FAC_PS);
        }
        try {
            FileReader fileIn = new FileReader("round.txt");
            StreamTokenizer in = new StreamTokenizer(fileIn);
            in.wordChars(48, 57);
            if (in.nextToken() == -2) {
                this.round = (int)in.nval;
                this.log.log("token:" + in.sval + " " + in.nval, 0, this.FAC_PS);
            }
            if (in.nextToken() == -2) {
                this.WORKLOAD = (int)in.nval;
                this.log.log("token:" + in.sval + " " + in.nval, 2, this.FAC_PS);
            }
            this.log.log("start from round=" + this.round + " WORKLOAD=" + this.WORKLOAD, 2, this.FAC_PS);
        }
        catch (IOException e) {
            this.log.log(" Read: IOException", 0, this.FAC_PS);
        }
    }

    public void checktaems(Taems taems) {
        float totald = 0.0f;
        this.slacktime = 0.0f;
        this.deadlineCST = 0;
        this.estCST = 0;
        this.enablesCST = 0;
        Criteria crit = taems.getScheduleCriteria();
        Taems local = taems;
        Enumeration enumeration = local.findNodes((Node)new Method());
        while (enumeration.hasMoreElements()) {
            Method m = (Method)enumeration.nextElement();
            Outcome outc = (Outcome)m.getOutcomes().nextElement();
            float d = outc.getDuration().calculateAvg();
            totald += d;
        }
        this.slacktime = crit.getDurationThreshold().floatValue() - totald;
        Enumeration all = local.findNodes((Node)new TaskBase());
        while (all.hasMoreElements()) {
            TaskBase tb = (TaskBase)all.nextElement();
            if (tb.getDeadline() > 0) {
                ++this.deadlineCST;
            }
            if (tb.getEarliestStartTime() <= 0) continue;
            ++this.estCST;
        }
        boolean same = false;
        enumeration = local.findNodes((Node)new EnablesInterrelationship());
        Vector<String> NLEname = new Vector<String>();
        while (enumeration.hasMoreElements()) {
            EnablesInterrelationship NLE = (EnablesInterrelationship)enumeration.nextElement();
            Enumeration oldnames = NLEname.elements();
            same = false;
            while (oldnames.hasMoreElements()) {
                String tn = (String)oldnames.nextElement();
                if (!tn.equalsIgnoreCase(NLE.getLabel())) continue;
                same = true;
                break;
            }
            if (same) continue;
            NLEname.addElement(NLE.getLabel());
            this.log.log("NLE=" + NLE.getLabel(), 1, this.FAC_PS);
            ++this.enablesCST;
        }
        this.log.log("slacktime=" + this.slacktime + " deadlineCST=" + this.deadlineCST + " estCST=" + this.estCST + " enablesCST=" + this.enablesCST, 1, this.FAC_PS);
    }

    public void reset() {
        if (this.execute.isExecuting() && this.schedule != null) {
            Method m = (Method)this.conditioned.findNode((Node)new Method((String)this.schedule.elementAt(0), null));
            this.execute.cancelAction((Action)new TaemsAction(m), "reset Tasks");
        }
        this.schedule = null;
        this.scheduleList = null;
        this.conditioned = null;
        this.reset = true;
    }

    public void pulse() {
        int time = (Integer)this.state.getProperty((Object)"Time");
        this.log.log("isNegotiating = " + this.isNegotiating, 2, this.FAC_PS);
        this.log.log("round = " + this.round + " WORKLOAD=" + this.WORKLOAD, 0, this.FAC_PS);
        this.log.log("EventNumber = " + this.EventNumber, 2, this.FAC_PS);
        if (((String)this.state.getProperty((Object)"Name")).equals("TA2_Agent") && !this.hasRead) {
            this.log.log("readin open M4 ", 2, this.FAC_PS);
            this.openM4 = this.ptaemsreader.readTTaems("ta2/M4.ttaems");
            this.log.log("readin: openM4=" + this.openM4, 2, this.FAC_PS);
            this.hasRead = true;
        }
        if (this.round > this.WORKLOAD) {
            this.log.log("All my work is Done, I am quitting", 2, this.FAC_PS);
            System.exit(0);
        }
        if (!this.isNegotiating) {
            this.reset = false;
            this.log.log("set isNegotiating = true", 2, this.FAC_PS);
            this.isNegotiating = true;
            this.NStime = (Integer)this.state.getProperty((Object)"Time");
            if (this.round < this.WORKLOAD) {
                this.makeNewTaskStructure(this.round);
                this.conditioned = (Taems)this.state.getProperty((Object)"ConTaemsTask");
            }
            this.EventNumber = 0;
            ++this.round;
            this.conditioned = (Taems)this.state.getProperty((Object)"ConTaemsTask");
            this.conditioned.setScheduleVector(new Vector());
            Taems t = this.evaluateTaems(this.conditioned, false);
            if (t.getScheduleVector() != null) {
                this.schedule = new Vector();
                Enumeration e = this.conditioned.getFirstSchedule().getElements();
                while (e.hasMoreElements()) {
                    ScheduleElement schElement = (ScheduleElement)e.nextElement();
                    this.schedule.addElement(schElement.getLabel());
                }
                this.coordinationOverSchedule = new Hashtable();
                Vector com = this.generateCommitment(this.conditioned);
                if (com != null) {
                    this.callFSMCoordinate(this.generateCommitment(this.conditioned));
                    this.log.log("Coordination Done", 2, this.FAC_PS);
                } else {
                    this.isNegotiating = false;
                    --this.round;
                }
            }
        }
    }

    public void readNewTaskStructure(int round) {
        String name = null;
        int r = 1;
        int round1 = round + 1;
        if (((String)this.state.getProperty((Object)"Name")).equals("TA1_Agent") || ((String)this.state.getProperty((Object)"Name")).equals("TA3_Agent")) {
            r = round / this.tanum + 1;
            if (r > this.tanum) {
                r = 1;
            }
            name = "ta1/ta1-" + r + ".ttaems";
        } else if (((String)this.state.getProperty((Object)"Name")).equals("TA2_Agent") || ((String)this.state.getProperty((Object)"Name")).equals("TA4_Agent")) {
            r = round % this.tanum + 1 + this.tss;
            name = "ta2/ta2-" + r + ".ttaems";
        }
        this.name1 = name;
        int r1 = round % this.tanum + 1 + this.tss;
        this.name2 = "ta2/ta2-" + r1 + ".ttaems";
        this.log.log("Reading new task structure: " + name, 2, this.FAC_PS);
        this.state.setProperty((Object)"ObjTaems", (Object)name);
        this.state.setProperty((Object)"SubTaems", (Object)name);
        this.state.setProperty((Object)"ConTaems", (Object)name);
        this.taemsreader.makeAllStructures();
    }

    public void makeNewTaskStructure(int round) {
        Object name = null;
        Hashtable ht = new Hashtable();
        this.ptaemsreader.makeAllStructures();
    }

    public boolean invokeScheduler(boolean rescheduling) {
        this.log.log("Scheduling... ", 2, this.FAC_PS);
        this.conditioned = (Taems)this.state.getProperty((Object)"ConTaemsTask");
        if (this.conditioned != null) {
            this.scheduleList = this.scheduler.scheduleTaems(this.conditioned, rescheduling);
            if (this.scheduleList != null) {
                this.scheduleNumber = 0;
                this.conditioned.setScheduleVector(this.scheduleList);
                this.schedule = null;
                Schedule s = this.conditioned.getFirstSchedule();
                ++this.scheduleNumber;
                this.schedule = new Vector();
                String print = "invokeScheduler: ";
                Enumeration e = this.conditioned.getFirstSchedule().getElements();
                while (e.hasMoreElements()) {
                    ScheduleElement schElement = (ScheduleElement)e.nextElement();
                    this.schedule.addElement(schElement.getLabel());
                    print = print + "[" + schElement.getStart() + " - " + schElement.getLabel() + " - " + schElement.getFinish() + "] ";
                }
                this.log.log(print, 2, this.FAC_PS);
                this.coordinationOverSchedule = new Hashtable();
                this.callFSMCoordinate(this.generateCommitment(this.conditioned));
                this.log.log("Coordination Done", 2, this.FAC_PS);
                return true;
            }
        }
        return false;
    }

    public void addCoordinateEvent(ScheduleElement schElement, CoordinateEvent ce) {
        Vector vectorCE = new Vector();
        if (this.coordinationOverSchedule.containsKey(schElement)) {
            vectorCE = (Vector)this.coordinationOverSchedule.get(schElement);
            this.coordinationOverSchedule.remove(schElement);
        }
        Enumeration e = vectorCE.elements();
        while (e.hasMoreElements()) {
            if (ce != (CoordinateEvent)((Object)e.nextElement())) continue;
            this.coordinationOverSchedule.put(schElement, vectorCE);
            return;
        }
        vectorCE.addElement(ce);
        this.coordinationOverSchedule.put(schElement, vectorCE);
    }

    public ScheduleElement FindScheduleElement(CoordinateEvent ce) {
        if (ce.getCoordinateID() != null) {
            Enumeration e = this.coordinationOverSchedule.keys();
            while (e.hasMoreElements()) {
                ScheduleElement schElement = (ScheduleElement)e.nextElement();
                Vector vectorCE = (Vector)this.coordinationOverSchedule.get(schElement);
                if (vectorCE == null) continue;
                Enumeration e1 = vectorCE.elements();
                while (e1.hasMoreElements()) {
                    CoordinateEvent ce1 = (CoordinateEvent)((Object)e1.nextElement());
                    if (!ce.getCoordinateID().equals(ce1.getCoordinateID())) continue;
                    return schElement;
                }
            }
        }
        return null;
    }

    public boolean checkCoordinationOk(ScheduleElement schElement) {
        Vector vectorCE = new Vector();
        if (this.coordinationOverSchedule.containsKey(schElement)) {
            vectorCE = (Vector)this.coordinationOverSchedule.get(schElement);
            Enumeration e = vectorCE.elements();
            while (e.hasMoreElements()) {
                CoordinateEvent ce1 = (CoordinateEvent)((Object)e.nextElement());
                if (ce1.getID() == 1) continue;
                return false;
            }
        }
        return true;
    }

    public void setCoordinateEvent(CoordinateEvent ce, int ID) {
        ScheduleElement schElement = this.FindScheduleElement(ce);
        if (schElement != null) {
            Vector vectorCE = (Vector)this.coordinationOverSchedule.get(schElement);
            this.coordinationOverSchedule.remove(schElement);
            Enumeration e1 = vectorCE.elements();
            while (e1.hasMoreElements()) {
                CoordinateEvent ce1 = (CoordinateEvent)((Object)e1.nextElement());
                if (!ce.getCoordinateID().equals(ce1.getCoordinateID())) continue;
                ce1.setID(ID);
                break;
            }
            this.coordinationOverSchedule.put(schElement, vectorCE);
        }
    }

    public void replaceCoordinateEvent(CoordinateEvent ce) {
        ScheduleElement schElement = this.FindScheduleElement(ce);
        Vector vectorCE = (Vector)this.coordinationOverSchedule.get(schElement);
        this.coordinationOverSchedule.remove(schElement);
        Enumeration e1 = vectorCE.elements();
        while (e1.hasMoreElements()) {
            CoordinateEvent ce1 = (CoordinateEvent)((Object)e1.nextElement());
            if (!ce.getCoordinateID().equals(ce1.getCoordinateID())) continue;
            vectorCE.removeElement((Object)ce1);
            vectorCE.addElement(ce);
            break;
        }
        this.coordinationOverSchedule.put(schElement, vectorCE);
    }

    public Taems evaluateTaems(Taems t, boolean rescheduling) {
        Vector sl;
        if (t != null && (sl = this.scheduler.evaluateTaems(t, rescheduling)) != null) {
            t.setScheduleVector(sl);
            Schedule s = t.getFirstSchedule();
            Enumeration e = t.getFirstSchedule().getElements();
            String print = "EvaluateTaems: ";
            while (e.hasMoreElements()) {
                ScheduleElement schElement = (ScheduleElement)e.nextElement();
                print = print + "[" + schElement.getStart() + " - " + schElement.getLabel() + " - " + schElement.getFinish() + "] ";
            }
            this.log.log(print, 2, this.FAC_PS);
        }
        return t;
    }

    public void propertyChanged(PropertyEvent e) {
        String key = e.getKey().toString();
        if (key.equalsIgnoreCase("ConTaemsTask")) {
            this.log.log("Argh! NEW  Task structure received", 2, this.FAC_PS);
            this.reset();
        }
    }

    public void propertyRemoved(PropertyEvent e) {
        this.propertyChanged(e);
    }

    public void propertyAdded(PropertyEvent e) {
        this.propertyChanged(e);
    }

    public void actionStarted(ActionEvent e) {
    }

    public void actionAborted(ActionEvent e) {
        this.actionCompleted(e);
    }

    public void actionCompleted(ActionEvent e) {
        TaemsAction a = (TaemsAction)e.getAction();
        Method m = a.getMethod();
        if (m.getCurrentQuality() == 0.0f) {
            this.log.log("Argh! The method " + m.getLabel() + " didnt get enough quality :(.  I must reschedule.", 2, this.FAC_PS);
            if (!this.reset && this.schedule != null) {
                if (this.schedule.size() > 0) {
                    this.schedule.removeElementAt(0);
                    boolean answer = this.invokeScheduler(true);
                    if (!answer) {
                        this.log.log("Oups, DTC fails, running evaluateTaems as a backup solution", 2, this.FAC_PS);
                        Taems t = (Taems)this.state.getProperty((Object)"ConTaemsTask");
                        this.evaluateTaems(t, true);
                        this.schedule = new Vector();
                        Enumeration e1 = t.getFirstSchedule().getElements();
                        while (e1.hasMoreElements()) {
                            ScheduleElement schElement = (ScheduleElement)e1.nextElement();
                            this.schedule.addElement(schElement.getLabel());
                        }
                    }
                } else {
                    this.log.log("Whoops, I went to go remove the completed action from the schedule and the schedule was empty", 1, this.FAC_PS);
                }
            }
        } else if (!this.reset && this.schedule != null) {
            if (this.schedule.size() > 0) {
                this.schedule.removeElementAt(0);
            } else {
                this.log.log("Whoops, I went to go remove the completed action from the schedule and the schedule was empty", 1, this.FAC_PS);
            }
        }
    }

    public boolean isDefaultCommitment(Commitment c) {
        return c.hasAttribute((Object)"Default");
    }

    public Enumeration getRawCommitments() {
        Taems tasks = (Taems)this.state.getProperty((Object)"ConTaemsTask");
        return tasks.getCommitments();
    }

    public boolean checkForDefaultCommitment(Commitment c) {
        Vector v = this.getCommitmentsVector();
        this.log.log("Looking at " + v.size() + " Commitment in Conditional View ", 3, this.FAC_PS);
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            Commitment com = (Commitment)e.nextElement();
            if (!com.getType().equals(c.getType()) || com.getEarliestStartTime() != c.getEarliestStartTime() || com.getTimeDistribution().calculateMax() != c.getTimeDistribution().calculateMax() || com.getQuantity() != c.getQuantity() || com.getTimeSatisfied() != c.getTimeSatisfied()) continue;
            return true;
        }
        return false;
    }

    public Vector getCommitmentsVector() {
        Enumeration e = this.getRawCommitments();
        Vector<Commitment> v = new Vector<Commitment>();
        int time = (Integer)this.state.getProperty((Object)"Time");
        while (e.hasMoreElements()) {
            Commitment c = (Commitment)e.nextElement();
            if (this.isDefaultCommitment(c)) {
                int period = (Integer)c.getAttribute((Object)"Period");
                int start = c.getEarliestStartTime();
                CommitmentSent cr = (CommitmentSent)c.getAttribute((Object)"Pose");
                Commitment pc = cr.getTaems().getCommitment();
                int duration = pc.getTimeSatisfied() - pc.getEarliestStartTime();
                int i = time - duration;
                while (i <= time + this.DEFAULT_WINDOW) {
                    if (i >= start && (i - start) % period == 0) {
                        Commitment nc = (Commitment)pc.clone();
                        nc.setAttribute((Object)"DefaultCommitment", (Object)c);
                        nc.setAttribute((Object)"Default", (Object)new Boolean(true));
                        nc.setID(0L);
                        nc.setEarliestStartTime(i);
                        this.log.log("Adding default spawn for " + c.getID() + " starting at time " + nc.getEarliestStartTime(), 3, this.FAC_PS);
                        v.addElement(nc);
                    }
                    ++i;
                }
                continue;
            }
            v.addElement(c);
        }
        return v;
    }

    public Vector generateCommitment(Taems t) {
        CoordinateEvent ce;
        Commitment com;
        long CID;
        Vector<Object> v;
        Taems ta;
        String typeOfProtocol;
        Method m;
        ScheduleElement schElement;
        Enumeration e;
        ConsumesInterrelationship NLE;
        Vector<CoordinateEvent> commitments = new Vector<CoordinateEvent>();
        Schedule s = t.getFirstSchedule();
        Enumeration enumOfNLE = t.findNodes((Node)new ConsumesInterrelationship());
        while (enumOfNLE.hasMoreElements()) {
            NLE = (ConsumesInterrelationship)enumOfNLE.nextElement();
            e = s.getElements();
            while (e.hasMoreElements()) {
                schElement = (ScheduleElement)e.nextElement();
                m = schElement.getMethod();
                if (!NLE.getFrom().getLabel().equals(m.getLabel())) continue;
                typeOfProtocol = "";
                ta = new Taems();
                v = new Vector<Object>();
                CID = State.getRandom().nextLong();
                v.addElement(m.clone());
                com = new Commitment("Resource", NLE.getTo().getLabel(), m.getAgent(), null, v, 0, 1.0f, schElement.getStart(), this.TIMEOUT + 1, schElement.getStart() + schElement.getDuration());
                com.setQuantity(0.0f - NLE.getCost().calculateMax());
                com.setResource(NLE.getTo().getLabel());
                com.setID(CID);
                ta.addCommitment(com);
                if (NLE.getTo().getAgent() != null) {
                    typeOfProtocol = "CSharp";
                    this.log.log("Using CSharp for " + NLE.getTo().getLabel() + " (" + NLE.getTo().getAgent().getLabel() + ")", 2, this.FAC_PS);
                    com.setToAgent(NLE.getTo().getAgent());
                    ce = new CoordinateEvent(this, typeOfProtocol, 16, ta);
                    ce.setCoordinateID(CID);
                    if (this.checkForDefaultCommitment(com)) {
                        ce.setID(17);
                    } else {
                        commitments.addElement(ce);
                    }
                    this.addCoordinateEvent(schElement, ce);
                    continue;
                }
                typeOfProtocol = "DSharp";
                this.log.log("Using DSharp ...", 2, this.FAC_PS);
                com.setToAgent(new Agent("*"));
                ce = new CoordinateEvent(this, typeOfProtocol, 16, ta);
                ce.setCoordinateID(CID);
                if (this.checkForDefaultCommitment(com)) {
                    ce.setID(17);
                } else {
                    commitments.addElement(ce);
                }
                this.addCoordinateEvent(schElement, ce);
            }
        }
        enumOfNLE = t.findNodes((Node)new ProducesInterrelationship());
        while (enumOfNLE.hasMoreElements()) {
            NLE = (ProducesInterrelationship)enumOfNLE.nextElement();
            e = s.getElements();
            while (e.hasMoreElements()) {
                schElement = (ScheduleElement)e.nextElement();
                m = schElement.getMethod();
                if (!NLE.getFrom().getLabel().equals(m.getLabel())) continue;
                typeOfProtocol = "";
                ta = new Taems();
                v = new Vector();
                CID = State.getRandom().nextLong();
                v.addElement(m.clone());
                com = new Commitment("Resource", NLE.getTo().getLabel(), m.getAgent(), null, v, 0, 1.0f, schElement.getStart(), this.TIMEOUT + 1, schElement.getStart() + schElement.getDuration());
                com.setQuantity(NLE.getCost().calculateMax());
                com.setResource(NLE.getTo().getLabel());
                com.setID(CID);
                ta.addCommitment(com);
                if (NLE.getTo().getAgent() != null) {
                    typeOfProtocol = "CSharp";
                    this.log.log("Using CSharp for " + NLE.getTo().getLabel() + " (" + NLE.getTo().getAgent().getLabel() + ")", 2, this.FAC_PS);
                    com.setToAgent(NLE.getTo().getAgent());
                    ce = new CoordinateEvent(this, typeOfProtocol, 16, ta);
                    ce.setCoordinateID(CID);
                    if (this.checkForDefaultCommitment(com)) {
                        ce.setID(17);
                    } else {
                        commitments.addElement(ce);
                    }
                    this.addCoordinateEvent(schElement, ce);
                    continue;
                }
                typeOfProtocol = "DSharp";
                this.log.log("Using DSharp ...", 2, this.FAC_PS);
                com.setToAgent(new Agent("*"));
                ce = new CoordinateEvent(this, typeOfProtocol, 16, ta);
                ce.setCoordinateID(CID);
                if (this.checkForDefaultCommitment(com)) {
                    ce.setID(17);
                } else {
                    commitments.addElement(ce);
                }
                this.addCoordinateEvent(schElement, ce);
            }
        }
        this.log.log("Coordinating over " + commitments.size() + " Commitments", 2, this.FAC_PS);
        return commitments;
    }

    public void callFSMCoordinate(Vector v) {
        Enumeration enumOfCoordinateEvent = v.elements();
        if (this.fsmCoordinate != null) {
            while (enumOfCoordinateEvent.hasMoreElements()) {
                CoordinateEvent ce = (CoordinateEvent)((Object)enumOfCoordinateEvent.nextElement());
                this.startFireEvent(ce);
            }
        }
    }

    public void addCoordinateEventListener(CoordinateEventListener l) {
        this.listeners.add((AgentListener)l);
    }

    public void removeCoordinateEventListener(CoordinateEventListener l) {
        this.listeners.remove((AgentListener)l);
    }

    protected void fireEvent(AgentEvent event) {
        CoordinateEvent e = (CoordinateEvent)event;
        Enumeration enumeration = this.listeners.elements();
        this.log.log("Firing a coordinate event", 4, this.FAC_PS);
        while (enumeration.hasMoreElements()) {
            CoordinateEventListener l = (CoordinateEventListener)enumeration.nextElement();
            if (!e.isActive()) break;
            if (e.wasReceived()) {
                l.coordinateEventReceived(e);
                break;
            }
            if (!e.wasSent()) continue;
            l.coordinateEventSent(e);
            break;
        }
        if (this.log != null) {
            this.log.log((AgentEvent)e, 2, this.FAC_PS);
        }
        this.log.log("Fired a coordinate event", 5, this.FAC_PS);
    }

    public void handleAcceptation(CoordinateEvent e) {
        this.setCoordinateEvent(e, 1);
    }

    public void handleTimeout(CoordinateEvent e) {
        if (e.getFsmID() == CSharpInitiator.getFsmID() || e.getFsmID() == CSharpResponder.getFsmID()) {
            this.replaceCoordinateEvent(e);
        } else if (e.getFsmID() == DSharpInitiator.getFsmID() || e.getFsmID() == DSharpResponder.getFsmID()) {
            this.evaluateDSharpConflict(e);
        }
    }

    public void handleRejection(CoordinateEvent e) {
        this.replaceCoordinateEvent(e);
    }

    public void handlePosed(CoordinateEvent e) {
        if (e.getFsmID() == DSharpInitiator.getFsmID() || e.getFsmID() == DSharpResponder.getFsmID()) {
            this.checkForDSharpConflict(e);
        }
    }

    protected void checkForDSharpConflict(CoordinateEvent ce) {
        Enumeration e = ce.getTaems().getCommitments();
        Commitment com = (Commitment)e.nextElement();
        Commitment conflicting = this.findConflictingResource(com.getEarliestStartTime(), com.getTimeSatisfied(), com.getType());
        if (conflicting != null) {
            Taems ta = new Taems();
            ta.addCommitment(conflicting);
            CoordinateEvent ce1 = new CoordinateEvent(this, "Conflict", 16, ta);
            ce1.setCoordinateID(ce.getCoordinateID());
            this.coordinateQueue.addElement(ce1);
        }
    }

    public void evaluateDSharpConflict(CoordinateEvent ce) {
        Resource r;
        Commitment c;
        double totalInUse = 0.0;
        String resource = "";
        Vector<Commitment> newList = new Vector<Commitment>();
        Enumeration e = ce.getTaems().getCommitments();
        while (e.hasMoreElements()) {
            c = (Commitment)e.nextElement();
            newList.addElement(c);
            totalInUse = (double)c.getQuantity() + totalInUse;
            resource = c.getType();
        }
        if (newList.size() > 1 && ((totalInUse += (r = (Resource)this.conditioned.findNode(new Node(resource))).getState()) > r.getOverloadedAt() || totalInUse < r.getDepletedAt())) {
            this.log.log(" -----------> CONFLICT !!!..", 2, this.FAC_PS);
            System.err.println("totalInUse = " + totalInUse);
            System.err.println(" ressource String = " + resource);
            System.err.println(" resource r = " + r);
            System.err.println(" OverloadedAt = " + r.getOverloadedAt());
            System.err.println(" DepletedAt = " + r.getDepletedAt());
            System.err.println("totalInUse = " + totalInUse);
            e = newList.elements();
            while (e.hasMoreElements()) {
                c = (Commitment)e.nextElement();
                this.log.log("Agent : " + c.getFromAgent().getLabel() + "[" + c.getEarliestStartTime() + " - " + c.getTimeSatisfied() + "]" + " Importance = " + c.getImportance(), 2, this.FAC_PS);
            }
        }
        this.setCoordinateEvent(ce, 1);
    }

    public Commitment findConflictingResource(int start, int finish, String resource) {
        this.log.log(" Starting Conflict Detection", 2, this.FAC_PS);
        Enumeration e = this.coordinationOverSchedule.keys();
        while (e.hasMoreElements()) {
            Vector vectorCE;
            ScheduleElement schElement = (ScheduleElement)e.nextElement();
            if (start >= schElement.getFinish() || finish <= schElement.getStart() || (vectorCE = (Vector)this.coordinationOverSchedule.get(schElement)) == null) continue;
            Enumeration e1 = vectorCE.elements();
            while (e1.hasMoreElements()) {
                Enumeration e2;
                Commitment com;
                CoordinateEvent ce1 = (CoordinateEvent)((Object)e1.nextElement());
                this.log.log(" -----------> Detecting Conflict..", 2, this.FAC_PS);
                if (!ce1.getType().equals("DSharp") || !(com = (Commitment)(e2 = ce1.getTaems().getCommitments()).nextElement()).getType().equals(resource)) continue;
                return com;
            }
        }
        return null;
    }

    public void coordinateEventSent(CoordinateEvent e) {
    }

    public void coordinateEventReceived(CoordinateEvent e) {
        this.log.log("commitmentEventReceived: " + (Object)((Object)e), 3, this.FAC_PS);
        switch (e.getID()) {
            case 4096: {
                this.log.log("commitmentEventReceived REJECTED", 2, this.FAC_PS);
                this.handleRejection(e);
                break;
            }
            case 65536: {
                this.log.log("commitmentEventReceived TIMED OUT", 2, this.FAC_PS);
                this.handleTimeout(e);
                break;
            }
            case 1: {
                this.log.log("commitmentEventReceived ACCEPTED", 2, this.FAC_PS);
                this.handleAcceptation(e);
                break;
            }
            case 16: {
                this.log.log("commitmentEventReceived POSED", 2, this.FAC_PS);
                this.handlePosed(e);
                break;
            }
            case 256: {
                this.log.log("commitmentEventReceived CANCELED", 2, this.FAC_PS);
                break;
            }
            default: {
                this.log.log("commitmentEventReceived Unknown: " + e.getID(), 2, this.FAC_PS);
            }
        }
    }
}

