/*
 * Decompiled with CFR 0.152.
 */
package agent.learn;

import agent.learn.StepwiseRegressSVD;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;

public class StepwiseRegressSVDHaldTest {
    private static double[][] designmatrix;
    private static double[] qvalues;

    private static void readInValue(String filename) {
        try {
            FileReader fileIn = new FileReader(filename);
            BufferedReader in = new BufferedReader(fileIn);
            int line = 0;
            String entryline = in.readLine();
            while (entryline != null) {
                StringTokenizer s = new StringTokenizer(entryline, " ");
                Double q = new Double(s.nextToken());
                StepwiseRegressSVDHaldTest.qvalues[line] = q;
                StepwiseRegressSVDHaldTest.designmatrix[line][0] = 1.0;
                int pos = 1;
                while (s.hasMoreTokens()) {
                    Double oc = new Double(s.nextToken());
                    StepwiseRegressSVDHaldTest.designmatrix[line][pos] = oc;
                    ++pos;
                }
                entryline = in.readLine();
                ++line;
            }
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }

    public static void main(String[] args) {
        String filename = args[0];
        int vsize = new Integer(args[1]);
        int hsize = new Integer(args[2]) + 1;
        designmatrix = new double[vsize][hsize];
        qvalues = new double[vsize];
        StepwiseRegressSVDHaldTest.readInValue(filename);
        double[] sign = new double[vsize];
        int i = 0;
        while (i < vsize) {
            sign[i] = 1.0;
            ++i;
        }
        System.out.println("Design_Matrix=");
        int i2 = 0;
        while (i2 < vsize) {
            int k = 0;
            while (k < hsize) {
                System.out.println("[" + i2 + "][" + k + "]=" + designmatrix[i2][k]);
                ++k;
            }
            ++i2;
        }
        System.out.println("Qualities=");
        int i3 = 0;
        while (i3 < vsize) {
            System.out.println("q[" + i3 + "]=" + qvalues[i3]);
            ++i3;
        }
        StepwiseRegressSVD regress = new StepwiseRegressSVD(designmatrix, hsize, sign, qvalues, 1.0E-5, 0.95, 0.9);
        System.out.println("Converged=" + regress.isConverged());
        System.out.println("Coefficients=");
        double[] coef = regress.getCoefs();
        int i4 = 0;
        while (i4 < coef.length) {
            System.out.println("[" + i4 + "]=" + coef[i4]);
            ++i4;
        }
        System.out.println("ChiSquare=" + regress.getChiSquare());
        System.out.println("Fvalues=");
        int i5 = 0;
        while (i5 < coef.length) {
            System.out.println("[" + i5 + "]=" + regress.getFval(i5));
            ++i5;
        }
    }
}

