/*
 * Decompiled with CFR 0.152.
 */
package agent.learn;

import agent.learn.BetaFunct;
import agent.learn.Learning;
import agent.learn.MultiRegressSVD;

public class StepwiseRegressSVD {
    private boolean[][] occuredmatrix;
    private double[][] designmatrix;
    private double[] tvals;
    private double[] fvals;
    private double[] coefs;
    private double chisq;
    private boolean noconverged = false;
    private MultiRegressSVD finalregress;
    private boolean[] badcoefs;
    private boolean[] currentcoefs;
    private int coefnum;
    private boolean iscolinear;
    private boolean underdetermined;
    Learning learning;

    public int getCoefNum() {
        return this.coefnum;
    }

    public boolean isConverged() {
        return !this.noconverged;
    }

    public boolean isUnderdetermined() {
        return this.underdetermined;
    }

    public boolean isColinear() {
        return this.iscolinear;
    }

    public double[] getTvals() {
        return this.tvals;
    }

    public double[] getFvals() {
        return this.fvals;
    }

    public double getFval(int i) {
        return this.fvals[i];
    }

    public double[] getCoefs() {
        return this.coefs;
    }

    public double getChiSquare() {
        return this.chisq;
    }

    private int getNewIndex(boolean[] includedcoefs, int oldpos) {
        int result = oldpos;
        int i = 0;
        while (i < includedcoefs.length) {
            if (i < oldpos && !includedcoefs[i]) {
                --result;
            }
            ++i;
        }
        return result;
    }

    private int getOldIndex(boolean[] includedcoefs, int newpos) {
        int result = -1;
        int count = 0;
        int i = 0;
        while (i < includedcoefs.length) {
            if (count == newpos) {
                result = i;
            }
            if (includedcoefs[i]) {
                ++count;
            }
            ++i;
        }
        return result;
    }

    public boolean[][] modifybooleanmatrix(boolean[] includedcoefs, int count, int ydim) {
        boolean[][] retmatrix = new boolean[ydim][count];
        int newpos = 0;
        int i = 0;
        while (i < includedcoefs.length) {
            if (includedcoefs[i]) {
                int bla = 0;
                while (bla < ydim) {
                    retmatrix[bla][newpos] = this.occuredmatrix[bla][i];
                    ++bla;
                }
                ++newpos;
            }
            ++i;
        }
        return retmatrix;
    }

    public double[][] modifydoublematrix(boolean[] includedcoefs, int count, int ydim) {
        double[][] retmatrix = new double[ydim][count];
        int newpos = 0;
        int i = 0;
        while (i < includedcoefs.length) {
            if (includedcoefs[i]) {
                int bla = 0;
                while (bla < ydim) {
                    retmatrix[bla][newpos] = this.designmatrix[bla][i];
                    ++bla;
                }
                ++newpos;
            }
            ++i;
        }
        return retmatrix;
    }

    private double calcF_enter(double NleConfThresh, int v) {
        System.err.println("calcF: alpha=" + (1.0 - NleConfThresh) + " v=" + v);
        double tval = BetaFunct.InverseStudent(1.0 - NleConfThresh, 1.0E-8, 0.001, v);
        return Math.pow(tval, 2.0);
    }

    public StepwiseRegressSVD(double[][] occuredm, int ma, double[] sign, double[] b, double tolerance, double nleconfthresh, double colinthresh) {
    }

    public StepwiseRegressSVD(boolean[][] occuredm, int ma, double[] sign, double[] b, double tolerance, double nleconfthresh, double colinthresh) {
        int y;
        this.occuredmatrix = occuredm;
        this.badcoefs = new boolean[ma];
        this.currentcoefs = new boolean[ma];
        this.currentcoefs[0] = true;
        int currentlength = 1;
        MultiRegressSVD regress = null;
        boolean added = true;
        boolean dropped = true;
        int elimcount = 0;
        int lastdropped = -1;
        int lastadded = -2;
        double F_enter = 19.5;
        double F_remove = 19.4;
        if (b.length > 1) {
            int x = 1;
            while (x < ma) {
                boolean tmpmemory = this.occuredmatrix[0][x];
                boolean founddiff = false;
                y = 1;
                while (y < b.length) {
                    if (this.occuredmatrix[y][x] != tmpmemory) {
                        founddiff = true;
                    }
                    ++y;
                }
                if (!founddiff) {
                    this.badcoefs[x] = true;
                    ++elimcount;
                }
                ++x;
            }
        }
        while ((added || dropped) && lastadded != lastdropped) {
            double maxf = Double.MIN_VALUE;
            int maxcoef = -1;
            int i = 1;
            while (i < ma) {
                if (!this.badcoefs[i] && !this.currentcoefs[i]) {
                    this.currentcoefs[i] = true;
                    regress = new MultiRegressSVD(this.modifybooleanmatrix(this.currentcoefs, currentlength + 1, b.length), currentlength + 1, sign, b, tolerance);
                    this.currentcoefs[i] = false;
                    int testpos = this.getNewIndex(this.currentcoefs, i);
                    double tmpf = regress.getFval(testpos);
                    if (tmpf > maxf) {
                        maxf = tmpf;
                        maxcoef = i;
                    }
                }
                ++i;
            }
            System.err.println("F_enter=" + F_enter);
            if (maxf < F_enter) {
                added = false;
            } else {
                this.currentcoefs[maxcoef] = true;
                ++currentlength;
                added = true;
                lastadded = maxcoef;
                System.err.println("added coef " + maxcoef);
            }
            System.err.println("Regressing on ");
            int k = 0;
            while (k < ma) {
                if (this.currentcoefs[k]) {
                    regress = new MultiRegressSVD(this.modifybooleanmatrix(this.currentcoefs, currentlength, b.length), currentlength, sign, b, tolerance);
                }
                ++k;
            }
            this.noconverged = !regress.isConverged();
            dropped = false;
            i = 1;
            while (i < currentlength) {
                if (regress.getFval(i) < F_remove) {
                    dropped = true;
                    int oldpos = this.getOldIndex(this.currentcoefs, i);
                    this.badcoefs[oldpos] = true;
                    lastdropped = oldpos;
                    this.currentcoefs[oldpos] = false;
                    --currentlength;
                    System.err.println("dropped coef " + oldpos);
                }
                ++i;
            }
        }
        if (regress != null) {
            this.underdetermined = false;
            this.chisq = regress.getChiSquare();
            this.coefnum = currentlength;
            this.coefs = new double[ma];
            this.fvals = new double[ma];
            this.tvals = new double[ma];
            int i = 0;
            while (i < ma) {
                if (this.currentcoefs[i]) {
                    int testpos = this.getNewIndex(this.currentcoefs, i);
                    this.tvals[i] = regress.getTval(testpos);
                    this.fvals[i] = regress.getFval(testpos);
                    this.coefs[i] = regress.getCoef(testpos);
                } else {
                    this.tvals[i] = 0.0;
                    this.fvals[i] = 0.0;
                    this.coefs[i] = 0.0;
                }
                ++i;
            }
            double[][] covarma = regress.getCovariance();
            this.iscolinear = false;
            int x = 0;
            while (x < this.coefnum) {
                y = 0;
                while (y < this.coefnum) {
                    if (covarma[x][y] > colinthresh && x != y) {
                        this.iscolinear = true;
                    }
                    ++y;
                }
                ++x;
            }
        } else {
            this.underdetermined = true;
            this.coefs = new double[ma];
            this.fvals = new double[ma];
            this.tvals = new double[ma];
            int i = 0;
            while (i < ma) {
                this.tvals[i] = 0.0;
                this.fvals[i] = 0.0;
                this.coefs[i] = 1.0;
                ++i;
            }
        }
    }
}

