/*
 * Decompiled with CFR 0.152.
 */
package agent.learn;

import agent.learn.BetaFunct;
import agent.learn.Dists;
import agent.learn.GammaFunct;
import agent.learn.LDist;
import agent.learn.LearnControl;
import agent.learn.LearnPropertyEventHandler;
import agent.learn.Learning;
import agent.learn.Nles;
import agent.learn.ScheduleDB;
import agent.learn.ScheduleObj;
import agent.learn.StepwiseRegressSVD;
import agent.learn.ToolsLearning;
import agent.simplest.GenericPointer;
import agent.simplest.Log;
import agent.simplest.State;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class SoftRelationLearning
implements Serializable {
    Dists unaffectdist_DB;
    Nles nles_DB;
    ScheduleDB scheduleDB;
    ScheduleDB cleanscheduleDB;
    LearnControl learnControl;
    Double Regress_TOL;
    ToolsLearning toolsLearn;
    LearnPropertyEventHandler learnPropHandler;
    GenericPointer NleConfThresh;
    boolean SoftRelSourceDependent;
    protected Log log;
    protected int FAC_LEARN = Learning.FAC_LEARN;
    private Hashtable matrixDB;
    private Hashtable valueDB;
    int[] howmanylines;
    int hsize;

    public void Instantiate(Nles in_nles_DB, Dists in_unaffectdist_DB, ScheduleDB in_scheduleDB, ScheduleDB in_cleanscheduleDB, Double in_Regress_TOL, GenericPointer in_NleConfThresh, boolean in_SoftRelSourceDependent, ToolsLearning in_toolsLearn, LearnControl in_learnControl, LearnPropertyEventHandler in_learnPropHandler) {
        this.nles_DB = in_nles_DB;
        this.unaffectdist_DB = in_unaffectdist_DB;
        this.learnControl = in_learnControl;
        this.scheduleDB = in_scheduleDB;
        this.cleanscheduleDB = in_cleanscheduleDB;
        this.toolsLearn = in_toolsLearn;
        this.Regress_TOL = in_Regress_TOL;
        this.learnPropHandler = in_learnPropHandler;
        this.NleConfThresh = in_NleConfThresh;
        this.SoftRelSourceDependent = in_SoftRelSourceDependent;
        this.log = (Log)State.findComponent((String)"Log");
        this.FAC_LEARN = Learning.FAC_LEARN;
    }

    private void convertData() {
        int ssize = this.scheduleDB.size();
        Vector allmethods = this.learnPropHandler.getAllMethods();
        Vector localmethods = this.learnPropHandler.getLocalMethods();
        int howmanymethods = allmethods.size();
        int[] howmanynonzero = new int[howmanymethods];
        int k = 0;
        while (k < this.cleanscheduleDB.size()) {
            Vector tmpsched = (Vector)this.cleanscheduleDB.elementAt(k);
            int j = 0;
            while (j < tmpsched.size()) {
                ScheduleObj tmpmeth = (ScheduleObj)tmpsched.elementAt(j);
                int n = allmethods.indexOf(tmpmeth.getName());
                howmanynonzero[n] = howmanynonzero[n] + 1;
                ++j;
            }
            ++k;
        }
        int vsize = this.cleanscheduleDB.size();
        this.hsize = howmanymethods - 1 + 1;
        this.log.log("hsize=" + this.hsize + ", vsize=" + vsize, 5, this.FAC_LEARN);
        this.log.log("cschedule=" + this.cleanscheduleDB, 5, this.FAC_LEARN);
        this.log.log("learnPropHandler.getAllMethods()=" + allmethods, 5, this.FAC_LEARN);
        int ul = 0;
        while (ul < howmanymethods) {
            this.log.log("Howmanyzero[" + ul + "]=" + howmanynonzero[ul], 5, this.FAC_LEARN);
            ++ul;
        }
        Enumeration e2 = localmethods.elements();
        while (e2.hasMoreElements()) {
            String name = (String)e2.nextElement();
            int tmpvsize = howmanynonzero[allmethods.indexOf(name)];
            boolean[][] tmpma = new boolean[tmpvsize][this.hsize];
            int i = 0;
            while (i < tmpvsize) {
                tmpma[i][0] = true;
                ++i;
            }
            this.matrixDB.put(name, tmpma);
        }
        this.howmanylines = new int[howmanymethods];
        int i = 0;
        while (i < vsize) {
            Vector tmpsched = (Vector)this.cleanscheduleDB.elementAt(i);
            int tmpschedsize = tmpsched.size();
            int k2 = 0;
            while (k2 < tmpschedsize) {
                ScheduleObj tmpmeth = (ScheduleObj)tmpsched.elementAt(k2);
                Vector<ScheduleObj> valuevec = (Vector<ScheduleObj>)this.valueDB.get(tmpmeth.getName());
                if (valuevec == null) {
                    valuevec = new Vector<ScheduleObj>(this.scheduleDB.getWindowSize());
                    this.valueDB.put(tmpmeth.getName(), valuevec);
                }
                if (this.SoftRelSourceDependent) {
                    ScheduleObj transformed = new ScheduleObj(tmpmeth.getName(), tmpmeth.getQuality(), tmpmeth.getCost(), tmpmeth.getDuration(), tmpmeth.getStart(), tmpmeth.getFinish(), tmpmeth.isSelfExecuted());
                    double qlog = 0.0;
                    double clog = 0.0;
                    double dlog = 0.0;
                    int m = 0;
                    while (m < k2) {
                        ScheduleObj totransform = (ScheduleObj)tmpsched.elementAt(m);
                        qlog += Math.log(totransform.getQuality());
                        clog += Math.log(totransform.getCost());
                        dlog += Math.log(totransform.getDuration());
                        ++m;
                    }
                    qlog = tmpmeth.getQuality() - qlog;
                    clog = tmpmeth.getCost() - clog;
                    dlog = tmpmeth.getDuration() - dlog;
                    transformed.setQuality(qlog);
                    transformed.setCost(clog);
                    transformed.setDuration(dlog);
                    valuevec.addElement(transformed);
                } else {
                    valuevec.addElement(tmpmeth);
                }
                int n = allmethods.indexOf(tmpmeth.getName());
                this.howmanylines[n] = this.howmanylines[n] + 1;
                this.log.log("Method[" + i + "][" + k2 + "]=" + tmpmeth.getName(), 5, this.FAC_LEARN);
                int setindex = allmethods.indexOf(tmpmeth.getName());
                int l = k2 + 1;
                while (l < tmpschedsize) {
                    ScheduleObj meth = (ScheduleObj)tmpsched.elementAt(l);
                    boolean[][] Matrix = (boolean[][])this.matrixDB.get(meth.getName());
                    int methindex = allmethods.indexOf(meth.getName());
                    if (setindex < methindex) {
                        Matrix[this.howmanylines[methindex]][setindex + 1] = true;
                    } else {
                        Matrix[this.howmanylines[methindex]][setindex] = true;
                    }
                    ++l;
                }
                ++k2;
            }
            ++i;
        }
    }

    private void makeRegression(String methodname, int kind, double nleconfthresh, Vector coefvec, Vector bvec, boolean[] converged, boolean[] underdetermined, boolean[] colinear, double[] chisign) {
        int methodpos_allmethods = this.learnPropHandler.getAllMethods().indexOf(methodname);
        Vector valuevec = (Vector)this.valueDB.get(methodname);
        if (valuevec != null && valuevec.size() > 0) {
            this.log.log("multiple regression for m=" + methodname, 0, this.FAC_LEARN);
            double[] val_vector = new double[valuevec.size()];
            int k = 0;
            while (k < valuevec.size()) {
                ScheduleObj so = (ScheduleObj)valuevec.elementAt(k);
                val_vector[k] = Math.log(so.getValue(kind));
                ++k;
            }
            boolean[][] ocma = (boolean[][])this.matrixDB.get(methodname);
            int tmpvsize = this.howmanylines[methodpos_allmethods];
            double[] sign = new double[tmpvsize];
            int i = 0;
            while (i < tmpvsize) {
                sign[i] = 1.0;
                ++i;
            }
            this.log.log("Occured_Matrix for" + methodname, 5, this.FAC_LEARN);
            int i2 = 0;
            while (i2 < tmpvsize) {
                String result = val_vector[i2] + " ";
                int k2 = 0;
                while (k2 < this.hsize) {
                    result = ocma[i2][k2] ? result + " 1" : result + " 0";
                    ++k2;
                }
                this.log.log(result, 5, this.FAC_LEARN);
                ++i2;
            }
            this.log.log("Regressing m=" + methodname + " for QUALITY", 5, this.FAC_LEARN);
            StepwiseRegressSVD regress = new StepwiseRegressSVD(ocma, this.hsize, sign, val_vector, (double)this.Regress_TOL, nleconfthresh, 0.9);
            colinear[kind] = regress.isColinear();
            underdetermined[kind] = regress.isUnderdetermined();
            converged[kind] = regress.isConverged();
            int coefnum = regress.getCoefNum();
            double[] coef = regress.getCoefs();
            int i3 = 0;
            while (i3 < this.hsize) {
                coef[i3] = Math.pow(Math.E, coef[i3]);
                ++i3;
            }
            coefvec.setElementAt(coef, kind);
            double[] fvals = regress.getFvals();
            double[] tvals = regress.getTvals();
            double[] beta = new double[this.hsize];
            int i4 = 0;
            while (i4 < this.hsize) {
                if (Math.abs(tvals[i4]) > 0.0) {
                    Double tmp = BetaFunct.Student(tvals[i4], tmpvsize - 1);
                    if (tmp == null) {
                        this.log.log("Error in calculating Student'sche Distribution", 0, this.FAC_LEARN);
                    }
                    beta[i4] = 1.0 - tmp;
                } else {
                    beta[i4] = 0.0;
                }
                ++i4;
            }
            bvec.setElementAt(beta, kind);
            chisign[kind] = 1.0;
            if (tmpvsize > this.hsize) {
                chisign[kind] = GammaFunct.getGammaQ((double)(tmpvsize - this.hsize) / 2.0, regress.getChiSquare());
            }
            this.log.log("ChiSquare=" + regress.getChiSquare() + ", sign=" + chisign[kind], 5, this.FAC_LEARN);
            this.log.log("REGRESSION DONE", 0, this.FAC_LEARN);
            this.log.log("---------------", 0, this.FAC_LEARN);
        } else {
            this.log.log("multiple regression for m =" + methodname + " not possible: NO DATA", 0, this.FAC_LEARN);
        }
    }

    private void decideOnResult(String methodname, Vector coefvec, Vector bvec, boolean[] converged, boolean[] underdetermined, boolean[] colinear, double[] chisign) {
        if (converged[0] && !colinear[0] && !underdetermined[0]) {
            int methodpos_allmethods = this.learnPropHandler.getAllMethods().indexOf(methodname);
            int j = 1;
            while (j < this.hsize) {
                String sourcemeth = "";
                sourcemeth = j <= methodpos_allmethods && j - 1 >= 0 ? (String)this.learnPropHandler.getAllMethods().elementAt(j - 1) : (String)this.learnPropHandler.getAllMethods().elementAt(j);
                LDist powerdist = (LDist)this.nles_DB.getVectorPos(methodname, sourcemeth, "softrel", 2);
                if (powerdist != null) {
                    boolean changed = false;
                    int k = 0;
                    while (k < 3) {
                        Vector tmpvec = powerdist.getDataDist(k);
                        double val = (Double)tmpvec.elementAt(0);
                        double conf = (Double)tmpvec.elementAt(1);
                        if (coefvec.elementAt(k) != null) {
                            double[] tmpcoef = (double[])coefvec.elementAt(k);
                            double[] tmpbeta = (double[])bvec.elementAt(k);
                            if (val != tmpcoef[j] || conf != tmpbeta[j]) {
                                changed = true;
                            }
                        }
                        ++k;
                    }
                    if (changed) {
                        double maxval;
                        LDist effectordist;
                        changed = false;
                        double valq = -1.0;
                        double valc = -1.0;
                        double vald = -1.0;
                        double confq = -1.0;
                        double confc = -1.0;
                        double confd = -1.0;
                        if (coefvec.elementAt(0) != null) {
                            valq = ((double[])coefvec.elementAt(0))[j];
                            confq = ((double[])bvec.elementAt(0))[j];
                            if (this.SoftRelSourceDependent && (effectordist = (LDist)this.unaffectdist_DB.get(sourcemeth)) != null && (maxval = effectordist.getMax(0)) > 0.0) {
                                valq /= maxval;
                            }
                        }
                        if (coefvec.elementAt(1) != null) {
                            valc = ((double[])coefvec.elementAt(1))[j];
                            confc = ((double[])bvec.elementAt(1))[j];
                            if (this.SoftRelSourceDependent && (effectordist = (LDist)this.unaffectdist_DB.get(sourcemeth)) != null && (maxval = effectordist.getMax(1)) > 0.0) {
                                valc /= maxval;
                            }
                        }
                        if (coefvec.elementAt(2) != null) {
                            vald = ((double[])coefvec.elementAt(2))[j];
                            confd = ((double[])bvec.elementAt(2))[j];
                            if (this.SoftRelSourceDependent && (effectordist = (LDist)this.unaffectdist_DB.get(sourcemeth)) != null && (maxval = effectordist.getMax(2)) > 0.0) {
                                vald /= maxval;
                            }
                        }
                        LDist newpowerdist = new LDist("", 3, new Double(valq), new Double(valc), new Double(vald));
                        newpowerdist.addElement(new Double(confq), new Double(confc), new Double(confd));
                        newpowerdist.addElement(new Double(chisign[0]), new Double(chisign[1]), new Double(chisign[2]));
                        this.nles_DB.setVectorPos(methodname, sourcemeth, "softrel", 1, new Double(Math.max(Math.max(confq, confc), confd)));
                        this.nles_DB.setVectorPos(methodname, sourcemeth, "softrel", 2, newpowerdist);
                    }
                }
                ++j;
            }
        } else {
            this.log.log("Sorry: No regression possible for " + methodname + " : converged=" + converged[0] + " colinear=" + colinear[0] + " underdetermined=" + underdetermined[0], 5, this.FAC_LEARN);
        }
    }

    public void update(Vector lastschedule) {
        this.log.log("SOFT RELATIONSHIP LEARNING", 5, this.FAC_LEARN);
        this.log.log("--------------------------", 5, this.FAC_LEARN);
        Vector localmethods = this.learnPropHandler.getLocalMethods();
        double nleconfthresh = (Double)this.NleConfThresh.obj;
        int methodnum = this.learnPropHandler.getLocalMethods().size();
        this.matrixDB = new Hashtable(2 * methodnum);
        this.valueDB = new Hashtable(2 * methodnum);
        this.convertData();
        int methodpos = 0;
        while (methodpos < localmethods.size()) {
            String methodname = (String)localmethods.elementAt(methodpos);
            Vector coefvec = new Vector(3);
            Vector bvec = new Vector(3);
            boolean[] converged = new boolean[3];
            boolean[] underdetermined = new boolean[3];
            boolean[] colinear = new boolean[3];
            double[] chisign = new double[3];
            coefvec.setSize(3);
            bvec.setSize(3);
            this.makeRegression(methodname, 0, nleconfthresh, coefvec, bvec, converged, underdetermined, colinear, chisign);
            this.decideOnResult(methodname, coefvec, bvec, converged, underdetermined, colinear, chisign);
            ++methodpos;
        }
        this.matrixDB = null;
        this.valueDB = null;
    }
}

