/*
 * Decompiled with CFR 0.152.
 */
package agent.learn;

public class MultiRegressSVD {
    private double TOL = 1.0E-5;
    private boolean[][] occuredmatrix;
    private double[][] designmatrix;
    private double chisq;
    private double MSE;
    private double[] tvalues;
    private double[] fvalues;
    private double[] coefs;
    private double[][] covariance;
    private boolean noconverged = false;
    private int coefnum;

    public double[] getCoefs() {
        return this.coefs;
    }

    public int getCoefNum() {
        return this.coefnum;
    }

    public double getCoef(int pos) {
        return this.coefs[pos];
    }

    public double getFval(int coef) {
        return this.fvalues[coef];
    }

    public double[] getFvals() {
        return this.fvalues;
    }

    public double getTval(int coef) {
        return this.tvalues[coef];
    }

    public double[] getTvals() {
        return this.tvalues;
    }

    public double getMSE() {
        return this.MSE;
    }

    public double getChiSquare() {
        return this.chisq;
    }

    public double[][] getCovariance() {
        return this.covariance;
    }

    public boolean isConverged() {
        return !this.noconverged;
    }

    public MultiRegressSVD(double[][] designm, int ma, double[] sign, double[] b, double tolerance) {
    }

    public MultiRegressSVD(boolean[][] occuredm, int ma, double[] sign, double[] b, double tolerance) {
        this.occuredmatrix = occuredm;
        this.TOL = tolerance;
        this.coefs = new double[ma];
        this.covariance = new double[ma][ma];
        double[][] u = new double[b.length][ma];
        double[][] v = new double[ma][ma];
        double[] w = new double[ma];
        this.svdfit(b, sign, b.length, this.coefs, ma, u, v, w);
        this.svdvar(v, ma, w, this.covariance);
        this.MSE = this.chisq / (double)(b.length - ma);
        this.tvalues = new double[ma];
        this.fvalues = new double[ma];
        int i = 0;
        while (i < ma) {
            this.tvalues[i] = this.coefs[i] / Math.sqrt(this.MSE * this.covariance[i][i]);
            this.fvalues[i] = Math.pow(this.tvalues[i], 2.0);
            ++i;
        }
    }

    private double afunc(int x, int y) {
        if (this.occuredmatrix[x][y]) {
            return 1.0;
        }
        return 0.0;
    }

    private void svdfit(double[] y, double[] sig, int ndata, double[] a, int ma, double[][] u, double[][] v, double[] w) {
        int j;
        double[] b = new double[ndata];
        int i = 0;
        while (i < ndata) {
            double tmp = 1.0 / sig[i];
            j = 0;
            while (j < ma) {
                u[i][j] = this.afunc(i, j) * tmp;
                ++j;
            }
            b[i] = y[i] * tmp;
            ++i;
        }
        this.svdcmp(u, ndata, ma, w, v);
        double wmax = 0.0;
        j = 0;
        while (j < ma) {
            if (w[j] > wmax) {
                wmax = w[j];
            }
            ++j;
        }
        double thresh = this.TOL * wmax;
        j = 0;
        while (j < ma) {
            if (w[j] < thresh) {
                w[j] = 0.0;
            }
            ++j;
        }
        this.svbksb(u, w, v, ndata, ma, b, a);
        this.chisq = 0.0;
        i = 0;
        while (i < ndata) {
            double sum = 0.0;
            j = 0;
            while (j < ma) {
                sum += a[j] * this.afunc(i, j);
                ++j;
            }
            this.chisq += Math.pow((y[i] - sum) / sig[i], 2.0);
            ++i;
        }
    }

    private void svbksb(double[][] u, double[] w, double[][] v, int m, int n, double[] b, double[] x) {
        double s;
        double[] tmp = new double[n];
        int j = 0;
        while (j < n) {
            s = 0.0;
            if (w[j] != 0.0) {
                int i = 0;
                while (i < m) {
                    s += u[i][j] * b[i];
                    ++i;
                }
                s /= w[j];
            }
            tmp[j] = s;
            ++j;
        }
        j = 0;
        while (j < n) {
            s = 0.0;
            int jj = 0;
            while (jj < n) {
                s += v[j][jj] * tmp[jj];
                ++jj;
            }
            x[j] = s;
            ++j;
        }
    }

    private void svdcmp(double[][] a, int m, int n, double[] w, double[][] v) {
        int j;
        double h;
        double f;
        int k;
        double s;
        int l = 0;
        int nm = 0;
        double[] rv1 = new double[n];
        double anorm = 0.0;
        double scale = 0.0;
        double g = 0.0;
        int i = 0;
        while (i < n) {
            l = i + 1;
            rv1[i] = scale * g;
            scale = 0.0;
            s = 0.0;
            g = 0.0;
            if (i < m) {
                k = i;
                while (k < m) {
                    scale += Math.abs(a[k][i]);
                    ++k;
                }
                if (scale != 0.0) {
                    k = i;
                    while (k < m) {
                        double[] dArray = a[k];
                        int n2 = i;
                        dArray[n2] = dArray[n2] / scale;
                        s += a[k][i] * a[k][i];
                        ++k;
                    }
                    f = a[i][i];
                    g = -this.SIGN(Math.sqrt(s), f);
                    h = f * g - s;
                    a[i][i] = f - g;
                    j = l;
                    while (j < n) {
                        s = 0.0;
                        k = i;
                        while (k < m) {
                            s += a[k][i] * a[k][j];
                            ++k;
                        }
                        f = s / h;
                        k = i;
                        while (k < m) {
                            double[] dArray = a[k];
                            int n3 = j;
                            dArray[n3] = dArray[n3] + f * a[k][i];
                            ++k;
                        }
                        ++j;
                    }
                    k = i;
                    while (k < m) {
                        double[] dArray = a[k];
                        int n4 = i;
                        dArray[n4] = dArray[n4] * scale;
                        ++k;
                    }
                }
            }
            w[i] = scale * g;
            scale = 0.0;
            s = 0.0;
            g = 0.0;
            if (i < m && i != n - 1) {
                k = l;
                while (k < n) {
                    scale += Math.abs(a[i][k]);
                    ++k;
                }
                if (scale != 0.0) {
                    k = l;
                    while (k < n) {
                        double[] dArray = a[i];
                        int n5 = k;
                        dArray[n5] = dArray[n5] / scale;
                        s += a[i][k] * a[i][k];
                        ++k;
                    }
                    f = a[i][l];
                    g = -this.SIGN(Math.sqrt(s), f);
                    h = f * g - s;
                    a[i][l] = f - g;
                    k = l;
                    while (k < n) {
                        rv1[k] = a[i][k] / h;
                        ++k;
                    }
                    j = l;
                    while (j < m) {
                        s = 0.0;
                        k = l;
                        while (k < n) {
                            s += a[j][k] * a[i][k];
                            ++k;
                        }
                        k = l;
                        while (k < n) {
                            double[] dArray = a[j];
                            int n6 = k;
                            dArray[n6] = dArray[n6] + s * rv1[k];
                            ++k;
                        }
                        ++j;
                    }
                    k = l;
                    while (k < n) {
                        double[] dArray = a[i];
                        int n7 = k++;
                        dArray[n7] = dArray[n7] * scale;
                    }
                }
            }
            anorm = this.FMAX(anorm, Math.abs(w[i]) + Math.abs(rv1[i]));
            ++i;
        }
        i = n - 1;
        while (i >= 0) {
            if (i < n - 1) {
                if (g != 0.0) {
                    j = l;
                    while (j < n) {
                        v[j][i] = a[i][j] / a[i][l] / g;
                        ++j;
                    }
                    j = l;
                    while (j < n) {
                        s = 0.0;
                        k = l;
                        while (k < n) {
                            s += a[i][k] * v[k][j];
                            ++k;
                        }
                        k = l;
                        while (k < n) {
                            double[] dArray = v[k];
                            int n8 = j;
                            dArray[n8] = dArray[n8] + s * v[k][i];
                            ++k;
                        }
                        ++j;
                    }
                }
                j = l;
                while (j < n) {
                    v[j][i] = 0.0;
                    v[i][j] = 0.0;
                    ++j;
                }
            }
            v[i][i] = 1.0;
            g = rv1[i];
            l = i--;
        }
        i = this.IMIN(m, n) - 1;
        while (i >= 0) {
            l = i + 1;
            g = w[i];
            j = l;
            while (j < n) {
                a[i][j] = 0.0;
                ++j;
            }
            if (g != 0.0) {
                g = 1.0 / g;
                j = l;
                while (j < n) {
                    s = 0.0;
                    k = l;
                    while (k < m) {
                        s += a[k][i] * a[k][j];
                        ++k;
                    }
                    f = s / a[i][i] * g;
                    k = i;
                    while (k < m) {
                        double[] dArray = a[k];
                        int n9 = j;
                        dArray[n9] = dArray[n9] + f * a[k][i];
                        ++k;
                    }
                    ++j;
                }
                j = i;
                while (j < m) {
                    double[] dArray = a[j];
                    int n10 = i;
                    dArray[n10] = dArray[n10] * g;
                    ++j;
                }
            } else {
                j = i;
                while (j < m) {
                    a[j][i] = 0.0;
                    ++j;
                }
            }
            double[] dArray = a[i];
            int n11 = i--;
            dArray[n11] = dArray[n11] + 1.0;
        }
        k = n - 1;
        while (k >= 0) {
            int its = 0;
            while (its <= 29) {
                double z;
                double y;
                double c;
                boolean flag = true;
                l = k;
                while (l >= 0) {
                    nm = l - 1;
                    if (Math.abs(rv1[l]) + anorm == anorm) {
                        flag = false;
                        break;
                    }
                    if (Math.abs(w[nm]) + anorm == anorm) break;
                    --l;
                }
                if (flag) {
                    c = 0.0;
                    s = 1.0;
                    i = l;
                    while (i <= k) {
                        f = s * rv1[i];
                        rv1[i] = c * rv1[i];
                        if (Math.abs(f) + anorm == anorm) break;
                        g = w[i];
                        w[i] = h = this.pythag(f, g);
                        h = 1.0 / h;
                        c = g * h;
                        s = -f * h;
                        j = 0;
                        while (j < m) {
                            y = a[j][nm];
                            z = a[j][i];
                            a[j][nm] = y * c + z * s;
                            a[j][i] = z * c - y * s;
                            ++j;
                        }
                        ++i;
                    }
                }
                z = w[k];
                if (l == k) {
                    if (!(z < 0.0)) break;
                    w[k] = -z;
                    j = 0;
                    while (j < n) {
                        v[j][k] = -v[j][k];
                        ++j;
                    }
                    break;
                }
                if (its == 29) {
                    this.noconverged = true;
                }
                double x = w[l];
                nm = k - 1;
                y = w[nm];
                g = rv1[nm];
                h = rv1[k];
                f = ((y - z) * (y + z) + (g - h) * (g + h)) / (2.0 * h * y);
                g = this.pythag(f, 1.0);
                f = ((x - z) * (x + z) + h * (y / (f + this.SIGN(g, f)) - h)) / x;
                s = 1.0;
                c = 1.0;
                j = l;
                while (j <= nm) {
                    i = j + 1;
                    g = rv1[i];
                    y = w[i];
                    h = s * g;
                    g = c * g;
                    rv1[j] = z = this.pythag(f, h);
                    c = f / z;
                    s = h / z;
                    f = x * c + g * s;
                    g = g * c - x * s;
                    h = y * s;
                    y *= c;
                    int jj = 0;
                    while (jj < n) {
                        x = v[jj][j];
                        z = v[jj][i];
                        v[jj][j] = x * c + z * s;
                        v[jj][i] = z * c - x * s;
                        ++jj;
                    }
                    w[j] = z = this.pythag(f, h);
                    if (z != 0.0) {
                        z = 1.0 / z;
                        c = f * z;
                        s = h * z;
                    }
                    f = c * g + s * y;
                    x = c * y - s * g;
                    jj = 0;
                    while (jj < m) {
                        y = a[jj][j];
                        z = a[jj][i];
                        a[jj][j] = y * c + z * s;
                        a[jj][i] = z * c - y * s;
                        ++jj;
                    }
                    ++j;
                }
                rv1[l] = 0.0;
                rv1[k] = f;
                w[k] = x;
                ++its;
            }
            --k;
        }
    }

    private double pythag(double a, double b) {
        double absb;
        double absa = Math.abs(a);
        if (absa > (absb = Math.abs(b))) {
            return absa * Math.sqrt(1.0 + Math.pow(absb / absa, 2.0));
        }
        if (absb == 0.0) {
            return 0.0;
        }
        return absb * Math.sqrt(1.0 + Math.pow(absa / absb, 2.0));
    }

    private double SIGN(double a, double b) {
        if (b > 0.0) {
            return Math.abs(a);
        }
        return -Math.abs(a);
    }

    private int IMIN(int a, int b) {
        if (a < b) {
            return a;
        }
        return b;
    }

    private double FMAX(double a, double b) {
        if (a > b) {
            return a;
        }
        return b;
    }

    private void svdvar(double[][] v, int ma, double[] w, double[][] cvm) {
        double[] wti = new double[ma];
        int i = 0;
        while (i < ma) {
            wti[i] = 0.0;
            if (w[i] != 0.0) {
                wti[i] = 1.0 / (w[i] * w[i]);
            }
            ++i;
        }
        i = 0;
        while (i < ma) {
            int j = 0;
            while (j <= i) {
                double sum = 0.0;
                int k = 0;
                while (k < ma) {
                    sum += v[i][k] * v[j][k] * wti[k];
                    ++k;
                }
                double d = sum;
                cvm[i][j] = d;
                cvm[j][i] = d;
                ++j;
            }
            ++i;
        }
    }
}

