/*
 * Decompiled with CFR 0.152.
 */
package agent.learn;

import agent.learn.MultiRegressGauss;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;

public class MultiRegressGaussTest {
    private static boolean[][] occuredmatrix;
    private static double[] qvalues;

    private static void readInValue(String filename) {
        try {
            FileReader fileIn = new FileReader(filename);
            BufferedReader in = new BufferedReader(fileIn);
            int line = 0;
            String entryline = in.readLine();
            while (entryline != null) {
                StringTokenizer s = new StringTokenizer(entryline, " ");
                Double q = new Double(s.nextToken());
                MultiRegressGaussTest.qvalues[line] = Math.log(q);
                MultiRegressGaussTest.occuredmatrix[line][0] = true;
                int pos = 1;
                while (s.hasMoreTokens()) {
                    Integer oc = new Integer(s.nextToken());
                    if (oc == 1) {
                        MultiRegressGaussTest.occuredmatrix[line][pos] = true;
                    }
                    ++pos;
                }
                entryline = in.readLine();
                ++line;
            }
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }

    public static void main(String[] args) {
        String filename = args[0];
        int vsize = new Integer(args[1]);
        int hsize = new Integer(args[2]) + 1;
        occuredmatrix = new boolean[vsize][hsize];
        qvalues = new double[vsize];
        MultiRegressGaussTest.readInValue(filename);
        double[] sign = new double[vsize];
        boolean[] incl = new boolean[hsize];
        int i = 0;
        while (i < vsize) {
            sign[i] = 1.0;
            ++i;
        }
        int i2 = 0;
        while (i2 < hsize) {
            incl[i2] = true;
            ++i2;
        }
        System.out.println(Math.abs(-2.4));
        System.out.println("Occured_Matrix=");
        int i3 = 0;
        while (i3 < vsize) {
            int k = 0;
            while (k < hsize) {
                System.out.println("[" + i3 + "][" + k + "]=" + occuredmatrix[i3][k]);
                ++k;
            }
            ++i3;
        }
        System.out.println("Quality_vector=");
        int i4 = 0;
        while (i4 < vsize) {
            System.out.println("q[" + i4 + "]=" + qvalues[i4]);
            ++i4;
        }
        MultiRegressGauss regress = new MultiRegressGauss(occuredmatrix, hsize, sign, qvalues, incl);
        System.out.println("Singular=" + regress.isSingular());
        System.out.println("Coefficients=");
        double[] coef = regress.getCoefs();
        int i5 = 0;
        while (i5 < hsize) {
            System.out.println("[" + i5 + "]=" + coef[i5]);
            ++i5;
        }
        System.out.println("ChiSquare=" + regress.getChiSquare());
        double[][] cova = regress.getCovariance();
        System.out.println("Covariance=");
        int i6 = 0;
        while (i6 < hsize) {
            int k = 0;
            while (k < hsize) {
                System.out.println("[" + i6 + "][" + k + "]=" + cova[i6][k]);
                ++k;
            }
            ++i6;
        }
    }
}

