/*
 * Decompiled with CFR 0.152.
 */
package agent.learn;

public class MultiRegressGauss {
    private boolean[][] occuredmatrix = null;
    private double chisq;
    private double MSE;
    private double[] tvalues;
    private double[] fvalues;
    private double[] coefs;
    private double[][] covariance;
    private boolean singular = false;

    public double[] getCoefs() {
        return this.coefs;
    }

    public double getChiSquare() {
        return this.chisq;
    }

    public double[][] getCovariance() {
        return this.covariance;
    }

    public boolean isSingular() {
        return this.singular;
    }

    public double getCoef(int pos) {
        return this.coefs[pos];
    }

    public double getFval(int coef) {
        return this.fvalues[coef];
    }

    public double getTval(int coef) {
        return this.tvalues[coef];
    }

    public MultiRegressGauss(boolean[][] occuredm, int ma, double[] sign, double[] b, boolean[] include) {
        this.occuredmatrix = occuredm;
        System.err.println("designmatrix=" + this.occuredmatrix);
        this.coefs = new double[ma];
        this.covariance = new double[ma][ma];
        this.lfit(b, sign, b.length, this.coefs, include, ma, this.covariance);
        this.MSE = this.chisq / (double)(b.length - ma);
        this.tvalues = new double[ma];
        this.fvalues = new double[ma];
        int i = 0;
        while (i < ma) {
            this.tvalues[i] = this.coefs[i] / Math.sqrt(this.MSE * this.covariance[i][i]);
            this.fvalues[i] = Math.pow(this.tvalues[i], 2.0);
            ++i;
        }
    }

    private void funcs(int x, double[] vec, int ma) {
        int k = 0;
        while (k < ma) {
            vec[k] = this.occuredmatrix[x][k] ? 1.0 : 0.0;
            ++k;
        }
    }

    private void lfit(double[] y, double[] sig, int ndat, double[] a, boolean[] ia, int ma, double[][] covar) {
        int mfit = 0;
        double[][] beta = new double[ma][1];
        double[] afunc = new double[ma];
        int j = 0;
        while (j < ma) {
            if (ia[j]) {
                ++mfit;
            }
            ++j;
        }
        if (mfit != 0) {
            int l;
            int k;
            j = 0;
            while (j < mfit) {
                k = 0;
                while (k < mfit) {
                    covar[j][k] = 0.0;
                    ++k;
                }
                beta[j][0] = 0.0;
                ++j;
            }
            int i = 0;
            while (i < ndat) {
                this.funcs(i, afunc, ma);
                double ym = y[i];
                if (mfit < ma) {
                    j = 0;
                    while (j < ma) {
                        if (!ia[j]) {
                            ym -= a[j] * afunc[j];
                        }
                        ++j;
                    }
                }
                double sig2i = 1.0;
                j = -1;
                l = 0;
                while (l < ma) {
                    if (ia[l]) {
                        double wt = afunc[l] * sig2i;
                        ++j;
                        k = -1;
                        int m = 0;
                        while (m <= l) {
                            if (ia[m]) {
                                double[] dArray = covar[j];
                                int n = ++k;
                                dArray[n] = dArray[n] + wt * afunc[m];
                            }
                            ++m;
                        }
                        double[] dArray = beta[j];
                        dArray[0] = dArray[0] + ym * wt;
                    }
                    ++l;
                }
                ++i;
            }
            j = 1;
            while (j < mfit) {
                k = 0;
                while (k < j) {
                    covar[k][j] = covar[j][k];
                    ++k;
                }
                ++j;
            }
            j = 0;
            while (j < mfit) {
                k = 0;
                while (k < mfit) {
                    j = 0;
                    while (j < mfit) {
                        this.gaussj(covar, mfit, beta, 1);
                        ++j;
                    }
                    ++k;
                }
                ++j;
            }
            j = -1;
            l = 0;
            while (l < ma) {
                if (ia[l]) {
                    a[l] = beta[++j][0];
                }
                ++l;
            }
            this.chisq = 0.0;
            i = 0;
            while (i < ndat) {
                this.funcs(i, afunc, ma);
                double sum = 0.0;
                j = 0;
                while (j < ma) {
                    sum += a[j] * afunc[j];
                    ++j;
                }
                this.chisq += Math.pow((y[i] - sum) / sig[i], 2.0);
                ++i;
            }
            this.covsrt(covar, ma, ia, mfit);
        }
    }

    private void gaussj(double[][] a, int n, double[][] b, int m) {
        double tmp;
        int l;
        int k;
        int icol = 0;
        int irow = 0;
        int[] indxc = new int[n];
        int[] indxr = new int[n];
        int[] ipiv = new int[n];
        int j = 0;
        while (j < n) {
            ipiv[j] = 0;
            ++j;
        }
        int i = 0;
        while (i < n) {
            double big = 0.0;
            j = 0;
            while (j < n) {
                if (ipiv[j] != 1) {
                    k = 0;
                    while (k < n) {
                        if (ipiv[k] == 0) {
                            if (Math.abs(a[j][k]) >= big) {
                                big = Math.abs(a[j][k]);
                                irow = j;
                                icol = k;
                            }
                        } else if (ipiv[k] > 1) {
                            this.singular = true;
                        }
                        ++k;
                    }
                }
                ++j;
            }
            int n2 = icol;
            ipiv[n2] = ipiv[n2] + 1;
            if (irow != icol) {
                l = 0;
                while (l < n) {
                    tmp = a[irow][l];
                    a[irow][l] = a[icol][l];
                    a[icol][l] = tmp;
                    ++l;
                }
                l = 0;
                while (l < m) {
                    tmp = b[irow][l];
                    b[irow][l] = b[icol][l];
                    b[icol][l] = tmp;
                    ++l;
                }
            }
            indxr[i] = irow;
            indxc[i] = icol;
            if (a[icol][icol] == 0.0) {
                this.singular = true;
            }
            double pivinv = 1.0 / a[icol][icol];
            a[icol][icol] = 1.0;
            l = 0;
            while (l < n) {
                double[] dArray = a[icol];
                int n3 = l++;
                dArray[n3] = dArray[n3] * pivinv;
            }
            l = 0;
            while (l < m) {
                double[] dArray = b[icol];
                int n4 = l++;
                dArray[n4] = dArray[n4] * pivinv;
            }
            int ll = 0;
            while (ll < n) {
                if (ll != icol) {
                    double dum = a[ll][icol];
                    a[ll][icol] = 0.0;
                    l = 0;
                    while (l < n) {
                        double[] dArray = a[ll];
                        int n5 = l;
                        dArray[n5] = dArray[n5] - a[icol][l] * dum;
                        ++l;
                    }
                    l = 0;
                    while (l < m) {
                        double[] dArray = b[ll];
                        int n6 = l;
                        dArray[n6] = dArray[n6] - b[icol][l] * dum;
                        ++l;
                    }
                }
                ++ll;
            }
            ++i;
        }
        l = n - 1;
        while (l >= 0) {
            if (indxr[l] != indxc[l]) {
                k = 0;
                while (k < n) {
                    tmp = a[k][indxr[l]];
                    a[k][indxr[l]] = a[k][indxc[l]];
                    a[k][indxc[l]] = tmp;
                    ++k;
                }
            }
            --l;
        }
    }

    private void covsrt(double[][] covar, int ma, boolean[] ia, int mfit) {
        int j;
        int i = mfit;
        while (i < ma) {
            j = 0;
            while (j <= i) {
                covar[i][j] = 0.0;
                covar[j][i] = 0.0;
                ++j;
            }
            ++i;
        }
        int k = mfit - 1;
        j = ma - 1;
        while (j >= 0) {
            if (ia[j]) {
                double tmp;
                i = 0;
                while (i < ma) {
                    tmp = covar[i][k];
                    covar[i][k] = covar[i][j];
                    covar[i][j] = tmp;
                    ++i;
                }
                i = 0;
                while (i < ma) {
                    tmp = covar[k][i];
                    covar[k][i] = covar[j][i];
                    covar[j][i] = tmp;
                    ++i;
                }
                --k;
            }
            --j;
        }
    }
}

