/*
 * Decompiled with CFR 0.152.
 */
package agent.learn;

import agent.base.AgentComponent;
import agent.base.AgentListener;
import agent.base.ListenerVector;
import agent.learn.DisablesExclusionLearning;
import agent.learn.DistLearning;
import agent.learn.Dists;
import agent.learn.EnablesCircleLearning;
import agent.learn.EnablesExclusionLearning;
import agent.learn.LDist;
import agent.learn.LearnCommunication;
import agent.learn.LearnControl;
import agent.learn.LearnPropertyEventHandler;
import agent.learn.LearnReport;
import agent.learn.LearnedEventListener;
import agent.learn.Nles;
import agent.learn.ScheduleDB;
import agent.learn.ScheduleTimeDB;
import agent.learn.SoftRelationLearning;
import agent.learn.SubscribeDB;
import agent.learn.ToolsLearning;
import agent.learn.ZeroQEffectLearning;
import agent.simplest.ActionEvent;
import agent.simplest.ActionEventListener;
import agent.simplest.Communicate;
import agent.simplest.Execute;
import agent.simplest.GenericPointer;
import agent.simplest.Log;
import agent.simplest.MessageEvent;
import agent.simplest.MessageEventListener;
import agent.simplest.PropertyEvent;
import agent.simplest.PropertyEventListener;
import agent.simplest.State;
import java.util.Vector;
import taems.Method;
import taems.Task;
import utilities.Distribution;
import utilities.Message;

public class Learning
extends AgentComponent
implements ActionEventListener,
MessageEventListener,
PropertyEventListener {
    static final long serialVersionUID = 1234567890L;
    protected ListenerVector listeners = new ListenerVector();
    protected Communicate communicate;
    protected State state;
    protected Log log;
    protected Execute execute;
    protected Integer winsize;
    protected Integer scheduleDBwsize;
    protected Double alpha;
    protected Double nle_estab;
    protected Double Regress_TOL;
    protected int update_interval;
    protected double NleAlphaExperiment;
    protected double NleFitThresh;
    protected boolean Learning;
    protected boolean learnSoft;
    protected boolean learnHard;
    protected boolean learnDist;
    protected boolean learnResource;
    protected boolean SoftRelSourceDependent;
    protected static int FAC_LEARN;
    protected Dists unaffectdist_DB;
    protected Dists affectdist_DB;
    protected Nles nles_DB;
    protected Nles subnles_DB;
    protected Nles resnles_DB;
    protected ScheduleDB scheduleDB;
    protected ScheduleDB cleanscheduleDB;
    protected ScheduleTimeDB scheduleStartDB;
    protected ScheduleTimeDB scheduleEndDB;
    protected SubscribeDB subscribeDB;
    protected GenericPointer NleConfThresh;
    protected GenericPointer setup;
    protected ToolsLearning toolsLearn;
    protected DistLearning distLearn;
    protected EnablesCircleLearning enablesCircleLearn;
    protected EnablesExclusionLearning enablesLearn;
    protected DisablesExclusionLearning disablesLearn;
    protected ZeroQEffectLearning zeroLearn;
    protected SoftRelationLearning softLearn;
    protected LearnPropertyEventHandler learnPropHandler;
    protected LearnReport learnReport;
    protected LearnCommunication learnCommunication;
    protected LearnControl learnControl;

    public void makeBonferoni(int allm, int localm) {
        int k = (allm - 1) * localm;
        this.log.log("k=" + k, 2, FAC_LEARN);
        this.NleConfThresh.obj = new Double(Math.pow(1.0 - this.NleAlphaExperiment, 1.0 / (double)k));
        this.log.log("NleConfSingle=" + this.NleConfThresh.obj, 2, FAC_LEARN);
    }

    private void setSetup(boolean val) {
        this.setup.obj = new Boolean(val);
    }

    public boolean getSetup() {
        return (Boolean)this.setup.obj;
    }

    public double getNleConfThresh() {
        return (Double)this.NleConfThresh.obj;
    }

    public Learning() {
        this.addDependency("Log");
        this.addDependency("State");
        this.addDependency("Communicate");
        this.addDependency("Execute");
        State.addParameterInfo((String)"Learning", (String)"Boolean", (String)"Do you want the learning component to do learning at all?");
        State.addParameterInfo((String)"learnDist", (String)"Boolean", (String)"Do you want the learning component to do learning on distributions?");
        State.addParameterInfo((String)"learnHard", (String)"Boolean", (String)"Do you want the learning component to do learning on hard nles (enables/disables)?");
        State.addParameterInfo((String)"learnSoft", (String)"Boolean", (String)"Do you want the learning component to do learning on soft nle (facilitates/hinders) ?");
        State.addParameterInfo((String)"learnResource", (String)"Boolean", (String)"Do you want the learning component to do learning on resource nle (uses/produces) ?");
        State.addParameterInfo((String)"winsize", (String)"Integer", (String)"Size of the window over learned distributions");
        State.addParameterInfo((String)"scheduleDBwsize", (String)"Integer", (String)"Size of the window over schedules for regression");
        State.addParameterInfo((String)"alpha", (String)"Double", (String)"Threshold on confidence for sending out events about learned distributions ");
        State.addParameterInfo((String)"nle_estab", (String)"Double", (String)"Threshold on confidence for sending out event about learned nles ");
        State.addParameterInfo((String)"Regress_TOL", (String)"Double", (String)"Regression related precission parameter");
        State.addParameterInfo((String)"update_interval", (String)"Integer", (String)"Time difference in terms of timepulses for learning updates");
        State.addParameterInfo((String)"NleAlphaExperiment", (String)"Double", (String)"Experimentwise error for bonferoni adjustment in Regression");
        State.addParameterInfo((String)"RegressFitThresh", (String)"Double", (String)"Threshold for lack of fit test in regression");
        State.addParameterInfo((String)"SoftRelSourceDependent", (String)"Boolean", (String)"Quality of soft NLE target method will depend on quality of source method");
        this.winsize = new Integer(100);
        this.scheduleDBwsize = new Integer(1000);
        this.alpha = new Double(0.05);
        this.nle_estab = new Double(1.0);
        this.Regress_TOL = new Double(1.0E-10);
        this.update_interval = 5;
        this.NleAlphaExperiment = 0.1;
        this.NleFitThresh = 0.05;
        this.Learning = true;
        this.learnSoft = true;
        this.learnHard = true;
        this.learnDist = true;
        this.learnResource = true;
        this.SoftRelSourceDependent = false;
        this.unaffectdist_DB = new Dists(100, 0.75f);
        this.affectdist_DB = new Dists(100, 0.75f);
        this.nles_DB = new Nles(100, 0.75f, 100, 0.75f, 10, 0.75f);
        this.subnles_DB = new Nles(100, 0.75f, 100, 0.75f, 10, 0.75f);
        this.resnles_DB = new Nles(100, 0.75f, 100, 0.75f, 10, 0.75f);
        this.scheduleDB = new ScheduleDB(this.scheduleDBwsize, this.scheduleDBwsize, 0);
        this.cleanscheduleDB = new ScheduleDB(this.scheduleDBwsize, this.scheduleDBwsize, 0);
        this.scheduleStartDB = new ScheduleTimeDB(this.scheduleDBwsize, this.scheduleDBwsize, 0);
        this.scheduleEndDB = new ScheduleTimeDB(this.scheduleDBwsize, this.scheduleDBwsize, 0);
        this.subscribeDB = new SubscribeDB();
        this.NleConfThresh = new GenericPointer((Object)new Double(0.999879));
        this.setup = new GenericPointer((Object)new Boolean(false));
        this.toolsLearn = new ToolsLearning();
        this.distLearn = new DistLearning();
        this.enablesCircleLearn = new EnablesCircleLearning();
        this.enablesLearn = new EnablesExclusionLearning();
        this.disablesLearn = new DisablesExclusionLearning();
        this.zeroLearn = new ZeroQEffectLearning();
        this.softLearn = new SoftRelationLearning();
        this.learnPropHandler = new LearnPropertyEventHandler();
        this.learnReport = new LearnReport();
        this.learnCommunication = new LearnCommunication();
        this.learnControl = new LearnControl();
    }

    public void init() {
        this.state = (State)State.findComponent((String)"State");
        this.log = (Log)State.findComponent((String)"Log");
        this.communicate = (Communicate)State.findComponent((String)"Communicate");
        this.execute = (Execute)State.findComponent((String)"Execute");
        FAC_LEARN = this.log.getFacilityID((AgentComponent)this);
    }

    public void begin() {
        Double tmpdouble;
        Integer tmpint;
        Boolean tmpbool = (Boolean)this.state.getProperty((Object)"Learning");
        if (tmpbool != null) {
            this.Learning = tmpbool;
        }
        if ((tmpbool = (Boolean)this.state.getProperty((Object)"learnDist")) != null) {
            this.learnDist = tmpbool;
        }
        if ((tmpbool = (Boolean)this.state.getProperty((Object)"learnHard")) != null) {
            this.learnHard = tmpbool;
        }
        if ((tmpbool = (Boolean)this.state.getProperty((Object)"learnSoft")) != null) {
            this.learnSoft = tmpbool;
        }
        if ((tmpbool = (Boolean)this.state.getProperty((Object)"learnResource")) != null) {
            this.learnResource = tmpbool;
        }
        if ((tmpint = (Integer)this.state.getProperty((Object)"winsize")) != null) {
            this.winsize = tmpint;
        }
        if ((tmpint = (Integer)this.state.getProperty((Object)"scheduleDBwsize")) != null) {
            this.scheduleDBwsize = tmpint;
        }
        if ((tmpdouble = (Double)this.state.getProperty((Object)"alpha")) != null) {
            this.alpha = tmpdouble;
        }
        if ((tmpdouble = (Double)this.state.getProperty((Object)"nle_estab")) != null) {
            this.nle_estab = tmpdouble;
        }
        if ((tmpdouble = (Double)this.state.getProperty((Object)"Regress_TOL")) != null) {
            this.Regress_TOL = tmpdouble;
        }
        if ((tmpint = (Integer)this.state.getProperty((Object)"update_interval")) != null) {
            this.update_interval = tmpint;
        }
        if ((tmpdouble = (Double)this.state.getProperty((Object)"NleAlphaExperiment")) != null) {
            this.NleAlphaExperiment = tmpdouble;
        }
        if ((tmpdouble = (Double)this.state.getProperty((Object)"NleFitThresh")) != null) {
            this.NleFitThresh = tmpdouble;
        }
        if ((tmpbool = (Boolean)this.state.getProperty((Object)"SoftRelSourceDependent")) != null) {
            this.SoftRelSourceDependent = tmpbool;
        }
        this.log.log("Instantiating ToolsLearn", 5, FAC_LEARN);
        this.toolsLearn.Instantiate(this.learnPropHandler);
        this.log.log("Instantiating DistLearning", 5, FAC_LEARN);
        this.distLearn.Instantiate(this.unaffectdist_DB, this.affectdist_DB, this.nles_DB, this.toolsLearn, this.winsize, this.NleConfThresh);
        this.log.log("Instantiating EnablesCircleLearning", 5, FAC_LEARN);
        this.enablesCircleLearn.Instantiate(this.nles_DB, this.learnControl);
        this.log.log("Instantiating EnablesExclusionLearning", 5, FAC_LEARN);
        this.enablesLearn.Instantiate(this.nles_DB, this.learnControl);
        this.log.log("Instantiating DisablesExclusionLearning", 5, FAC_LEARN);
        this.disablesLearn.Instantiate(this.nles_DB, this.learnControl);
        this.log.log("Instantiating ZeroQEffectLearning", 5, FAC_LEARN);
        this.zeroLearn.Instantiate(this.nles_DB, this.learnControl);
        this.log.log("Instantiating SoftRelationLearning", 5, FAC_LEARN);
        this.softLearn.Instantiate(this.nles_DB, this.unaffectdist_DB, this.scheduleDB, this.cleanscheduleDB, this.Regress_TOL, this.NleConfThresh, this.SoftRelSourceDependent, this.toolsLearn, this.learnControl, this.learnPropHandler);
        this.log.log("Instantiating LearnPropertyEventHandler", 5, FAC_LEARN);
        this.learnPropHandler.Instantiate(this.nles_DB, this.subnles_DB, this.resnles_DB, this.state, this.learnCommunication, this);
        this.log.log("Instantiating LearnReport", 5, FAC_LEARN);
        this.learnReport.Instantiate(this.unaffectdist_DB, this.affectdist_DB, this.nles_DB, this.resnles_DB, this.winsize, this.NleConfThresh, this.learnPropHandler);
        this.log.log("Instantiating LearnCommunication", 5, FAC_LEARN);
        this.learnCommunication.Instantiate(this.unaffectdist_DB, this.nles_DB, this.resnles_DB, this.scheduleDB, this.scheduleStartDB, this.scheduleEndDB, this.subscribeDB, this.listeners, this.communicate, this.winsize, this.learnControl, this.learnPropHandler);
        this.log.log("Instantiating LearnControl", 5, FAC_LEARN);
        this.learnControl.Instantiate(this.unaffectdist_DB, this.affectdist_DB, this.nles_DB, this.resnles_DB, this.scheduleDB, this.cleanscheduleDB, this.scheduleStartDB, this.scheduleEndDB, this.subscribeDB, this.toolsLearn, this.scheduleDBwsize, this.distLearn, this.enablesLearn, this.disablesLearn, this.zeroLearn, this.softLearn, this.learnCommunication, this.learnPropHandler, this.setup, this.winsize, this.update_interval, this.NleFitThresh, this.learnSoft, this.learnHard, this.learnResource, this.learnDist);
        this.execute.addActionEventListener((ActionEventListener)this);
        this.communicate.addMessageEventListener((MessageEventListener)this);
        this.state.addPropertyEventListener((PropertyEventListener)this);
        this.setSetup(true);
    }

    public void resetSchedule() {
        if (this.Learning) {
            this.learnControl.resetSchedule();
        }
    }

    protected Integer getWindowSize() {
        return this.winsize;
    }

    protected LDist getLDist(String m) {
        return this.learnReport.getLDist(m);
    }

    public Distribution getLearnedTaemsMethodDist(String m, int type) {
        return this.learnReport.getTaemsDist(m, type);
    }

    public Method getLearnedTaemsMethod(String m) {
        return this.learnReport.getTaemsMethod(m);
    }

    public Task getLearnedTaemsTask(String t) {
        return null;
    }

    public Vector getLearnedResourceNLEforMethod(String mnane) {
        return null;
    }

    public Vector getLearnedNLEforTask(String mnane) {
        return null;
    }

    public void printAccumDist(String kind, int loglevel) {
        this.learnReport.printAccumDist(kind, loglevel);
    }

    public void printInfoDist(String kind, int loglevel) {
        this.learnReport.printInfoDist(kind, loglevel);
    }

    public void printInfoSoft(int loglevel) {
        this.learnReport.printInfoSoft(loglevel);
    }

    public void printInfoHard(int loglevel) {
        this.learnReport.printInfoHard(loglevel);
    }

    public void addLearnedEventListener(LearnedEventListener l) {
        this.listeners.add((AgentListener)l);
    }

    public void removeLearnedEventListener(LearnedEventListener l) {
        this.listeners.remove((AgentListener)l);
    }

    public void messageSent(MessageEvent e) {
    }

    public void messageReceived(MessageEvent me) {
        Message m = me.getMessage();
        if (this.Learning) {
            this.learnCommunication.parseResource(m);
            this.learnCommunication.parseCompletion(m);
            this.learnCommunication.parseSubscribe(m);
        }
    }

    public void propertyChanged(PropertyEvent e) {
        String key = e.getKey().toString();
        if (this.getSetup() && this.Learning) {
            this.learnPropHandler.updateTaemsTaskStructure(key);
        }
    }

    public void propertyAdded(PropertyEvent e) {
        this.propertyChanged(e);
    }

    public void propertyRemoved(PropertyEvent e) {
    }

    public void actionStarted(ActionEvent e) {
    }

    public void actionAborted(ActionEvent e) {
    }

    public void actionCompleted(ActionEvent e) {
        if (this.Learning) {
            this.learnControl.actionCompleted(e);
        }
    }
}

