/*
 * Decompiled with CFR 0.152.
 */
package agent.learn;

import agent.learn.ChiSquare;
import agent.learn.Dists;
import agent.learn.IntegralDistance;
import agent.learn.LDist;
import agent.learn.LNle;
import agent.learn.LearnPropertyEventHandler;
import agent.learn.Learned;
import agent.learn.LearnedEvent;
import agent.learn.Learning;
import agent.learn.Nles;
import agent.simplest.GenericPointer;
import agent.simplest.Log;
import agent.simplest.State;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import taems.DisablesInterrelationship;
import taems.EnablesInterrelationship;
import taems.FacilitatesInterrelationship;
import taems.HindersInterrelationship;
import taems.Interrelationship;
import taems.Method;
import taems.Node;
import taems.Outcome;
import utilities.Distribution;

public class LearnReport
implements Serializable {
    Dists unaffectdist_DB;
    Dists affectdist_DB;
    Nles nles_DB;
    Nles resnles_DB;
    Integer winsize;
    LearnPropertyEventHandler learnPropHandler;
    GenericPointer NleConfThresh;
    protected Log log;
    protected int FAC_LEARN = Learning.FAC_LEARN;

    public void Instantiate(Dists in_unaffectdist_DB, Dists in_affectdist_DB, Nles in_nles_DB, Nles in_resnles_DB, Integer in_winsize, GenericPointer in_NleConfThresh, LearnPropertyEventHandler in_learnPropHandler) {
        this.unaffectdist_DB = in_unaffectdist_DB;
        this.affectdist_DB = in_affectdist_DB;
        this.nles_DB = in_nles_DB;
        this.resnles_DB = in_resnles_DB;
        this.winsize = in_winsize;
        this.learnPropHandler = in_learnPropHandler;
        this.NleConfThresh = in_NleConfThresh;
        this.log = (Log)State.findComponent((String)"Log");
        this.FAC_LEARN = Learning.FAC_LEARN;
    }

    public LDist getLDist(String m) {
        LDist newdist = (LDist)this.unaffectdist_DB.get(m);
        return newdist;
    }

    public Distribution getTaemsDist(String m, int type) {
        LDist newdist = (LDist)this.unaffectdist_DB.get(m);
        if (newdist != null) {
            newdist.getTaemsDist(type);
        }
        return null;
    }

    public Method getTaemsMethod(String m) {
        LDist newdist = (LDist)this.unaffectdist_DB.get(m);
        if (newdist != null) {
            Distribution q = newdist.getTaemsDist(0);
            Distribution c = newdist.getTaemsDist(1);
            Distribution d = newdist.getTaemsDist(2);
            Method oldnode = (Method)this.learnPropHandler.getSubjective().findNode((Node)new Method(m, null));
            if (oldnode != null) {
                Method oldnodeclone = (Method)oldnode.clone();
                Outcome o1 = oldnodeclone.getGlobalOutcome();
                o1.setDuration(d);
                o1.setCost(c);
                o1.setQuality(q);
                return oldnodeclone;
            }
            return null;
        }
        return null;
    }

    public LNle getLNle(String mx, String my, String rel) {
        Vector entry = this.nles_DB.getEntry(mx, my, rel);
        if (entry != null) {
            String stat = (String)entry.elementAt(0);
            Double conf = (Double)entry.elementAt(1);
            LDist power = (LDist)entry.elementAt(2);
            LNle relation = new LNle(mx, my, rel, stat, conf, power);
            return relation;
        }
        return null;
    }

    public LNle getResourceLNle(String mx, String my, String rel) {
        Vector entry = this.resnles_DB.getEntry(mx, my, rel);
        if (entry != null) {
            String stat = (String)entry.elementAt(0);
            Double conf = (Double)entry.elementAt(1);
            LDist power = (LDist)entry.elementAt(2);
            LNle relation = new LNle(mx, my, rel, stat, conf, power);
            return relation;
        }
        return null;
    }

    public LearnedEvent isWrongDistribution(String mname, int type) {
        if (type == 0) {
            this.log.log("Checking quality distribution", 5, this.FAC_LEARN);
        } else if (type == 1) {
            this.log.log("Checking cost distribution", 5, this.FAC_LEARN);
        } else if (type == 2) {
            this.log.log("Checking duration distribution", 5, this.FAC_LEARN);
        } else {
            this.log.log("unknown distribution type", 5, this.FAC_LEARN);
            return null;
        }
        LDist learned_unaffect = (LDist)this.unaffectdist_DB.get(mname);
        Method sub_node = (Method)this.learnPropHandler.getSubjective().findNode((Node)new Method(mname, null));
        if (sub_node != null && learned_unaffect != null) {
            int anz = learned_unaffect.getStatNum();
            Outcome o1 = sub_node.getGlobalOutcome();
            ChiSquare chi = new ChiSquare(learned_unaffect, o1, type);
            Learned l = new Learned(learned_unaffect, new Double(chi.getProb()));
            return new LearnedEvent(this, l, 0);
        }
        this.log.log(" Method " + mname + " not found in subjective view or learned table!!!", 4, this.FAC_LEARN);
        return null;
    }

    public LearnedEvent isWrongNle(String mx, String my, String mz) {
        LNle tmpobj = this.getLNle(mx, my, mz);
        if (tmpobj != null) {
            Learned l = new Learned(tmpobj, tmpobj.getConfidence());
            return new LearnedEvent(this, l, 1);
        }
        return null;
    }

    public LearnedEvent isWrongResourceNle(String mx, String my, String mz) {
        LNle tmpobj = this.getResourceLNle(mx, my, mz);
        if (tmpobj != null) {
            Learned l = new Learned(tmpobj, tmpobj.getConfidence());
            return new LearnedEvent(this, l, 2);
        }
        return null;
    }

    public void printAccumDist(String kind, int loglevel) {
        this.log.log("Cumulative dists for " + kind, loglevel, this.FAC_LEARN);
        Enumeration e1 = this.learnPropHandler.getLocalMethods().elements();
        while (e1.hasMoreElements()) {
            String mname = (String)e1.nextElement();
            this.log.log("", loglevel, this.FAC_LEARN);
            this.log.log("Method=" + mname, loglevel, this.FAC_LEARN);
            LDist learned_unaffect = null;
            if (kind.equals("UNAFFECT")) {
                learned_unaffect = (LDist)this.unaffectdist_DB.get(mname);
            }
            if (kind.equals("AFFECT")) {
                learned_unaffect = (LDist)this.affectdist_DB.get(mname);
            }
            if (learned_unaffect != null) {
                Vector sortkeys = learned_unaffect.getSortedKeys(0);
                Hashtable vals = learned_unaffect.getCountDist(0);
                double sumsofar = 0.0;
                int i = 0;
                while (i < sortkeys.size()) {
                    Double tmpkey = (Double)sortkeys.elementAt(i);
                    Integer times = (Integer)vals.get(tmpkey);
                    double tmpsum = tmpkey * (double)times.intValue();
                    this.log.log("ACCUM-SUM-" + mname + "-" + kind + ": x=" + tmpkey + " y=" + (sumsofar += tmpsum), loglevel, this.FAC_LEARN);
                    ++i;
                }
            } else {
                this.log.log("No data present for " + mname, loglevel, this.FAC_LEARN);
            }
            if (this.learnPropHandler.getObjective() != null) {
                Method sub_node = (Method)this.learnPropHandler.getObjective().findNode((Node)new Method(mname, null));
                if (sub_node == null || learned_unaffect == null) continue;
                int anz = 100;
                Outcome o1 = sub_node.getGlobalOutcome();
                LDist subject_unaffect = new LDist(mname, this.winsize, o1.getQuality(), o1.getCost(), o1.getDuration(), anz);
                Vector skeys = subject_unaffect.getSortedKeys(0);
                Hashtable valss = subject_unaffect.getCountDist(0);
                double ssfar = 0.0;
                int i = 0;
                while (i < skeys.size()) {
                    Double tmpkey = (Double)skeys.elementAt(i);
                    Integer times = (Integer)valss.get(tmpkey);
                    double tmpsum = tmpkey * (double)times.intValue();
                    this.log.log("ACCUM-SUM-" + mname + "-OBJECTIVE: x=" + tmpkey + " y=" + (ssfar += tmpsum), loglevel, this.FAC_LEARN);
                    ++i;
                }
                continue;
            }
            this.log.log("OOPs : Need Mike's AsggOrgDesign hack to run appropriately: Hack putsobjective view into state component  under label ObjTaemsTask", loglevel, this.FAC_LEARN);
        }
    }

    public void printInfoDist(String kind, int loglevel) {
        double valsum = 0.0;
        Enumeration e1 = this.learnPropHandler.getLocalMethods().elements();
        while (e1.hasMoreElements()) {
            String mname = (String)e1.nextElement();
            LDist learned_unaffect = null;
            if (kind.equals("UNAFFECT")) {
                learned_unaffect = (LDist)this.unaffectdist_DB.get(mname);
            }
            if (kind.equals("AFFECT")) {
                learned_unaffect = (LDist)this.affectdist_DB.get(mname);
            }
            if (this.learnPropHandler.getObjective() != null) {
                Method sub_node = (Method)this.learnPropHandler.getObjective().findNode((Node)new Method(mname, null));
                if (sub_node != null && learned_unaffect != null) {
                    int anz = 100;
                    Outcome o1 = sub_node.getGlobalOutcome();
                    LDist subject_unaffect = new LDist(mname, this.winsize, o1.getQuality(), o1.getCost(), o1.getDuration(), anz);
                    LDist[] ds = new LDist[]{learned_unaffect, subject_unaffect};
                    IntegralDistance ksd = new IntegralDistance(ds, 0);
                    this.log.log("IGD for " + kind + " " + mname + " = " + ksd.getValue(), loglevel, this.FAC_LEARN);
                    valsum += ksd.getValue();
                    continue;
                }
                this.log.log("IGD = 1 for empty distribution m=" + mname, loglevel, this.FAC_LEARN);
                valsum += 1.0;
                continue;
            }
            this.log.log("OOPs : Need Mike's AsggOrgDesign hack to run appropriately: Hack putsobjective view into state component under label ObjTaemsTask", loglevel, this.FAC_LEARN);
        }
        this.log.log("IGD-VAL-SUM-" + kind + " = " + valsum, loglevel, this.FAC_LEARN);
    }

    public void printInfoSoft(int loglevel) {
        this.log.log("Difference in Power factors", loglevel, this.FAC_LEARN);
        double powerdiff = 0.0;
        int misclassdiff = 0;
        int numsoft = 0;
        if (this.learnPropHandler.getObjective() != null) {
            Enumeration e10 = this.learnPropHandler.getObjective().findNodes((Node)new Interrelationship());
            while (e10.hasMoreElements()) {
                Interrelationship inter = (Interrelationship)e10.nextElement();
                if (!(inter instanceof FacilitatesInterrelationship) && !(inter instanceof HindersInterrelationship)) continue;
                ++numsoft;
            }
            Enumeration enum1 = this.nles_DB.get1stkeys();
            while (enum1.hasMoreElements()) {
                String tmpname = (String)enum1.nextElement();
                Enumeration enum2 = this.nles_DB.get2ndkeys(tmpname);
                while (enum2.hasMoreElements()) {
                    String tmpname2 = (String)enum2.nextElement();
                    Vector entry = this.nles_DB.getEntry(tmpname, tmpname2, "softrel");
                    LDist powdist = (LDist)entry.elementAt(2);
                    Double sigq = (Double)powdist.getDataDist(0).elementAt(1);
                    Double fitq = (Double)powdist.getDataDist(0).elementAt(2);
                    Double factor_learn = new Double(1.0);
                    if (sigq >= (Double)this.NleConfThresh.obj) {
                        factor_learn = (Double)powdist.getDataDist(0).elementAt(0);
                    }
                    boolean numofsoft = false;
                    Interrelationship found = null;
                    Enumeration e1 = this.learnPropHandler.getObjective().findNodes((Node)new Interrelationship());
                    while (e1.hasMoreElements()) {
                        Interrelationship inter = (Interrelationship)e1.nextElement();
                        if (!inter.getFrom().getLabel().equals(tmpname2) || !inter.getTo().getLabel().equals(tmpname) || !(inter instanceof FacilitatesInterrelationship) && !(inter instanceof HindersInterrelationship)) continue;
                        found = inter;
                    }
                    Double factor_objective = new Double(1.0);
                    double delta = 0.0;
                    if (found != null) {
                        factor_objective = new Double(found.getQuality().calculateAvg());
                        delta = Math.abs(factor_objective - factor_learn);
                        if (delta > 0.0) {
                            this.log.log("Power-delta: " + found.getFrom().getLabel() + " -> " + found.getTo().getLabel() + " , obj=" + factor_objective + ", learned=" + factor_learn + " delta=" + delta + " conf=" + sigq, loglevel, this.FAC_LEARN);
                        }
                    } else {
                        delta = Math.abs(factor_objective - factor_learn);
                        if (delta > 0.0) {
                            this.log.log("Power-delta: " + tmpname2 + " -> " + tmpname + " , obj= - , learned=" + factor_learn + " delta=" + delta + " conf=" + sigq, loglevel, this.FAC_LEARN);
                        }
                    }
                    powerdiff += delta;
                    if (found != null) {
                        if (factor_learn == 1.0 && !(sigq > 0.0)) continue;
                        ++misclassdiff;
                        continue;
                    }
                    if (factor_learn != 1.0 && sigq != 0.0) continue;
                    ++misclassdiff;
                }
            }
            this.log.log("POWER-DELTA-SUM = " + powerdiff, loglevel, this.FAC_LEARN);
            this.log.log("NumofSoft=" + numsoft, loglevel, this.FAC_LEARN);
            this.log.log("POWER-DELTA-QUOT = " + powerdiff / (double)numsoft, loglevel, this.FAC_LEARN);
            this.log.log("SoftM=" + misclassdiff, loglevel, this.FAC_LEARN);
        } else {
            this.log.log("OOPs : Need Mike's AsggOrgDesign hack to run appropriately: Hack puts objective view into state component under label ObjTaemsTask", loglevel, this.FAC_LEARN);
        }
    }

    public void printInfoHard(int loglevel) {
        int numhard = 0;
        int diffcount = 0;
        int x = this.learnPropHandler.getLocalMethods().size();
        int maxnle = x * (x - 1) * 2;
        double diffratio = 0.0;
        if (this.learnPropHandler.getObjective() != null) {
            Enumeration enum1 = this.nles_DB.get1stkeys();
            while (enum1.hasMoreElements()) {
                String tmpname = (String)enum1.nextElement();
                Enumeration enum2 = this.nles_DB.get2ndkeys(tmpname);
                while (enum2.hasMoreElements()) {
                    Interrelationship inter;
                    String tmpname2 = (String)enum2.nextElement();
                    Vector entry = this.nles_DB.getEntry(tmpname, tmpname2, "enables");
                    Interrelationship found = null;
                    Enumeration e1 = this.learnPropHandler.getObjective().findNodes((Node)new Interrelationship());
                    while (e1.hasMoreElements()) {
                        inter = (Interrelationship)e1.nextElement();
                        if (!inter.getFrom().getLabel().equals(tmpname2) || !inter.getTo().getLabel().equals(tmpname) || !(inter instanceof EnablesInterrelationship)) continue;
                        found = inter;
                    }
                    if (found != null) {
                        ++numhard;
                        if (((String)entry.elementAt(0)).equals("N")) {
                            ++diffcount;
                        }
                    } else if (((String)entry.elementAt(0)).equals("X")) {
                        ++diffcount;
                    }
                    entry = this.nles_DB.getEntry(tmpname, tmpname2, "disables");
                    found = null;
                    e1 = this.learnPropHandler.getObjective().findNodes((Node)new Interrelationship());
                    while (e1.hasMoreElements()) {
                        inter = (Interrelationship)e1.nextElement();
                        if (!inter.getFrom().getLabel().equals(tmpname2) || !inter.getTo().getLabel().equals(tmpname) || !(inter instanceof DisablesInterrelationship)) continue;
                        found = inter;
                    }
                    if (found != null) {
                        ++numhard;
                        if (!((String)entry.elementAt(0)).equals("N")) continue;
                        ++diffcount;
                        continue;
                    }
                    if (!((String)entry.elementAt(0)).equals("X")) continue;
                    ++diffcount;
                }
            }
            diffratio = (double)diffcount / (double)maxnle;
            this.log.log("Numhard=" + numhard, loglevel, this.FAC_LEARN);
            this.log.log("MaxHardNle= " + maxnle + " DiffCount=" + diffcount + " ratio=" + diffratio, loglevel, this.FAC_LEARN);
        } else {
            this.log.log("OOPs : Need Mike's AsggOrgDesign hack to run appropriately: Hack puts objective view into state component under label ObjTaemsTask", loglevel, this.FAC_LEARN);
        }
    }
}

