/*
 * Decompiled with CFR 0.152.
 */
package agent.learn;

import agent.base.ListenerVector;
import agent.learn.Dists;
import agent.learn.LDist;
import agent.learn.LearnControl;
import agent.learn.LearnPropertyEventHandler;
import agent.learn.LearnedEvent;
import agent.learn.LearnedEventListener;
import agent.learn.Learning;
import agent.learn.Nles;
import agent.learn.ScheduleDB;
import agent.learn.ScheduleObj;
import agent.learn.ScheduleTimeDB;
import agent.learn.SubscribeDB;
import agent.simplest.Communicate;
import agent.simplest.Log;
import agent.simplest.State;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import utilities.KQMLMessage;
import utilities.Message;

public class LearnCommunication
implements Serializable {
    Dists unaffectdist_DB;
    Nles nles_DB;
    Nles resnles_DB;
    ScheduleDB scheduleDB;
    ScheduleTimeDB scheduleStartDB;
    ScheduleTimeDB scheduleEndDB;
    SubscribeDB subscribeDB;
    ListenerVector listeners;
    Communicate communicate;
    Integer winsize;
    LearnControl learnControl;
    LearnPropertyEventHandler learnPropHandler;
    protected Log log;
    protected int FAC_LEARN = Learning.FAC_LEARN;

    public void Instantiate(Dists in_unaffectdist_DB, Nles in_nles_DB, Nles in_resnles_DB, ScheduleDB in_scheduleDB, ScheduleTimeDB in_scheduleStartDB, ScheduleTimeDB in_scheduleEndDB, SubscribeDB in_subscribeDB, ListenerVector in_listeners, Communicate in_communicate, Integer in_winsize, LearnControl in_learnControl, LearnPropertyEventHandler in_learnPropHandler) {
        this.unaffectdist_DB = in_unaffectdist_DB;
        this.nles_DB = in_nles_DB;
        this.resnles_DB = in_resnles_DB;
        this.scheduleDB = in_scheduleDB;
        this.scheduleStartDB = in_scheduleStartDB;
        this.scheduleEndDB = in_scheduleEndDB;
        this.subscribeDB = in_subscribeDB;
        this.listeners = in_listeners;
        this.communicate = in_communicate;
        this.winsize = in_winsize;
        this.learnControl = in_learnControl;
        this.learnPropHandler = in_learnPropHandler;
        this.log = (Log)State.findComponent((String)"Log");
        this.FAC_LEARN = Learning.FAC_LEARN;
    }

    protected void fireLearnedEvent(LearnedEvent e) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            LearnedEventListener l = (LearnedEventListener)enumeration.nextElement();
            switch (e.getID()) {
                case 0: {
                    l.learnedMethodDistribution(e);
                    break;
                }
                case 1: {
                    l.learnedNle(e);
                    break;
                }
            }
        }
        if (this.log != null) {
            this.log.log((Object)e, 2, this.FAC_LEARN);
        }
    }

    public void checkEvents(ScheduleObj entry) {
        String string = entry.getName();
    }

    public void sendResult(ScheduleObj method) {
        Vector agents = (Vector)this.subscribeDB.get(method.getName());
        if (agents != null) {
            Enumeration enumeration = agents.elements();
            while (enumeration.hasMoreElements()) {
                String agent = (String)enumeration.nextElement();
                KQMLMessage message = new KQMLMessage("MethodResult", (Object)("( " + method.getName() + " " + method.getQuality() + " " + method.getCost() + " " + method.getDuration() + " " + method.getStart() + " " + method.getFinish() + " )"), agent);
                this.communicate.sendMessage((Message)message);
            }
        }
    }

    public void insertReportedMethod(ScheduleObj reportmeth, Vector sched) {
        int schedsize = sched.size();
        int reportfinish = reportmeth.getFinish();
        boolean notinserted = true;
        int pos = 0;
        while (pos < schedsize && notinserted) {
            ScheduleObj tmpmeth = (ScheduleObj)sched.elementAt(pos);
            if (reportfinish <= tmpmeth.getStart()) {
                sched.insertElementAt(reportmeth, pos);
                notinserted = false;
                continue;
            }
            ++pos;
        }
    }

    public void parseResource(Message m) {
        if (m.getSourceAddr().equalsIgnoreCase("Simulator") && m.contentWord().equalsIgnoreCase("ExecuteEnd")) {
            String content = m.contentData();
            StringTokenizer s = new StringTokenizer(content, " ");
            String method = s.nextToken();
            String resource = null;
            Double usage = null;
            while (s.hasMoreTokens()) {
                if (!s.nextToken().equalsIgnoreCase("Used")) continue;
                resource = s.nextToken();
                usage = new Double(s.nextToken());
            }
            if (resource != null && usage != null) {
                this.learnControl.setResnlesChanged(true);
                LDist olddist = this.resnles_DB.getPower(resource, method, "uses");
                if (olddist == null) {
                    this.resnles_DB.putEntry(resource, method, "uses", "X", 1.0, new LDist(resource, this.winsize, new Double(0.0), usage, new Double(0.0)));
                } else {
                    olddist.addElement(new Double(0.0), usage, new Double(0.0));
                }
            }
        }
    }

    public void parseCompletion(Message m) {
        if (m.contentWord().equalsIgnoreCase("MethodResult")) {
            String content = m.contentData();
            StringTokenizer s = new StringTokenizer(content, " ");
            String method = s.nextToken();
            Double q = new Double(s.nextToken());
            Double c = new Double(s.nextToken());
            Double d = new Double(s.nextToken());
            Integer start = new Integer(s.nextToken());
            Integer finish = new Integer(s.nextToken());
            ScheduleObj reported = new ScheduleObj(method, q, c, d, start, finish, false, m.getSourceAddr());
            int schednum = this.scheduleDB.size();
            int mstart = start;
            int mfinish = finish;
            boolean added = false;
            int i = 0;
            while (i < schednum) {
                int tmpstart = (Integer)this.scheduleStartDB.elementAt(i);
                int tmpfinish = (Integer)this.scheduleEndDB.elementAt(i);
                if (tmpstart <= mstart && mfinish <= tmpfinish) {
                    this.insertReportedMethod(reported, (Vector)this.scheduleDB.elementAt(i));
                    added = true;
                }
                ++i;
            }
            if (mstart >= (Integer)this.scheduleStartDB.elementAt(schednum + 1)) {
                this.insertReportedMethod(reported, this.learnControl.getCurrentSchedule());
                added = true;
            }
            if (!added) {
                this.log.log("ERROR: got result=" + reported + " but could not add it to scheduleDB", 0, this.FAC_LEARN);
            }
        }
    }

    public void parseSubscribe(Message m) {
        if (m.contentWord().equalsIgnoreCase("subscribe")) {
            String content = m.contentData();
            StringTokenizer s = new StringTokenizer(content, " ");
            String method = s.nextToken();
            Integer time = new Integer(s.nextToken());
            if (!this.learnPropHandler.getLocalMethods().contains(method)) {
                this.log.log("Subscribe request: Method " + method + " does not belong to me!!!", 0, this.FAC_LEARN);
            } else {
                Vector<String> sagents = (Vector<String>)this.subscribeDB.get(method);
                if (sagents == null) {
                    sagents = new Vector<String>();
                    this.subscribeDB.put(method, sagents);
                }
                sagents.addElement(m.getSourceAddr());
            }
        }
    }

    public void sendSubscribe() {
    }
}

